/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

final class GridRenderer {
    private GridRenderer() {
    }

    static void render(class_332 g, class_327 font, int mapX, int mapY, int mapW, int mapH, int innerPad, double viewMinX, double viewMaxX, double viewMinZ, double viewMaxZ, int colorGrid, int gridTargetPx, int colorText) {
        class_5250 labelComp;
        int left = mapX + innerPad;
        int top = mapY + innerPad;
        int right = mapX + mapW - innerPad;
        int bottom = mapY + mapH - innerPad;
        int contentW = mapW - innerPad * 2;
        int contentH = mapH - innerPad * 2;
        double ppbX = (double)contentW / Math.max(1.0, viewMaxX - viewMinX);
        double ppbZ = (double)contentH / Math.max(1.0, viewMaxZ - viewMinZ);
        double ppb = (ppbX + ppbZ) * 0.5;
        int step = GridRenderer.snapStep((int)Math.round((double)gridTargetPx / Math.max(0.001, ppb)));
        int startX = (int)Math.floor(viewMinX / (double)step) * step;
        int endX = (int)Math.ceil(viewMaxX / (double)step) * step;
        for (int wx = startX; wx <= endX; wx += step) {
            int sx = GridRenderer.toScreenX(wx, mapX, mapW, innerPad, viewMinX, viewMaxX);
            if (sx < left || sx > right) continue;
            g.method_25294(sx, top, sx + 1, bottom, colorGrid);
        }
        int startZ = (int)Math.floor(viewMinZ / (double)step) * step;
        int endZ = (int)Math.ceil(viewMaxZ / (double)step) * step;
        for (int wz = startZ; wz <= endZ; wz += step) {
            int sy = GridRenderer.toScreenY(wz, mapY, mapH, innerPad, viewMinZ, viewMaxZ);
            if (sy < top || sy > bottom) continue;
            g.method_25294(left, sy, right, sy + 1, colorGrid);
        }
        if (step % 16 == 0) {
            int chunks = step / 16;
            labelComp = class_2561.method_43469((String)"gui.roadweaver.map.grid.scale.chunks_blocks", (Object[])new Object[]{chunks, step});
        } else {
            labelComp = class_2561.method_43469((String)"gui.roadweaver.map.grid.scale.blocks", (Object[])new Object[]{step});
        }
        int pad = 4;
        int tw = font.method_27525((class_5348)labelComp);
        int tx = right - tw - pad;
        Objects.requireNonNull(font);
        int ty = bottom - 9 - pad;
        g.method_51439(font, (class_2561)labelComp, tx, ty, colorText, false);
    }

    static int computeGridStep(int mapX, int mapY, int mapW, int mapH, int innerPad, double viewMinX, double viewMaxX, double viewMinZ, double viewMaxZ, int gridTargetPx) {
        int contentW = mapW - innerPad * 2;
        int contentH = mapH - innerPad * 2;
        double ppbX = (double)contentW / Math.max(1.0, viewMaxX - viewMinX);
        double ppbZ = (double)contentH / Math.max(1.0, viewMaxZ - viewMinZ);
        double ppb = (ppbX + ppbZ) * 0.5;
        int approx = (int)Math.round((double)gridTargetPx / Math.max(0.001, ppb));
        return GridRenderer.snapStep(approx);
    }

    private static int toScreenX(int blockX, int mapX, int mapW, int innerPad, double viewMinX, double viewMaxX) {
        int contentW = mapW - innerPad * 2;
        double rangeX = Math.max(1.0, viewMaxX - viewMinX);
        double nx = ((double)blockX - viewMinX) / rangeX;
        return mapX + innerPad + (int)Math.round(nx * (double)contentW);
    }

    private static int toScreenY(int blockZ, int mapY, int mapH, int innerPad, double viewMinZ, double viewMaxZ) {
        int contentH = mapH - innerPad * 2;
        double rangeZ = Math.max(1.0, viewMaxZ - viewMinZ);
        double nz = ((double)blockZ - viewMinZ) / rangeZ;
        return mapY + innerPad + (int)Math.round(nz * (double)contentH);
    }

    private static int snapStep(int approx) {
        int[] steps = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192};
        if (approx <= 1) {
            return 1;
        }
        for (int s : steps) {
            if (approx > s) continue;
            return s;
        }
        return steps[steps.length - 1];
    }
}

