/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.ui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public final class ContextMenu {
    public static final int PADDING = 6;
    public static final int ITEM_HEIGHT = 14;
    private int x;
    private int y;
    private int width;
    private int height;
    private final List<Item> items = new ArrayList<Item>();
    private boolean open = false;

    public void open(int x, int y) {
        this.x = x;
        this.y = y;
        this.open = true;
    }

    public void close() {
        this.open = false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void clearItems() {
        this.items.clear();
    }

    public void addItem(class_2561 label, Runnable action) {
        this.items.add(new Item(label, action));
    }

    public void layout(class_327 font) {
        int w = 0;
        for (Item it : this.items) {
            w = Math.max(w, font.method_27525((class_5348)it.label));
        }
        this.width = w + 12;
        this.height = 6 + this.items.size() * 14 + 6;
    }

    public void render(class_332 g, class_327 font, int screenW, int screenH) {
        if (!this.open) {
            return;
        }
        this.layout(font);
        int rx = Math.min(this.x, Math.max(0, screenW - this.width));
        int ry = Math.min(this.y, Math.max(0, screenH - this.height));
        int bg = -299160789;
        int border = -1;
        g.method_25294(rx - 1, ry - 1, rx + this.width + 1, ry + this.height + 1, border);
        g.method_25294(rx, ry, rx + this.width, ry + this.height, bg);
        int ty = ry + 6;
        for (int i = 0; i < this.items.size(); ++i) {
            Item it = this.items.get(i);
            g.method_51439(font, it.label, rx + 6, ty + 3, -1, false);
            ty += 14;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.open) {
            return false;
        }
        if (button != 0) {
            return false;
        }
        int rx = this.x;
        int ry = this.y;
        if (mouseX < (double)rx || mouseX > (double)(rx + this.width) || mouseY < (double)ry || mouseY > (double)(ry + this.height)) {
            this.close();
            return true;
        }
        int idx = (int)((mouseY - (double)ry - 6.0) / 14.0);
        if (idx >= 0 && idx < this.items.size()) {
            Item it = this.items.get(idx);
            this.close();
            if (it.action != null) {
                it.action.run();
            }
            return true;
        }
        this.close();
        return true;
    }

    public static final class Item {
        public final class_2561 label;
        public final Runnable action;

        public Item(class_2561 label, Runnable action) {
            this.label = label;
            this.action = action;
        }
    }
}

