/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.decoration.Decoration;
import net.shiroha233.roadweaver.features.decoration.RoadStructures;
import net.shiroha233.roadweaver.features.decoration.system.DecorationPlanner;
import net.shiroha233.roadweaver.features.roadlogic.BridgeRangeCalculator;
import net.shiroha233.roadweaver.features.roadlogic.BridgeSegmentPlanner;
import net.shiroha233.roadweaver.features.roadlogic.BridgeTransitionAdjuster;
import net.shiroha233.roadweaver.features.roadlogic.HeightProfileService;
import net.shiroha233.roadweaver.features.roadlogic.SegmentPaver;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;

public class RoadFeature
extends class_3031<RoadFeatureConfig> {
    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<RoadFeatureConfig> ctx) {
        class_5281 world = ctx.method_33652();
        class_3218 lvl = world.method_8410();
        if (!(lvl instanceof class_3218)) {
            return false;
        }
        class_3218 server = lvl;
        class_1923 currentChunk = new class_1923(ctx.method_33655());
        int minX = currentChunk.method_8326();
        int minZ = currentChunk.method_8328();
        int maxX = currentChunk.method_8327();
        int maxZ = currentChunk.method_8329();
        List<Records.RoadData> roadDataList = RoadShardStorage.queryRect(server, minX, minZ, maxX, maxZ);
        if (roadDataList == null || roadDataList.isEmpty()) {
            return false;
        }
        HashSet<class_2338> processedMiddle = new HashSet<class_2338>();
        class_5819 random = ctx.method_33654();
        ModConfig cfg = ConfigService.get();
        int averagingRadius = Math.max(0, cfg.averagingRadius());
        HashSet<Decoration> decorations = new HashSet<Decoration>();
        for (Records.RoadData data : roadDataList) {
            int roadType = data.roadType();
            int roadWidth = Math.max(1, data.width());
            List<class_2680> materials = data.materials();
            List<Records.RoadSegmentPlacement> segments = data.roadSegmentList();
            if (segments == null || segments.size() < 5) continue;
            List<class_2338> middlePositions = segments.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
            boolean[] isBridge = new boolean[middlePositions.size()];
            List<Object> bridgeRanges = new ArrayList();
            BridgeRangeCalculator.RangeResult res = BridgeRangeCalculator.compute(middlePositions, data.spans());
            isBridge = res.isBridge();
            bridgeRanges = res.mergedRanges();
            List<Integer> targetY = data.targetY();
            HeightProfileService.HeightProfile hp = HeightProfileService.build(world, middlePositions, currentChunk, averagingRadius, cfg, targetY);
            boolean usePersisted = hp.usePersisted();
            int[] smoothedYArr = hp.smoothedY();
            int[] baseYArr = usePersisted && targetY != null && targetY.size() == middlePositions.size() ? targetY.stream().mapToInt(Integer::intValue).toArray() : smoothedYArr;
            if (baseYArr != null && cfg.bridgeEnabled() && !bridgeRanges.isEmpty()) {
                baseYArr = BridgeTransitionAdjuster.adjust(baseYArr, bridgeRanges, cfg);
            }
            int deckY = server.method_8615() + cfg.bridgeDeckClearance();
            int segmentIndex = 0;
            BridgeSegmentPlanner.Context bridgeCtx = BridgeSegmentPlanner.newContext();
            for (int i = 2; i < segments.size() - 2; ++i) {
                class_1923 middleChunk;
                class_2338 middle = middlePositions.get(i);
                if (!processedMiddle.add(middle) || ++segmentIndex < 60 || segmentIndex > segments.size() - 60 || !(middleChunk = new class_1923(middle)).equals((Object)currentChunk)) continue;
                class_2338 prev = middlePositions.get(i - 2);
                class_2338 next = middlePositions.get(i + 2);
                int topYCenter = world.method_8624(class_2902.class_2903.field_13203, middle.method_10263(), middle.method_10260());
                class_2338 averaged = new class_2338(middle.method_10263(), topYCenter, middle.method_10260());
                int baseYForThis = baseYArr != null ? baseYArr[i] : topYCenter;
                Records.RoadSegmentPlacement seg = segments.get(i);
                if (cfg.bridgeEnabled() && isBridge[i]) {
                    BridgeSegmentPlanner.processSegment(world, seg, middle, prev, next, roadWidth, baseYForThis, deckY, segmentIndex, random, cfg, bridgeRanges, i, bridgeCtx);
                } else {
                    SegmentPaver.paveSegment(world, seg, baseYForThis, roadType, materials, random, cfg);
                }
                if (isBridge[i] && !cfg.bridgeKeepLamps()) continue;
                DecorationPlanner.addDecoration(world, decorations, averaged, segmentIndex, next, prev, middlePositions, roadWidth, random, cfg, roadType == 0 ? DecorationPlanner.Mode.ARTIFICIAL : DecorationPlanner.Mode.NATURAL);
            }
        }
        RoadStructures.tryPlaceDecorations(decorations);
        return true;
    }
}

