/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration;

import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_5281;
import net.shiroha233.roadweaver.features.decoration.OrientedDecoration;
import net.shiroha233.roadweaver.features.decoration.util.BiomeWoodAware;
import net.shiroha233.roadweaver.features.decoration.util.SignTextService;
import net.shiroha233.roadweaver.helpers.Records;

public class DistanceSignDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private final boolean isStart;
    private final String signText;
    private Records.WoodAssets wood;

    public DistanceSignDecoration(class_2338 pos, class_2382 direction, class_5281 world, boolean isStart, String distanceText) {
        super(pos, direction, world);
        this.isStart = isStart;
        this.signText = distanceText;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        int rotation = this.getCardinalRotationFromVector(this.getOrthogonalVector(), this.isStart);
        OrientedDecoration.DirectionProperties props = this.getDirectionProperties(rotation);
        class_2338 basePos = this.getPos();
        class_5281 world = this.getWorld();
        class_2338 signPos = basePos.method_10086(2).method_10093(props.offsetDirection.method_10153());
        world.method_8652(signPos, (class_2680)((class_2680)this.wood.hangingSign().method_9564().method_11657((class_2769)class_2741.field_12532, (Comparable)Integer.valueOf(rotation))).method_11657((class_2769)class_2741.field_12493, (Comparable)Boolean.valueOf(true)), 3);
        this.updateSigns(world, signPos, this.signText);
        this.placeFenceStructure(basePos, props);
    }

    private void placeFenceStructure(class_2338 pos, OrientedDecoration.DirectionProperties props) {
        class_5281 world = this.getWorld();
        world.method_8652(pos.method_10086(3).method_10093(props.offsetDirection.method_10153()), (class_2680)this.wood.fence().method_9564().method_11657((class_2769)props.directionProperty, (Comparable)Boolean.valueOf(true)), 3);
        world.method_8652(pos.method_10086(0), this.wood.fence().method_9564(), 3);
        world.method_8652(pos.method_10086(1), this.wood.fence().method_9564(), 3);
        world.method_8652(pos.method_10086(2), this.wood.fence().method_9564(), 3);
        world.method_8652(pos.method_10086(3), (class_2680)this.wood.fence().method_9564().method_11657((class_2769)props.reverseDirectionProperty, (Comparable)Boolean.valueOf(true)), 3);
    }

    private void updateSigns(class_5281 level, class_2338 pos, String text) {
        SignTextService.writeDistanceSign(level, pos, text);
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

