/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.system;

import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.decoration.Decoration;
import net.shiroha233.roadweaver.features.decoration.DistanceSignDecoration;
import net.shiroha233.roadweaver.features.decoration.LamppostDecoration;
import net.shiroha233.roadweaver.features.decoration.LanternPostDecoration;
import net.shiroha233.roadweaver.features.decoration.system.SurfacePlacementUtil;

public final class DecorationPlanner {
    private static final int SIGN_INDEX_OFFSET = 65;
    private static final int SIDE_OFFSET = 2;

    private DecorationPlanner() {
    }

    public static void placeOnSurface(class_5281 world, class_2338 placePos, List<class_2680> material, class_5819 random, ModConfig cfg, Mode mode) {
        int roadType = mode == Mode.ARTIFICIAL ? 0 : 1;
        SurfacePlacementUtil.placeOnSurface(world, placePos, material, roadType, random, cfg);
    }

    public static void addDecoration(class_5281 world, Set<Decoration> out, class_2338 placePos, int segmentIndex, class_2338 nextPos, class_2338 prevPos, List<class_2338> middlePositions, int roadWidth, class_5819 random, ModConfig cfg, Mode mode) {
        boolean isStart;
        int dz;
        int dx = nextPos.method_10263() - prevPos.method_10263();
        double len = Math.sqrt((double)dx * (double)dx + (double)(dz = nextPos.method_10260() - prevPos.method_10260()) * (double)dz);
        int nx = len != 0.0 ? (int)Math.round((double)dx / len) : 0;
        int nz = len != 0.0 ? (int)Math.round((double)dz / len) : 0;
        class_2382 dir = new class_2382(nx, 0, nz);
        class_2382 ortho = new class_2382(-dir.method_10260(), 0, dir.method_10263());
        int halfWidth = Math.max(1, roadWidth / 2);
        int sideOffset = Math.max(2, halfWidth + 1);
        boolean bl = isStart = segmentIndex == 65;
        if (segmentIndex == 65 || segmentIndex == middlePositions.size() - 65) {
            class_2338 shifted = isStart ? placePos.method_10069(ortho.method_10263() * sideOffset, 0, ortho.method_10260() * sideOffset) : placePos.method_10069(-ortho.method_10263() * sideOffset, 0, -ortho.method_10260() * sideOffset);
            int dist = DecorationPlanner.computeApproxDistanceMeters(world, shifted, isStart, middlePositions);
            out.add(new DistanceSignDecoration(shifted, ortho, world, isStart, String.valueOf(dist)));
            return;
        }
        int interval = Math.max(1, cfg.lampInterval());
        if (segmentIndex % interval == 0) {
            boolean left = random.method_43056();
            class_2338 shifted = left ? placePos.method_10069(ortho.method_10263() * sideOffset, 0, ortho.method_10260() * sideOffset) : placePos.method_10069(-ortho.method_10263() * sideOffset, 0, -ortho.method_10260() * sideOffset);
            if (Math.abs((shifted = new class_2338(shifted.method_10263(), world.method_8624(class_2902.class_2903.field_13194, shifted.method_10263(), shifted.method_10260()), shifted.method_10260())).method_10264() - placePos.method_10264()) > 1) {
                return;
            }
            if (mode == Mode.ARTIFICIAL) {
                out.add(new LamppostDecoration(shifted, ortho, world));
            } else {
                out.add(new LanternPostDecoration(shifted, ortho, world));
            }
        }
    }

    private static int computeApproxDistanceMeters(class_5281 world, class_2338 fromPos, boolean isStart, List<class_2338> middlePositions) {
        class_2338 target = isStart ? middlePositions.get(middlePositions.size() - 1) : middlePositions.get(0);
        long dx = (long)target.method_10263() - (long)fromPos.method_10263();
        long dz = (long)target.method_10260() - (long)fromPos.method_10260();
        double d = Math.sqrt((double)dx * (double)dx + (double)dz * (double)dz);
        return (int)Math.round(d);
    }

    public static enum Mode {
        ARTIFICIAL,
        NATURAL;

    }
}

