/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.features.roadlogic.RoadDirection;
import net.shiroha233.roadweaver.features.roadlogic.RoadPathCalculator;
import net.shiroha233.roadweaver.features.roadlogic.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;

final class BasicAStarPathfinder {
    private static final double ORTHO_STEP_COST = 1.0;
    private static final double DIAG_STEP_COST = 1.0;
    private static final int ELEVATION_WEIGHT = 80;
    private static final int BIOME_BASE_COST = 12;
    private static final int BIOME_WEIGHT = 2;
    private static final int STABILITY_WEIGHT = 15;
    private static final int WATER_DEPTH_WEIGHT = 40;
    private static final int NEAR_WATER_COST = 40;
    private static final double HEURISTIC_WEIGHT = 15.0;
    private static final double HEURISTIC_EPSILON = 0.2;
    private static final double DEVIATION_WEIGHT = 0.5;

    private BasicAStarPathfinder() {
    }

    public static List<Records.RoadSegmentPlacement> calculateLandPath(class_2338 startGround, class_2338 endGround, int width, class_3218 level, int maxSteps, TerrainSamplingCache cache) {
        PriorityQueue<Node> openSet = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.f));
        HashMap<class_2338, Node> allNodes = new HashMap<class_2338, Node>();
        HashSet<class_2338> closed = new HashSet<class_2338>();
        HashMap<class_2338, List<class_2338>> interpolatedSegments = new HashMap<class_2338, List<class_2338>>();
        Node startNode = new Node(startGround, null, 0.0, BasicAStarPathfinder.heuristic(startGround, endGround));
        openSet.add(startNode);
        allNodes.put(startGround, startNode);
        int d = BasicAStarPathfinder.getNeighborDistance();
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        int stepsBudget = Math.max(1, maxSteps);
        while (!openSet.isEmpty() && stepsBudget-- > 0) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Node current = openSet.poll();
            if (current == null) break;
            if (BasicAStarPathfinder.manhattan2d(current.pos, endGround) < d * 2) {
                return BasicAStarPathfinder.reconstructPath(current, width, interpolatedSegments);
            }
            closed.add(current.pos);
            allNodes.remove(current.pos);
            for (int[] off : neighborOffsets) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                class_2338 nxz = current.pos.method_10069(off[0], 0, off[1]);
                int y = RoadPathCalculator.heightSampler(cache, nxz.method_10263(), nxz.method_10260(), level);
                class_2338 np = new class_2338(nxz.method_10263(), y, nxz.method_10260());
                if (closed.contains(np)) continue;
                class_6880 biome = level.method_23753(np);
                int biomeCost = biome.method_40220(class_6908.field_36511) || biome.method_40220(class_6908.field_36509) || biome.method_40220(class_6908.field_36508) ? 12 : 0;
                int elevation = Math.abs(y - current.pos.method_10264());
                int offsetSum = Math.abs(Math.abs(off[0])) + Math.abs(off[1]);
                double stepCost = offsetSum == 2 * d ? 1.0 : 1.0;
                int stabilityCost = RoadPathCalculator.calculateTerrainStability(cache, np, y, level);
                int sea = level.method_8615();
                boolean waterColumn = RoadPathCalculator.isColumnWater(cache, nxz.method_10263(), nxz.method_10260(), level);
                boolean nearWater = RoadPathCalculator.isNearWaterLike(cache, nxz.method_10263(), nxz.method_10260(), level);
                int oceanFloor = RoadPathCalculator.oceanFloorSampler(cache, nxz.method_10263(), nxz.method_10260(), level);
                int waterDepth = Math.max(0, sea - oceanFloor);
                int waterDepthCost = waterColumn ? waterDepth * 40 : 0;
                int nearWaterCost = nearWater ? 40 : 0;
                double deviation = BasicAStarPathfinder.deviation2d(np, startGround, endGround);
                double deviationCost = deviation * 0.5 / Math.max(1.0, (double)d);
                double tentativeG = current.g + stepCost + (double)(elevation * 80) + (double)(biomeCost * 2) + (double)(stabilityCost * 15) + (double)waterDepthCost + (double)nearWaterCost + deviationCost;
                Node n2 = (Node)allNodes.get(np);
                if (n2 != null && !(tentativeG < n2.g)) continue;
                double h = BasicAStarPathfinder.heuristic(np, endGround);
                double fWeighted = tentativeG + 1.2 * h;
                n2 = new Node(np, current, tentativeG, fWeighted);
                allNodes.put(np, n2);
                openSet.add(n2);
                ArrayList<class_2338> seg = new ArrayList<class_2338>();
                for (int i = 1; i < d; ++i) {
                    int ix = current.pos.method_10263() + off[0] * i / d;
                    int iz = current.pos.method_10260() + off[1] * i / d;
                    seg.add(new class_2338(ix, current.pos.method_10264(), iz));
                }
                interpolatedSegments.put(np, seg);
            }
        }
        return null;
    }

    private static List<Records.RoadSegmentPlacement> reconstructPath(Node endNode, int width, Map<class_2338, List<class_2338>> interpolatedPathMap) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node cur = endNode;
        while (cur != null) {
            nodes.add(cur);
            cur = cur.parent;
        }
        Collections.reverse(nodes);
        LinkedHashMap<class_2338, Set<class_2338>> segments = new LinkedHashMap<class_2338, Set<class_2338>>();
        HashSet<class_2338> widthCache = new HashSet<class_2338>();
        for (Node n : nodes) {
            class_2338 p = n.pos;
            List interp = interpolatedPathMap.getOrDefault(p, Collections.emptyList());
            RoadDirection dir = RoadDirection.X_AXIS;
            if (!interp.isEmpty()) {
                class_2338 f = (class_2338)interp.get(0);
                int dx = p.method_10263() - f.method_10263();
                int dz = p.method_10260() - f.method_10260();
                if (dx < 0 && dz > 0 || dx > 0 && dz < 0) {
                    dir = RoadDirection.DIAGONAL_1;
                } else if (dx < 0 && dz < 0 || dx > 0 && dz > 0) {
                    dir = RoadDirection.DIAGONAL_2;
                } else if (dx == 0 && dz != 0) {
                    dir = RoadDirection.Z_AXIS;
                }
                for (class_2338 ip : interp) {
                    Set<class_2338> ws = RoadPathCalculator.generateWidth(ip, width / 2, widthCache, dir);
                    segments.put(ip, ws);
                }
            }
            Set<class_2338> ws = RoadPathCalculator.generateWidth(p, width / 2, widthCache, dir);
            segments.put(p, ws);
        }
        ArrayList<Records.RoadSegmentPlacement> out = new ArrayList<Records.RoadSegmentPlacement>();
        for (Map.Entry e : segments.entrySet()) {
            out.add(new Records.RoadSegmentPlacement((class_2338)e.getKey(), new ArrayList<class_2338>((Collection)e.getValue())));
        }
        return out;
    }

    private static int getNeighborDistance() {
        try {
            int v = ConfigService.get().aStarStep();
            if (v < 4) {
                return 16;
            }
            if (v > 128) {
                return 128;
            }
            return v;
        }
        catch (Throwable ignore) {
            return 16;
        }
    }

    private static int manhattan2d(class_2338 a, class_2338 b) {
        return Math.abs(a.method_10263() - b.method_10263()) + Math.abs(a.method_10260() - b.method_10260());
    }

    private static double heuristic(class_2338 a, class_2338 b) {
        int dx = a.method_10263() - b.method_10263();
        int dz = a.method_10260() - b.method_10260();
        double dxzApprox = (double)(Math.abs(dx) + Math.abs(dz)) - 0.6 * (double)Math.min(Math.abs(dx), Math.abs(dz));
        return dxzApprox * 15.0;
    }

    private static double deviation2d(class_2338 p, class_2338 a, class_2338 b) {
        double ax = a.method_10263();
        double az = a.method_10260();
        double bx = b.method_10263();
        double bz = b.method_10260();
        double px = p.method_10263();
        double pz = p.method_10260();
        double num = Math.abs((bz - az) * px - (bx - ax) * pz + bx * az - bz * ax);
        double den = Math.hypot(bx - ax, bz - az);
        if (den <= 0.0) {
            return 0.0;
        }
        return num / den;
    }

    private static final class Node {
        final class_2338 pos;
        final Node parent;
        final double g;
        final double f;

        Node(class_2338 pos, Node parent, double g, double f) {
            this.pos = pos;
            this.parent = parent;
            this.g = g;
            this.f = f;
        }
    }
}

