/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.shiroha233.roadweaver.features.roadlogic.RoadDirection;
import net.shiroha233.roadweaver.features.roadlogic.RoadPathCalculator;
import net.shiroha233.roadweaver.features.roadlogic.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;

final class BidirectionalAStarPathfinder {
    private static final double ORTHO_STEP_COST = 1.0;
    private static final double DIAG_STEP_COST = 1.0;
    private static final int ELEVATION_WEIGHT = 80;
    private static final int BIOME_BASE_COST = 40;
    private static final int BIOME_WEIGHT = 2;
    private static final int STABILITY_WEIGHT = 15;
    private static final int WATER_DEPTH_WEIGHT = 40;
    private static final int NEAR_WATER_COST = 40;
    private static final double HEURISTIC_WEIGHT = 15.0;
    private static final double HEURISTIC_EPSILON = 0.2;
    private static final double DEVIATION_WEIGHT = 0.5;

    private BidirectionalAStarPathfinder() {
    }

    static List<Records.RoadSegmentPlacement> calculateLandPath(class_2338 startGround, class_2338 endGround, int width, class_3218 level, int maxSteps, TerrainSamplingCache cache) {
        if (startGround.equals((Object)endGround)) {
            return Collections.emptyList();
        }
        int d = RoadPathCalculator.getNeighborDistance();
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        PriorityQueue<Node> openF = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.f));
        PriorityQueue<Node> openB = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.f));
        HashMap<class_2338, Node> nodesF = new HashMap<class_2338, Node>();
        HashMap<class_2338, Node> nodesB = new HashMap<class_2338, Node>();
        HashSet<class_2338> closedF = new HashSet<class_2338>();
        HashSet<class_2338> closedB = new HashSet<class_2338>();
        Node startNode = new Node(startGround, null, 0.0, BidirectionalAStarPathfinder.heuristic(startGround, endGround));
        Node endNode = new Node(endGround, null, 0.0, BidirectionalAStarPathfinder.heuristic(endGround, startGround));
        openF.add(startNode);
        nodesF.put(startGround, startNode);
        openB.add(endNode);
        nodesB.put(endGround, endNode);
        int stepsBudget = Math.max(1, maxSteps);
        while (!openF.isEmpty() && !openB.isEmpty() && stepsBudget-- > 0) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Node peekF = openF.peek();
            Node peekB = openB.peek();
            boolean expandForward = peekF == null ? false : (peekB == null ? true : peekF.f <= peekB.f);
            Meet meet = expandForward ? BidirectionalAStarPathfinder.expandOneSide(openF, nodesF, closedF, nodesB, startGround, endGround, level, cache, neighborOffsets, d) : BidirectionalAStarPathfinder.expandOneSide(openB, nodesB, closedB, nodesF, endGround, startGround, level, cache, neighborOffsets, d);
            if (meet == null) continue;
            return BidirectionalAStarPathfinder.reconstructPath(meet.forward, meet.backward, width);
        }
        return null;
    }

    private static Meet expandOneSide(PriorityQueue<Node> open, Map<class_2338, Node> nodesThis, Set<class_2338> closedThis, Map<class_2338, Node> nodesOther, class_2338 from, class_2338 to, class_3218 level, TerrainSamplingCache cache, int[][] neighborOffsets, int d) {
        if (open.isEmpty()) {
            return null;
        }
        Node current = open.poll();
        if (current == null) {
            return null;
        }
        closedThis.add(current.pos);
        nodesThis.remove(current.pos);
        for (int[] off : neighborOffsets) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            class_2338 nxz = current.pos.method_10069(off[0], 0, off[1]);
            int y = RoadPathCalculator.heightSampler(cache, nxz.method_10263(), nxz.method_10260(), level);
            class_2338 np = new class_2338(nxz.method_10263(), y, nxz.method_10260());
            if (closedThis.contains(np)) continue;
            class_6880 biome = level.method_23753(np);
            int biomeCost = biome.method_40220(class_6908.field_36511) || biome.method_40220(class_6908.field_36509) || biome.method_40220(class_6908.field_36508) ? 40 : 0;
            int elevation = Math.abs(y - current.pos.method_10264());
            int offsetSum = Math.abs(Math.abs(off[0])) + Math.abs(off[1]);
            double stepCost = offsetSum == 2 * d ? 1.0 : 1.0;
            int stabilityCost = RoadPathCalculator.calculateTerrainStability(cache, np, y, level);
            int sea = level.method_8615();
            boolean waterColumn = RoadPathCalculator.isColumnWater(cache, nxz.method_10263(), nxz.method_10260(), level);
            boolean nearWater = RoadPathCalculator.isNearWaterLike(cache, nxz.method_10263(), nxz.method_10260(), level);
            int oceanFloor = RoadPathCalculator.oceanFloorSampler(cache, nxz.method_10263(), nxz.method_10260(), level);
            int waterDepth = Math.max(0, sea - oceanFloor);
            int waterDepthCost = waterColumn ? waterDepth * 40 : 0;
            int nearWaterCost = nearWater ? 40 : 0;
            double deviation = BidirectionalAStarPathfinder.deviation2d(np, from, to);
            double deviationCost = deviation * 0.5 / Math.max(1.0, (double)d);
            double tentativeG = current.g + stepCost + (double)(elevation * 80) + (double)(biomeCost * 2) + (double)(stabilityCost * 15) + (double)waterDepthCost + (double)nearWaterCost + deviationCost;
            Node existing = nodesThis.get(np);
            if (existing != null && tentativeG >= existing.g) continue;
            double h = BidirectionalAStarPathfinder.heuristic(np, to);
            double fWeighted = tentativeG + 1.2 * h;
            Node next = new Node(np, current, tentativeG, fWeighted);
            nodesThis.put(np, next);
            open.add(next);
            Node other = nodesOther.get(np);
            if (other == null) continue;
            if (BidirectionalAStarPathfinder.isFromForward(from, to, next, other)) {
                return new Meet(next, other);
            }
            return new Meet(other, next);
        }
        return null;
    }

    private static boolean isFromForward(class_2338 from, class_2338 to, Node a, Node b) {
        int eb;
        int db;
        int da = BidirectionalAStarPathfinder.manhattan2d(a.pos, from);
        if (da != (db = BidirectionalAStarPathfinder.manhattan2d(b.pos, from))) {
            return da <= db;
        }
        int ea = BidirectionalAStarPathfinder.manhattan2d(a.pos, to);
        return ea <= (eb = BidirectionalAStarPathfinder.manhattan2d(b.pos, to));
    }

    private static List<Records.RoadSegmentPlacement> reconstructPath(Node meetForward, Node meetBackward, int width) {
        ArrayList<Node> forwardNodes = new ArrayList<Node>();
        Node cur = meetForward;
        while (cur != null) {
            forwardNodes.add(cur);
            cur = cur.parent;
        }
        Collections.reverse(forwardNodes);
        ArrayList<Node> backwardNodes = new ArrayList<Node>();
        Node node = cur = meetBackward != null && meetBackward.pos.equals((Object)meetForward.pos) ? meetBackward.parent : meetBackward;
        while (cur != null) {
            backwardNodes.add(cur);
            cur = cur.parent;
        }
        Collections.reverse(backwardNodes);
        ArrayList<Node> allNodes = new ArrayList<Node>(forwardNodes.size() + backwardNodes.size());
        allNodes.addAll(forwardNodes);
        allNodes.addAll(backwardNodes);
        LinkedHashMap<class_2338, Set<class_2338>> segments = new LinkedHashMap<class_2338, Set<class_2338>>();
        HashSet<class_2338> widthCache = new HashSet<class_2338>();
        for (int i = 0; i < allNodes.size(); ++i) {
            Node curNode = (Node)allNodes.get(i);
            class_2338 p = curNode.pos;
            RoadDirection dir = RoadDirection.X_AXIS;
            if (i > 0) {
                Node prevNode = (Node)allNodes.get(i - 1);
                class_2338 prev = prevNode.pos;
                int dx = p.method_10263() - prev.method_10263();
                int dz = p.method_10260() - prev.method_10260();
                int stepCount = Math.max(Math.abs(dx), Math.abs(dz));
                if (dx < 0 && dz > 0 || dx > 0 && dz < 0) {
                    dir = RoadDirection.DIAGONAL_1;
                } else if (dx < 0 && dz < 0 || dx > 0 && dz > 0) {
                    dir = RoadDirection.DIAGONAL_2;
                } else if (dx == 0 && dz != 0) {
                    dir = RoadDirection.Z_AXIS;
                }
                if (stepCount > 1) {
                    for (int s = 1; s < stepCount; ++s) {
                        int ix = prev.method_10263() + dx * s / stepCount;
                        int iz = prev.method_10260() + dz * s / stepCount;
                        class_2338 ip = new class_2338(ix, prev.method_10264(), iz);
                        Set<class_2338> ws = RoadPathCalculator.generateWidth(ip, width / 2, widthCache, dir);
                        segments.put(ip, ws);
                    }
                }
            }
            Set<class_2338> ws = RoadPathCalculator.generateWidth(p, width / 2, widthCache, dir);
            segments.put(p, ws);
        }
        ArrayList<Records.RoadSegmentPlacement> out = new ArrayList<Records.RoadSegmentPlacement>();
        for (Map.Entry e : segments.entrySet()) {
            out.add(new Records.RoadSegmentPlacement((class_2338)e.getKey(), new ArrayList<class_2338>((Collection)e.getValue())));
        }
        return out;
    }

    private static int manhattan2d(class_2338 a, class_2338 b) {
        return Math.abs(a.method_10263() - b.method_10263()) + Math.abs(a.method_10260() - b.method_10260());
    }

    private static double heuristic(class_2338 a, class_2338 b) {
        int dx = a.method_10263() - b.method_10263();
        int dz = a.method_10260() - b.method_10260();
        double dxzApprox = (double)(Math.abs(dx) + Math.abs(dz)) - 0.6 * (double)Math.min(Math.abs(dx), Math.abs(dz));
        return dxzApprox * 15.0;
    }

    private static double deviation2d(class_2338 p, class_2338 a, class_2338 b) {
        double ax = a.method_10263();
        double az = a.method_10260();
        double bx = b.method_10263();
        double bz = b.method_10260();
        double px = p.method_10263();
        double pz = p.method_10260();
        double num = Math.abs((bz - az) * px - (bx - ax) * pz + bx * az - bz * ax);
        double den = Math.hypot(bx - ax, bz - az);
        if (den <= 0.0) {
            return 0.0;
        }
        return num / den;
    }

    private static final class Node {
        final class_2338 pos;
        final Node parent;
        final double g;
        final double f;

        Node(class_2338 pos, Node parent, double g, double f) {
            this.pos = pos;
            this.parent = parent;
            this.g = g;
            this.f = f;
        }
    }

    private static final class Meet {
        final Node forward;
        final Node backward;

        Meet(Node forward, Node backward) {
            this.forward = forward;
            this.backward = backward;
        }
    }
}

