/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.config.PresetService;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.roadlogic.RoadPathCalculator;
import net.shiroha233.roadweaver.features.roadlogic.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;

public final class Road {
    private final class_3218 level;
    private final Records.StructureConnection connection;
    private final RoadFeatureConfig config;

    public Road(class_3218 level, Records.StructureConnection connection, RoadFeatureConfig config) {
        this.level = level;
        this.connection = connection;
        this.config = config;
    }

    public void generateRoad(int maxSteps) {
        class_5819 random = class_5819.method_43047();
        int width = ConfigService.get().roadWidth() > 0 ? ConfigService.get().roadWidth() : Road.getRandomWidth(random, this.config);
        ModConfig cfg = ConfigService.get();
        boolean allowA = cfg.allowArtificial();
        boolean allowN = cfg.allowNatural();
        if (!allowA && !allowN) {
            return;
        }
        int type = allowA && allowN ? (random.method_43056() ? 0 : 1) : (allowA ? 0 : 1);
        List<class_2680> materials = type == 0 ? PresetService.chooseMaterialsForArtificial(random, cfg) : List.of(class_2246.field_10194.method_9564(), class_2246.field_10255.method_9564());
        class_2338 start = this.connection.from();
        class_2338 end = this.connection.to();
        TerrainSamplingCache cache = new TerrainSamplingCache();
        List<Records.RoadSegmentPlacement> segments = RoadPathCalculator.calculateAStarRoadPath(start, end, width, this.level, maxSteps, cache);
        if (segments == null || segments.size() < 5) {
            return;
        }
        List<Records.RoadSpan> spans = RoadPathCalculator.extractSpans(segments, this.level, cache);
        List<Integer> targetY = Road.computeTargetY(this.level, segments, spans, cache);
        Records.RoadData rd = new Records.RoadData(width, type, materials, segments, spans, targetY);
        RoadShardStorage.addRoad(this.level, rd);
    }

    private static int getRandomWidth(class_5819 rnd, RoadFeatureConfig cfg) {
        return 3;
    }

    private static List<Integer> computeTargetY(class_3218 level, List<Records.RoadSegmentPlacement> segments, List<Records.RoadSpan> spans, TerrainSamplingCache cache) {
        int n = segments.size();
        ArrayList<class_2338> centers = new ArrayList<class_2338>(n);
        for (Records.RoadSegmentPlacement s : segments) {
            centers.add(s.middlePos());
        }
        boolean[] isBridge = new boolean[n];
        if (spans != null && !spans.isEmpty()) {
            HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>();
            for (int i = 0; i < centers.size(); ++i) {
                indexMap.put(((class_2338)centers.get(i)).method_10063(), i);
            }
            for (Records.RoadSpan sp : spans) {
                if (sp.type() != Records.SpanType.BRIDGE) continue;
                Integer si = (Integer)indexMap.get(sp.start().method_10063());
                Integer ei = (Integer)indexMap.get(sp.end().method_10063());
                if (si == null || ei == null) continue;
                int a = Math.max(0, Math.min(si, ei));
                int b = Math.min(n - 1, Math.max(si, ei));
                for (int k = a; k <= b; ++k) {
                    isBridge[k] = true;
                }
            }
        }
        int avg = Math.max(0, ConfigService.get().averagingRadius());
        int[] base = new int[n];
        for (int i = 0; i < n; ++i) {
            int sum = 0;
            int cnt = 0;
            int lo = Math.max(0, i - avg);
            int hi = Math.min(n - 1, i + avg);
            for (int j = lo; j <= hi; ++j) {
                class_2338 sp = (class_2338)centers.get(j);
                int yTop = RoadPathCalculator.heightSampler(cache, sp.method_10263(), sp.method_10260(), level);
                sum += yTop;
                ++cnt;
            }
            base[i] = cnt > 0 ? (int)Math.round((double)sum / (double)cnt) : ((class_2338)centers.get(i)).method_10264();
        }
        if (!ConfigService.get().slopeLimitEnabled()) {
            ArrayList<Integer> out = new ArrayList<Integer>(n);
            for (int v : base) {
                out.add(v);
            }
            return out;
        }
        int[] smoothed = (int[])base.clone();
        int i = 0;
        while (i < n) {
            int lo;
            int hi;
            int y;
            int ii;
            while (i < n && isBridge[i]) {
                ++i;
            }
            int s = i;
            while (i < n && !isBridge[i]) {
                ++i;
            }
            int e = i - 1;
            if (s > e) continue;
            int step2 = Math.max(0, Math.min(8, ConfigService.get().maxSlopeStepPerTwoSegments()));
            int halfLow = Math.max(0, step2 / 2);
            int halfHigh = Math.max(0, (step2 + 1) / 2);
            for (ii = s + 1; ii <= e; ++ii) {
                y = smoothed[ii];
                if (ii == s + 1) {
                    py = smoothed[ii - 1];
                    if (y > py + halfLow) {
                        y = py + halfLow;
                    }
                    if (y < py - halfLow) {
                        y = py - halfLow;
                    }
                } else {
                    py = smoothed[ii - 1];
                    if (y > py + halfHigh) {
                        y = py + halfHigh;
                    }
                    if (y < py - halfHigh) {
                        y = py - halfHigh;
                    }
                    int p2 = smoothed[ii - 2];
                    hi = p2 + step2;
                    lo = p2 - step2;
                    if (y > hi) {
                        y = hi;
                    }
                    if (y < lo) {
                        y = lo;
                    }
                }
                smoothed[ii] = y;
            }
            for (ii = e - 1; ii >= s; --ii) {
                y = smoothed[ii];
                if (ii == e - 1) {
                    ny = smoothed[ii + 1];
                    if (y > ny + halfLow) {
                        y = ny + halfLow;
                    }
                    if (y < ny - halfLow) {
                        y = ny - halfLow;
                    }
                } else {
                    ny = smoothed[ii + 1];
                    if (y > ny + halfHigh) {
                        y = ny + halfHigh;
                    }
                    if (y < ny - halfHigh) {
                        y = ny - halfHigh;
                    }
                    int n2 = smoothed[ii + 2];
                    hi = n2 + step2;
                    lo = n2 - step2;
                    if (y > hi) {
                        y = hi;
                    }
                    if (y < lo) {
                        y = lo;
                    }
                }
                smoothed[ii] = y;
            }
        }
        ArrayList<Integer> out = new ArrayList<Integer>(n);
        for (int v : smoothed) {
            out.add(v);
        }
        return out;
    }
}

