/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.blend;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2902;
import net.minecraft.class_5281;
import net.shiroha233.roadweaver.structures.api.BlendProfile;
import net.shiroha233.roadweaver.structures.blend.BlendPlan;

public final class TerrainBlender {
    private TerrainBlender() {
    }

    public static BlendPlan plan(class_5281 world, class_238 box, BlendProfile profile) {
        if (box == null || profile == null) {
            return BlendPlan.EMPTY;
        }
        int minX = (int)Math.floor(box.field_1323);
        int maxX = (int)Math.ceil(box.field_1320);
        int minZ = (int)Math.floor(box.field_1321);
        int maxZ = (int)Math.ceil(box.field_1324);
        int cx = (minX + maxX) / 2;
        int cz = (minZ + maxZ) / 2;
        int inner = Math.max(0, profile.ringInner());
        int outer = Math.max(inner, profile.ringOuter());
        long sum = 0L;
        int cnt = 0;
        for (int x = cx - inner; x <= cx + inner; ++x) {
            for (int z = cz - inner; z <= cz + inner; ++z) {
                int top = world.method_8624(class_2902.class_2903.field_13203, x, z);
                sum += (long)top;
                ++cnt;
            }
        }
        int targetY = cnt == 0 ? world.method_8624(class_2902.class_2903.field_13203, cx, cz) : (int)Math.round((double)sum / (double)cnt);
        HashMap<Long, Integer> desired = new HashMap<Long, Integer>();
        int cutFillBudget = Math.max(0, profile.cutFillBudget());
        int used = 0;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int desiredY;
                int dx = Math.abs(x - cx);
                int dz = Math.abs(z - cz);
                int d = Math.max(dx, dz);
                int top = world.method_8624(class_2902.class_2903.field_13203, x, z);
                if (d <= inner) {
                    desiredY = targetY;
                } else if (d <= outer) {
                    double t = outer == inner ? 1.0 : (double)(outer - d) / (double)(outer - inner);
                    double k = "quadratic".equalsIgnoreCase(profile.kernel()) ? t * t : t;
                    desiredY = (int)Math.round((double)top + (double)(targetY - top) * k);
                } else {
                    desiredY = top;
                }
                int delta = Math.abs(desiredY - top);
                if (delta > 0) {
                    if (used + delta > cutFillBudget) continue;
                    used += delta;
                }
                desired.put(BlendPlan.key2D(x, z), desiredY);
            }
        }
        return new BlendPlan(box, targetY, inner, outer, profile.fellTree(), desired);
    }

    public static void apply(class_5281 world, BlendPlan plan) {
        if (plan == null || plan == BlendPlan.EMPTY) {
            return;
        }
        for (Map.Entry<Long, Integer> e : plan.desiredHeights().entrySet()) {
            int y;
            long key = e.getKey();
            int desiredY = e.getValue();
            int x = (int)(key >> 32);
            int z = (int)key;
            int top = world.method_8624(class_2902.class_2903.field_13203, x, z);
            if (top > desiredY) {
                for (y = top; y > desiredY; --y) {
                    world.method_8652(new class_2338(x, y, z), class_2246.field_10124.method_9564(), 3);
                }
            }
            if (top >= desiredY) continue;
            for (y = top; y <= desiredY; ++y) {
                world.method_8652(new class_2338(x, y, z), class_2246.field_10566.method_9564(), 3);
            }
        }
    }
}

