/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.index;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.shiroha233.roadweaver.structures.index.StructureIndex;
import net.shiroha233.roadweaver.structures.model.StructureInstance;

public final class ChunkStructureIndex
implements StructureIndex {
    private final Map<Long, Set<StructureInstance>> byChunk = new ConcurrentHashMap<Long, Set<StructureInstance>>();

    private static long key(class_1923 cp) {
        return (long)cp.field_9181 << 32 ^ (long)cp.field_9180 & 0xFFFFFFFFL;
    }

    @Override
    public void add(StructureInstance inst) {
        class_238 b = inst.bounds();
        if (b == null) {
            return;
        }
        int minCX = (int)Math.floor(b.field_1323 / 16.0);
        int maxCX = (int)Math.floor(b.field_1320 / 16.0);
        int minCZ = (int)Math.floor(b.field_1321 / 16.0);
        int maxCZ = (int)Math.floor(b.field_1324 / 16.0);
        for (int cx = minCX; cx <= maxCX; ++cx) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                this.byChunk.computeIfAbsent(ChunkStructureIndex.key(new class_1923(cx, cz)), k -> ConcurrentHashMap.newKeySet()).add(inst);
            }
        }
    }

    @Override
    public void remove(StructureInstance inst) {
        for (Set<StructureInstance> set : this.byChunk.values()) {
            set.remove(inst);
        }
    }

    @Override
    public Collection<StructureInstance> query(class_238 box) {
        if (box == null) {
            return Collections.emptyList();
        }
        int minCX = (int)Math.floor(box.field_1323 / 16.0);
        int maxCX = (int)Math.floor(box.field_1320 / 16.0);
        int minCZ = (int)Math.floor(box.field_1321 / 16.0);
        int maxCZ = (int)Math.floor(box.field_1324 / 16.0);
        HashSet<StructureInstance> result = new HashSet<StructureInstance>();
        for (int cx = minCX; cx <= maxCX; ++cx) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                Set<StructureInstance> set = this.byChunk.get(ChunkStructureIndex.key(new class_1923(cx, cz)));
                if (set == null) continue;
                for (StructureInstance s : set) {
                    if (s.bounds() == null || !s.bounds().method_994(box)) continue;
                    result.add(s);
                }
            }
        }
        return result;
    }

    @Override
    public boolean existsNear(class_2338 pos, int radius) {
        class_238 box = new class_238((double)(pos.method_10263() - radius), (double)(pos.method_10264() - radius), (double)(pos.method_10260() - radius), (double)(pos.method_10263() + radius), (double)(pos.method_10264() + radius), (double)(pos.method_10260() + radius));
        return !this.query(box).isEmpty();
    }

    @Override
    public void clear() {
        this.byChunk.clear();
    }
}

