/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1132;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.shiroha233.roadweaver.client.ConfigScreenFactory;
import net.shiroha233.roadweaver.client.map.MapInputHandler;
import net.shiroha233.roadweaver.client.map.MapState;
import net.shiroha233.roadweaver.client.map.MapView;
import net.shiroha233.roadweaver.client.map.data.ClientMapNotes;
import net.shiroha233.roadweaver.client.map.data.MapDataCollector;
import net.shiroha233.roadweaver.client.map.data.MapSnapshot;
import net.shiroha233.roadweaver.client.map.data.MapSnapshotCache;
import net.shiroha233.roadweaver.client.map.interaction.MapInteraction;
import net.shiroha233.roadweaver.client.map.render.GridRenderer;
import net.shiroha233.roadweaver.client.map.render.MapRenderers;
import net.shiroha233.roadweaver.client.map.render.RenderUtils;
import net.shiroha233.roadweaver.client.map.ui.ContextMenu;
import net.shiroha233.roadweaver.client.map.ui.NoteEditScreen;
import net.shiroha233.roadweaver.client.map.ui.SimpleTextInputScreen;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.network.ClientNetBridge;
import net.shiroha233.roadweaver.util.ComputeService;

public class RoadMapScreen
extends class_437
implements MapInputHandler.Callbacks {
    private static final class_2960 MAP_TEXTURE = class_2960.method_60655((String)"roadweaver", (String)"textures/gui/map.png");
    private static final class_2561 BTN_CONFIG = class_2561.method_43471((String)"gui.roadweaver.config_button");
    private static final class_2561 BTN_MANUAL = class_2561.method_43471((String)"gui.roadweaver.map.manual_connect");
    private static final class_2561 MENU_TELEPORT = class_2561.method_43471((String)"gui.roadweaver.map.menu.teleport");
    private static final class_2561 MENU_SET_ALIAS = class_2561.method_43471((String)"gui.roadweaver.map.menu.set_alias");
    private static final class_2561 MENU_EDIT_NOTE = class_2561.method_43471((String)"gui.roadweaver.map.menu.edit_note");
    private static final class_2561 DIALOG_ALIAS_TITLE = class_2561.method_43471((String)"gui.roadweaver.map.dialog.alias_title");
    private MapSnapshot snapshot = MapSnapshot.empty();
    private final MapState state = new MapState();
    private final MapView view = new MapView();
    private final MapInputHandler inputHandler;
    private final ContextMenu contextMenu = new ContextMenu();
    private int mapX;
    private int mapY;
    private int mapW;
    private int mapH;

    public RoadMapScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.roadweaver.map.title"));
        this.inputHandler = new MapInputHandler(this.state, this.view, this);
    }

    protected void method_25426() {
        super.method_25426();
        MapSnapshotCache.cancelClear();
        MapSnapshot cached = MapSnapshotCache.peek();
        if (cached != null) {
            this.snapshot = cached;
        }
        this.computeMapRect();
        this.inputHandler.updateLayout(this.mapX, this.mapY, this.mapW, this.mapH, 25);
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.resetFromSnapshot(this.snapshot);
        class_310 mc = this.field_22787;
        if (mc != null && mc.field_1724 != null) {
            this.view.calibrateInitialToPlayer(mc, contentW, contentH, 32);
        }
        this.onRequestView();
    }

    public void method_25432() {
        super.method_25432();
        MapSnapshotCache.scheduleClear(1000L);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 g, int mouseX, int mouseY, float partialTick) {
        g.method_25294(0, 0, this.field_22789, this.field_22790, -1879048192);
    }

    public void method_25394(class_332 g, int mouseX, int mouseY, float partialTick) {
        boolean hasDetailedRoads;
        this.method_25420(g, mouseX, mouseY, partialTick);
        g.method_25293(MAP_TEXTURE, this.mapX, this.mapY, this.mapW, this.mapH, 0.0f, 0.0f, 1536, 1024, 1536, 1024);
        int titleY = this.mapY - 8;
        g.method_27534(this.field_22793, this.method_25440(), this.field_22789 / 2, Math.max(6, titleY), -10601186);
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.lockAspect(contentW, contentH);
        int left = this.mapX + 25;
        int top = this.mapY + 25;
        int right = this.mapX + this.mapW - 25;
        int bottom = this.mapY + this.mapH - 25;
        g.method_44379(left, top, right, bottom);
        MapRenderers.renderGrid(g, this.field_22793, this.mapX, this.mapY, this.mapW, this.mapH, 25, this.view.getMinX(), this.view.getMaxX(), this.view.getMinZ(), this.view.getMaxZ(), 0x30999999, 32, -10601186);
        int thickness = this.computeThickness();
        ArrayList<Records.StructureConnection> connForLines = new ArrayList<Records.StructureConnection>(this.snapshot.connections());
        boolean bl = hasDetailedRoads = !this.snapshot.roadPolylines().isEmpty();
        if (hasDetailedRoads) {
            connForLines.removeIf(c -> c.status() == Records.ConnectionStatus.COMPLETED);
        }
        MapRenderers.renderConnections(g, connForLines, (x1, z1, x2, z2) -> this.view.segmentInViewWorld(x1, z1, x2, z2), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), thickness, -11751600, -16777216, -16777216, -522167472, left, top, right, bottom);
        int lodStep = GridRenderer.computeGridStep(this.mapX, this.mapY, this.mapW, this.mapH, 25, this.view.getMinX(), this.view.getMaxX(), this.view.getMinZ(), this.view.getMaxZ(), 32);
        MapRenderers.renderRoadPolylines(g, this.snapshot.roadPolylines(), (x1, z1, x2, z2) -> this.view.segmentInViewWorld(x1, z1, x2, z2), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), thickness, -16777216, left, top, right, bottom, lodStep);
        MapRenderers.renderStructures(g, this.snapshot.structures(), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), (x, z) -> this.view.isInViewWorld((int)x, (int)z), this.computePointSize(), -10601186, left, top, right, bottom);
        this.renderManualModePreview(g, mouseX, mouseY, contentW, contentH, left, top, right, bottom);
        if (!this.contextMenu.isOpen()) {
            MapInteraction.renderHoverHighlight(g, this.snapshot, this.view, this.mapX, this.mapY, this.mapW, this.mapH, 25, mouseX, mouseY);
        }
        this.renderPlayer(g, contentW, contentH, left, top, right, bottom);
        g.method_44380();
        int legendRight = this.mapX + this.mapW - 25;
        int legendStartY = this.mapY + 25 + 8;
        MapRenderers.renderLegend(g, this.field_22793, legendRight, legendStartY, 8, -10601186, -10601186, -11751600, -16777216, -16777216, -522167472, this.snapshot.structuresCount(), this.snapshot.plannedCount(), this.snapshot.generatingCount(), this.snapshot.completedCount(), this.snapshot.failedCount());
        this.renderToolbarButtons(g, mouseX, mouseY);
        if (!this.contextMenu.isOpen()) {
            MapInteraction.renderHoverTooltip(g, this.field_22793, this.snapshot, this.view, this.mapX, this.mapY, this.mapW, this.mapH, 25, mouseX, mouseY);
        }
        if (this.state.isZoomDebounceReady()) {
            this.state.clearZoomDebounce();
            this.onRequestView();
        }
        this.contextMenu.render(g, this.field_22793, mouseX, mouseY, this.field_22789, this.field_22790);
    }

    private void renderManualModePreview(class_332 g, int mouseX, int mouseY, int contentW, int contentH, int left, int top, int right, int bottom) {
        if (!this.state.isManualMode() || !this.state.hasSelection()) {
            return;
        }
        class_2338 selectedA = this.state.getSelectedA();
        if (!this.view.isInViewWorld(selectedA.method_10263(), selectedA.method_10260())) {
            return;
        }
        int sxA = this.view.toScreenX(selectedA.method_10263(), this.mapX, 25, contentW);
        int syA = this.view.toScreenY(selectedA.method_10260(), this.mapY, 25, contentH);
        int selSize = this.computePointSize() * 2 + 4;
        RenderUtils.drawPoint(g, sxA, syA, selSize, -50384, left, top, right, bottom);
        if (this.inputHandler.insideMap(mouseX, mouseY)) {
            int syB;
            int sxB;
            class_2338 hover = this.inputHandler.findNearestStructure(this.snapshot, mouseX, mouseY);
            if (hover != null && this.view.isInViewWorld(hover.method_10263(), hover.method_10260())) {
                sxB = this.view.toScreenX(hover.method_10263(), this.mapX, 25, contentW);
                syB = this.view.toScreenY(hover.method_10260(), this.mapY, 25, contentH);
            } else {
                sxB = mouseX;
                syB = mouseY;
            }
            RenderUtils.drawThickDashedLine(g, sxA, syA, sxB, syB, -855688400, this.computeThickness(), 8, 6, left, top, right, bottom);
        }
    }

    private void renderPlayer(class_332 g, int contentW, int contentH, int left, int top, int right, int bottom) {
        int sy;
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        double wx = this.field_22787.field_1724.method_23317();
        double wz = this.field_22787.field_1724.method_23321();
        int sx = this.view.toScreenX((int)Math.round(wx), this.mapX, 25, contentW);
        if (!this.inputHandler.insideMap(sx, sy = this.view.toScreenY((int)Math.round(wz), this.mapY, 25, contentH))) {
            return;
        }
        float yaw = this.field_22787.field_1724.method_36454();
        MapRenderers.drawPlayerArrow(g, sx, sy, yaw, 10, 6, 4, -16777216, left, top, right, bottom, this.view.pxPerBlockX(contentW), this.view.pxPerBlockZ(contentH));
    }

    private void renderToolbarButtons(class_332 g, int mouseX, int mouseY) {
        int[] configBtn = this.computeConfigBtnBounds();
        this.renderTextButton(g, BTN_CONFIG, configBtn, mouseX, mouseY);
        int[] manualBtn = this.computeManualBtnBounds();
        class_5250 manualLabel = class_2561.method_43473().method_10852(BTN_MANUAL).method_27693(": ").method_10852((class_2561)(this.state.isManualMode() ? class_2561.method_43471((String)"gui.roadweaver.common.on") : class_2561.method_43471((String)"gui.roadweaver.common.off")));
        this.renderTextButton(g, (class_2561)manualLabel, manualBtn, mouseX, mouseY);
    }

    private void renderTextButton(class_332 g, class_2561 label, int[] bounds, int mouseX, int mouseY) {
        int x = bounds[0];
        int y = bounds[1];
        int w = bounds[2];
        int h = bounds[3];
        Objects.requireNonNull(this.field_22793);
        int ty = y + (h - 9) / 2;
        g.method_51439(this.field_22793, label, x + 3, ty, -10601186, false);
        if (this.insideRect(mouseX, mouseY, x, y, w, h)) {
            int textW = this.field_22793.method_27525((class_5348)label);
            Objects.requireNonNull(this.field_22793);
            int uy = ty + 9 + 1;
            int underline = 1616788766;
            g.method_25294(x + 2, uy, x + 2 + textW + 2, uy + 1, underline);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.inputHandler.mouseScrolled(mouseX, mouseY, deltaY) || super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_2338 target;
        if (this.contextMenu.isOpen() && this.contextMenu.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            int[] configBtn = this.computeConfigBtnBounds();
            if (this.insideRect(mouseX, mouseY, configBtn)) {
                this.onOpenConfig();
                return true;
            }
            int[] manualBtn = this.computeManualBtnBounds();
            if (this.insideRect(mouseX, mouseY, manualBtn)) {
                this.state.toggleManualMode();
                return true;
            }
        }
        if (button == 1 && this.inputHandler.insideMap(mouseX, mouseY) && (target = this.inputHandler.findNearestStructure(this.snapshot, mouseX, mouseY)) != null) {
            this.openContextMenuFor(target, (int)mouseX, (int)mouseY);
            return true;
        }
        return this.inputHandler.mouseClicked(mouseX, mouseY, button, this.snapshot, this.computeConfigBtnBounds()[0], this.computeConfigBtnBounds()[1], this.computeConfigBtnBounds()[2], this.computeConfigBtnBounds()[3], this.computeManualBtnBounds()[0], this.computeManualBtnBounds()[1], this.computeManualBtnBounds()[2], this.computeManualBtnBounds()[3]) || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.inputHandler.mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.inputHandler.mouseReleased(mouseX, mouseY, button) || super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.inputHandler.keyPressed(keyCode, scanCode, modifiers, this.field_22787) || super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void onCloseScreen() {
        this.method_25419();
    }

    @Override
    public void onOpenConfig() {
        if (this.field_22787 == null) {
            return;
        }
        try {
            class_437 next = ConfigScreenFactory.createConfigScreen(this);
            if (next != null) {
                this.field_22787.method_1507(next);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void onRequestView() {
        int minX = (int)Math.floor(Math.min(this.view.getMinX(), this.view.getMaxX())) - 32;
        int maxX = (int)Math.ceil(Math.max(this.view.getMinX(), this.view.getMaxX())) + 32;
        int minZ = (int)Math.floor(Math.min(this.view.getMinZ(), this.view.getMaxZ())) - 32;
        int maxZ = (int)Math.ceil(Math.max(this.view.getMinZ(), this.view.getMaxZ())) + 32;
        class_310 mc = this.field_22787;
        if (mc == null) {
            return;
        }
        class_1132 server = mc.method_1576();
        if (server != null) {
            class_3218 level = server.method_3847(class_1937.field_25179);
            if (level != null) {
                int cx = 0;
                int cz = 0;
                if (mc.field_1724 != null) {
                    cx = (int)Math.round(mc.field_1724.method_23317());
                    cz = (int)Math.round(mc.field_1724.method_23321());
                }
                int radiusBlocks = this.getRadiusBlocks();
                int fcx = cx;
                int fcz = cz;
                int fMinX = minX;
                int fMaxX = maxX;
                int fMinZ = minZ;
                int fMaxZ = maxZ;
                int currentSeq = this.state.incrementAndGetRequestSeq();
                CompletableFuture.supplyAsync(() -> MapDataCollector.build(level, fMinX, fMinZ, fMaxX, fMaxZ, fcx, fcz, radiusBlocks), ComputeService.executor()).thenAccept(snap -> mc.execute(() -> {
                    if (this.state.getCurrentRequestSeq() == currentSeq) {
                        this.setSnapshot((MapSnapshot)snap);
                    }
                }));
            }
        } else {
            this.state.incrementAndGetRequestSeq();
            ClientNetBridge.requestSnapshot(minX, minZ, maxX, maxZ);
        }
    }

    @Override
    public void onTeleportTo(class_2338 pos) {
        ClientNetBridge.requestTeleport(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    @Override
    public void onManualConnect(class_2338 a, class_2338 b) {
        ClientNetBridge.requestManualConnect(a.method_10263(), a.method_10260(), b.method_10263(), b.method_10260());
    }

    @Override
    public void onCenterToPlayer() {
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.calibrateInitialToPlayer(this.field_22787, contentW, contentH, 32);
        this.onRequestView();
    }

    @Override
    public void onCenterToSpawn() {
        class_3218 level;
        class_310 mc = this.field_22787;
        if (mc == null) {
            return;
        }
        class_2338 spawn = null;
        class_1132 server = mc.method_1576();
        if (server != null && (level = server.method_3847(class_1937.field_25179)) != null) {
            spawn = level.method_43126();
        }
        if (spawn == null && mc.field_1687 != null) {
            spawn = mc.field_1687.method_43126();
        }
        if (spawn == null) {
            return;
        }
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.centerOn(spawn.method_10263(), spawn.method_10260(), contentW, contentH);
        this.onRequestView();
    }

    public void setSnapshot(MapSnapshot snapshot) {
        if (snapshot != null) {
            this.snapshot = snapshot;
            MapSnapshotCache.put(snapshot);
        }
    }

    private void computeMapRect() {
        int availW = this.field_22789 - 72;
        int availH = this.field_22790 - 72;
        int w = availW;
        float ratio = 1.5f;
        int h = Math.round((float)w / ratio);
        if (h > availH) {
            h = availH;
            w = Math.round((float)h * ratio);
        }
        this.mapW = w;
        this.mapH = h;
        this.mapX = (this.field_22789 - w) / 2;
        this.mapY = (this.field_22790 - h) / 2;
    }

    private int computeThickness() {
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        double ppb = Math.min(this.view.pxPerBlockX(contentW), this.view.pxPerBlockZ(contentH));
        int t = (int)Math.round(ppb);
        return Math.max(1, Math.min(t, 4));
    }

    private int computePointSize() {
        return 2 + this.computeThickness();
    }

    private int getRadiusBlocks() {
        try {
            ModConfig cfg = ConfigService.get();
            int radiusChunks = cfg.dynamicPlanEnabled() ? cfg.dynamicPlanRadiusChunks() : cfg.initialPlanRadiusChunks();
            return Math.max(1, radiusChunks) * 16;
        }
        catch (Throwable t) {
            return 4096;
        }
    }

    private void openContextMenuFor(class_2338 target, int x, int y) {
        this.contextMenu.clearItems();
        this.contextMenu.addItem(MENU_TELEPORT, () -> this.onTeleportTo(target));
        this.contextMenu.addSeparator();
        this.contextMenu.addItem(MENU_SET_ALIAS, () -> this.openAliasDialog(target));
        this.contextMenu.addItem(MENU_EDIT_NOTE, () -> this.openNoteEditor(target));
        this.contextMenu.open(x, y);
    }

    private void openAliasDialog(class_2338 target) {
        if (this.field_22787 == null) {
            return;
        }
        String currentAlias = ClientMapNotes.getAlias(target);
        this.field_22787.method_1507((class_437)new SimpleTextInputScreen(DIALOG_ALIAS_TITLE, currentAlias != null ? currentAlias : "", alias -> ClientMapNotes.setAlias(target, alias), this));
    }

    private void openNoteEditor(class_2338 target) {
        if (this.field_22787 == null) {
            return;
        }
        this.field_22787.method_1507((class_437)new NoteEditScreen(target, this));
    }

    private int[] computeConfigBtnBounds() {
        int x = this.mapX + 25 + 4;
        int y = this.mapY + 25 + 4;
        int w = this.field_22793.method_27525((class_5348)BTN_CONFIG) + 6;
        Objects.requireNonNull(this.field_22793);
        int h = 9 + 4;
        return new int[]{x, y, w, h};
    }

    private int[] computeManualBtnBounds() {
        class_5250 lbl = class_2561.method_43473().method_10852(BTN_MANUAL).method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)"gui.roadweaver.common.on"));
        int w = this.field_22793.method_27525((class_5348)lbl) + 6;
        Objects.requireNonNull(this.field_22793);
        int h = 9 + 4;
        int x = this.mapX + 25 + 4;
        int y = this.mapY + this.mapH - 25 - 4 - h;
        return new int[]{x, y, w, h};
    }

    private boolean insideRect(double x, double y, int[] bounds) {
        return x >= (double)bounds[0] && x <= (double)(bounds[0] + bounds[2]) && y >= (double)bounds[1] && y <= (double)(bounds[1] + bounds[3]);
    }

    private boolean insideRect(double x, double y, int rx, int ry, int rw, int rh) {
        return x >= (double)rx && x <= (double)(rx + rw) && y >= (double)ry && y <= (double)(ry + rh);
    }
}

