/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapDataStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RoadWeaver");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String DATA_DIR = "config/roadweaver/mapdata";
    private static final String NOTES_FILE = "notes.json";

    private MapDataStorage() {
    }

    private static Path getDataRoot() {
        return class_310.method_1551().field_1697.toPath().resolve(DATA_DIR);
    }

    public static Path getWorldDataDir() {
        String worldId = MapDataStorage.getWorldId();
        if (worldId == null) {
            return null;
        }
        String safeName = worldId.replaceAll("[<>:\"/\\\\|?*]", "_");
        return MapDataStorage.getDataRoot().resolve(safeName);
    }

    public static String getWorldId() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) {
            return null;
        }
        if (mc.method_1542() && mc.method_1576() != null) {
            return mc.method_1576().method_27728().method_150();
        }
        if (mc.method_1558() != null) {
            return mc.method_1558().field_3761;
        }
        return null;
    }

    public static NotesData loadNotes() {
        Path dir = MapDataStorage.getWorldDataDir();
        if (dir == null) {
            return new NotesData();
        }
        Path file = dir.resolve(NOTES_FILE);
        if (!Files.exists(file, new LinkOption[0])) {
            return new NotesData();
        }
        try {
            String json = Files.readString(file, StandardCharsets.UTF_8);
            NotesData data = (NotesData)GSON.fromJson(json, NotesData.class);
            LOGGER.debug("[RoadWeaver] \u5df2\u52a0\u8f7d\u5730\u56fe\u7b14\u8bb0: {}", (Object)file);
            return data != null ? data : new NotesData();
        }
        catch (IOException e) {
            LOGGER.error("[RoadWeaver] \u52a0\u8f7d\u5730\u56fe\u7b14\u8bb0\u5931\u8d25: {}", (Object)file, (Object)e);
            return new NotesData();
        }
    }

    public static void saveNotes(NotesData data) {
        Path dir = MapDataStorage.getWorldDataDir();
        if (dir == null) {
            return;
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(NOTES_FILE);
            String json = GSON.toJson((Object)data);
            Files.writeString(file, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
            LOGGER.debug("[RoadWeaver] \u5df2\u4fdd\u5b58\u5730\u56fe\u7b14\u8bb0: {}", (Object)file);
        }
        catch (IOException e) {
            LOGGER.error("[RoadWeaver] \u4fdd\u5b58\u5730\u56fe\u7b14\u8bb0\u5931\u8d25", (Throwable)e);
        }
    }

    public static String posToKey(class_2338 pos) {
        return pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260();
    }

    public static class_2338 keyToPos(String key) {
        String[] parts = key.split(",");
        if (parts.length != 3) {
            return null;
        }
        try {
            return new class_2338(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static class NotesData {
        public Map<String, String> aliases = new HashMap<String, String>();
        public Map<String, List<String>> notes = new HashMap<String, List<String>>();
    }
}

