/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.core;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.decoration.material.surface.BiomeRoadMaterialSelector;
import net.shiroha233.roadweaver.features.decoration.system.SurfacePlacementUtil;
import net.shiroha233.roadweaver.features.roadlogic.surface.RoadHeightInterpolator;
import net.shiroha233.roadweaver.helpers.Records;

public final class SegmentPaver {
    private SegmentPaver() {
    }

    public static void paveSegment(class_5281 world, Records.RoadSegmentPlacement seg, int segmentIndex, List<class_2338> centers, int[] targetY, int roadType, List<class_2680> materials, List<class_2680> slabMaterials, class_5819 random, ModConfig cfg) {
        List<class_2338> positions = seg.positions();
        if (positions.isEmpty()) {
            return;
        }
        int[] heights = RoadHeightInterpolator.batchInterpolate(positions, segmentIndex, centers, targetY);
        for (int i = 0; i < positions.size(); ++i) {
            class_2338 widthBlock = positions.get(i);
            int y = heights[i];
            class_2338 pos = new class_2338(widthBlock.method_10263(), y, widthBlock.method_10260());
            List<class_2680> baseMats = roadType == 1 ? BiomeRoadMaterialSelector.forBiome(world, pos) : materials;
            SurfacePlacementUtil.placeOnSurface(world, pos, baseMats, 0, random, cfg);
            if (roadType != 0 || slabMaterials == null || slabMaterials.isEmpty() || !SegmentPaver.shouldPlaceSlab(widthBlock.method_10263(), widthBlock.method_10260(), y, centers, targetY)) continue;
            class_2680 slabState = slabMaterials.get(random.method_43048(slabMaterials.size()));
            if (slabState.method_26204() instanceof class_2482) {
                slabState = (class_2680)slabState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
            }
            world.method_8652(pos, slabState, 3);
        }
    }

    private static boolean shouldPlaceSlab(int x, int z, int currentY, List<class_2338> centers, int[] targetY) {
        int yAhead = RoadHeightInterpolator.getInterpolatedY(x + 1, z, centers, targetY);
        int yBehind = RoadHeightInterpolator.getInterpolatedY(x - 1, z, centers, targetY);
        int yLeft = RoadHeightInterpolator.getInterpolatedY(x, z + 1, centers, targetY);
        int yRight = RoadHeightInterpolator.getInterpolatedY(x, z - 1, centers, targetY);
        boolean needsSlabX = yAhead > currentY && yBehind >= currentY || yBehind > currentY && yAhead >= currentY;
        boolean needsSlabZ = yLeft > currentY && yRight >= currentY || yRight > currentY && yLeft >= currentY;
        return needsSlabX || needsSlabZ;
    }
}

