/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.pathfinding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.RoadPathCalculator;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;

public final class PathPostProcessor {
    private PathPostProcessor() {
    }

    public static List<Records.RoadSegmentPlacement> process(List<class_2338> rawPath, int width, class_3218 level, TerrainSamplingCache cache) {
        if (rawPath == null || rawPath.size() < 2) {
            return new ArrayList<Records.RoadSegmentPlacement>();
        }
        List<class_2338> simplified = PathPostProcessor.simplifyPath(rawPath);
        List<class_2338> controlPoints = PathPostProcessor.relaxPath(simplified);
        if (controlPoints.size() < 2) {
            return new ArrayList<Records.RoadSegmentPlacement>();
        }
        ArrayList<class_2338> extendedPoints = new ArrayList<class_2338>();
        extendedPoints.add(controlPoints.get(0));
        extendedPoints.addAll(controlPoints);
        extendedPoints.add(controlPoints.get(controlPoints.size() - 1));
        ArrayList<Vec2d> splinePoints = new ArrayList<Vec2d>();
        for (int i = 0; i < controlPoints.size() - 1; ++i) {
            class_2338 p0 = (class_2338)extendedPoints.get(i);
            class_2338 p1 = (class_2338)extendedPoints.get(i + 1);
            class_2338 p2 = (class_2338)extendedPoints.get(i + 2);
            class_2338 p3 = (class_2338)extendedPoints.get(i + 3);
            double dist = Math.sqrt(p1.method_10262((class_2382)p2));
            int steps = (int)Math.ceil(dist * 4.0);
            if (steps < 1) {
                steps = 1;
            }
            for (int s = 0; s < steps; ++s) {
                double t = (double)s / (double)steps;
                Vec2d pt = PathPostProcessor.catmullRomSplineDouble(p0, p1, p2, p3, t);
                splinePoints.add(pt);
            }
        }
        class_2338 lastBP = controlPoints.get(controlPoints.size() - 1);
        Vec2d lastPt = new Vec2d(lastBP.method_10263(), lastBP.method_10260());
        splinePoints.add(lastPt);
        ArrayList<class_2338> centers = new ArrayList<class_2338>();
        ArrayList<Double> centerDists = new ArrayList<Double>();
        double currentDist = 0.0;
        double nextCenterDist = 0.0;
        for (int i = 0; i < splinePoints.size(); ++i) {
            Vec2d p = (Vec2d)splinePoints.get(i);
            if (i > 0) {
                currentDist += p.dist((Vec2d)splinePoints.get(i - 1));
            }
            if (!(currentDist >= nextCenterDist) && i != splinePoints.size() - 1) continue;
            int y = RoadPathCalculator.heightSampler(cache, (int)Math.round(p.x), (int)Math.round(p.z), level);
            class_2338 centerPos = new class_2338((int)Math.round(p.x), y, (int)Math.round(p.z));
            if (!centers.isEmpty() && ((class_2338)centers.get(centers.size() - 1)).equals((Object)centerPos)) continue;
            centers.add(centerPos);
            centerDists.add(currentDist);
            nextCenterDist = currentDist + 1.0;
        }
        HashMap segmentedBlocks = new HashMap();
        for (int i = 0; i < centers.size(); ++i) {
            segmentedBlocks.put(i, new HashSet());
        }
        double halfWidth = (double)width / 2.0;
        double halfWidthSq = halfWidth * halfWidth;
        double pathDist = 0.0;
        int currentCenterIdx = 0;
        for (int i = 0; i < splinePoints.size() - 1; ++i) {
            Vec2d pStart = (Vec2d)splinePoints.get(i);
            Vec2d pEnd = (Vec2d)splinePoints.get(i + 1);
            double segLen = pStart.dist(pEnd);
            pathDist += segLen;
            while (currentCenterIdx < centerDists.size() - 1 && (Double)centerDists.get(currentCenterIdx + 1) < pathDist) {
                ++currentCenterIdx;
            }
            int minX = (int)Math.floor(Math.min(pStart.x, pEnd.x) - halfWidth - 1.0);
            int maxX = (int)Math.ceil(Math.max(pStart.x, pEnd.x) + halfWidth + 1.0);
            int minZ = (int)Math.floor(Math.min(pStart.z, pEnd.z) - halfWidth - 1.0);
            int maxZ = (int)Math.ceil(Math.max(pStart.z, pEnd.z) + halfWidth + 1.0);
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    double dSq = PathPostProcessor.distToSegmentSq(x, z, pStart, pEnd);
                    if (!(dSq <= halfWidthSq)) continue;
                    class_2338 blockPos = new class_2338(x, 0, z);
                    int bestIdx = currentCenterIdx;
                    double bestDistSq = Double.MAX_VALUE;
                    int searchStart = Math.max(0, currentCenterIdx - 5);
                    int searchEnd = Math.min(centers.size() - 1, currentCenterIdx + 5);
                    for (int k = searchStart; k <= searchEnd; ++k) {
                        double dz;
                        class_2338 c = (class_2338)centers.get(k);
                        double dx = x - c.method_10263();
                        double cDistSq = dx * dx + (dz = (double)(z - c.method_10260())) * dz;
                        if (!(cDistSq < bestDistSq)) continue;
                        bestDistSq = cDistSq;
                        bestIdx = k;
                    }
                    ((Set)segmentedBlocks.get(bestIdx)).add(blockPos);
                }
            }
        }
        ArrayList<Records.RoadSegmentPlacement> out = new ArrayList<Records.RoadSegmentPlacement>();
        for (int i = 0; i < centers.size(); ++i) {
            class_2338 center = (class_2338)centers.get(i);
            Set blocks = (Set)segmentedBlocks.get(i);
            if (blocks.isEmpty()) {
                blocks.add(new class_2338(center.method_10263(), 0, center.method_10260()));
            }
            out.add(new Records.RoadSegmentPlacement(center, new ArrayList<class_2338>(blocks)));
        }
        return out;
    }

    private static double distToSegmentSq(double px, double pz, Vec2d v, Vec2d w) {
        double l2 = v.distSqr(w);
        if (l2 == 0.0) {
            return (px - v.x) * (px - v.x) + (pz - v.z) * (pz - v.z);
        }
        double t = ((px - v.x) * (w.x - v.x) + (pz - v.z) * (w.z - v.z)) / l2;
        t = Math.max(0.0, Math.min(1.0, t));
        double projX = v.x + t * (w.x - v.x);
        double projZ = v.z + t * (w.z - v.z);
        return (px - projX) * (px - projX) + (pz - projZ) * (pz - projZ);
    }

    private static Vec2d catmullRomSplineDouble(class_2338 p0, class_2338 p1, class_2338 p2, class_2338 p3, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double f0 = -0.5 * t3 + t2 - 0.5 * t;
        double f1 = 1.5 * t3 - 2.5 * t2 + 1.0;
        double f2 = -1.5 * t3 + 2.0 * t2 + 0.5 * t;
        double f3 = 0.5 * t3 - 0.5 * t2;
        double x = (double)p0.method_10263() * f0 + (double)p1.method_10263() * f1 + (double)p2.method_10263() * f2 + (double)p3.method_10263() * f3;
        double z = (double)p0.method_10260() * f0 + (double)p1.method_10260() * f1 + (double)p2.method_10260() * f2 + (double)p3.method_10260() * f3;
        return new Vec2d(x, z);
    }

    private static List<class_2338> simplifyPath(List<class_2338> nodes) {
        if (nodes.size() < 3) {
            return new ArrayList<class_2338>(nodes);
        }
        ArrayList<class_2338> simplified = new ArrayList<class_2338>();
        simplified.add(nodes.get(0));
        for (int i = 1; i < nodes.size() - 1; ++i) {
            class_2338 prev = (class_2338)simplified.get(simplified.size() - 1);
            class_2338 curr = nodes.get(i);
            class_2338 next = nodes.get(i + 1);
            long dx1 = (long)curr.method_10263() - (long)prev.method_10263();
            long dz1 = (long)curr.method_10260() - (long)prev.method_10260();
            long dx2 = (long)next.method_10263() - (long)curr.method_10263();
            long dz2 = (long)next.method_10260() - (long)curr.method_10260();
            long crossProduct = dx1 * dz2 - dz1 * dx2;
            if (Math.abs(crossProduct) <= 16L) continue;
            simplified.add(curr);
        }
        simplified.add(nodes.get(nodes.size() - 1));
        return simplified;
    }

    private static List<class_2338> relaxPath(List<class_2338> nodes) {
        if (nodes.size() < 3) {
            return new ArrayList<class_2338>(nodes);
        }
        ArrayList<class_2338> relaxed = new ArrayList<class_2338>();
        relaxed.add(nodes.get(0));
        for (int i = 1; i < nodes.size() - 1; ++i) {
            class_2338 prev = nodes.get(i - 1);
            class_2338 curr = nodes.get(i);
            class_2338 next = nodes.get(i + 1);
            int nx = (prev.method_10263() + curr.method_10263() * 2 + next.method_10263()) / 4;
            int nz = (prev.method_10260() + curr.method_10260() * 2 + next.method_10260()) / 4;
            relaxed.add(new class_2338(nx, curr.method_10264(), nz));
        }
        relaxed.add(nodes.get(nodes.size() - 1));
        return relaxed;
    }

    private record Vec2d(double x, double z) {
        double dist(Vec2d o) {
            return Math.sqrt(this.distSqr(o));
        }

        double distSqr(Vec2d o) {
            return (this.x - o.x) * (this.x - o.x) + (this.z - o.z) * (this.z - o.z);
        }
    }
}

