/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.surface;

import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.config.ModConfig;

public final class RoadTerrainAdapter {
    private RoadTerrainAdapter() {
    }

    public static void adapt(class_5281 level, class_2338 middle, int width, int targetY, class_5819 random, ModConfig cfg) {
        int halfWidth = (width + 1) / 2;
        int bankWidth = 3;
        int scanRadius = halfWidth + bankWidth;
        int cx = middle.method_10263();
        int cz = middle.method_10260();
        class_2338.class_2339 cursor = new class_2338.class_2339();
        for (int dx = -scanRadius; dx <= scanRadius; ++dx) {
            for (int dz = -scanRadius; dz <= scanRadius; ++dz) {
                int fillTopY;
                double desiredY;
                int surfaceY;
                double distSq = (double)dx * (double)dx + (double)dz * (double)dz;
                double dist = Math.sqrt(distSq);
                if (dist > (double)scanRadius) continue;
                int x = cx + dx;
                int z = cz + dz;
                boolean isRoadSurface = dist <= (double)halfWidth;
                double edgeDist = dist - (double)halfWidth;
                if (edgeDist < 0.0) {
                    edgeDist = 0.0;
                }
                if (edgeDist > (double)bankWidth && !isRoadSurface || targetY - 1 <= (surfaceY = level.method_8624(class_2902.class_2903.field_13203, x, z))) continue;
                double targetBelowRoad = targetY - 1;
                if (isRoadSurface) {
                    desiredY = targetBelowRoad;
                } else {
                    double t;
                    double d = t = bankWidth <= 0 ? 1.0 : edgeDist / (double)bankWidth;
                    if (t < 0.0) {
                        t = 0.0;
                    }
                    if (t > 1.0) {
                        t = 1.0;
                    }
                    double s = t * t * (3.0 - 2.0 * t);
                    desiredY = targetBelowRoad * (1.0 - s) + (double)surfaceY * s;
                }
                if (desiredY >= (double)targetY) {
                    desiredY = targetY - 1;
                }
                if ((fillTopY = (int)Math.floor(desiredY)) <= surfaceY) continue;
                cursor.method_10103(x, surfaceY - 1, z);
                class_2680 topState = level.method_8320((class_2338)cursor);
                if (topState.method_26215() || topState.method_26227().method_15771()) {
                    topState = class_2246.field_10566.method_9564();
                }
                class_2680 innerFill = topState;
                class_2680 surfaceFill = topState;
                if (topState.method_27852(class_2246.field_10219) || topState.method_27852(class_2246.field_10566)) {
                    innerFill = class_2246.field_10566.method_9564();
                    surfaceFill = class_2246.field_10219.method_9564();
                }
                for (int y = surfaceY; y <= fillTopY; ++y) {
                    cursor.method_33098(y);
                    class_2680 cur = level.method_8320((class_2338)cursor);
                    if (!cur.method_45474()) continue;
                    if (y == fillTopY && !isRoadSurface) {
                        level.method_8652((class_2338)cursor, surfaceFill, 2);
                        continue;
                    }
                    level.method_8652((class_2338)cursor, innerFill, 2);
                }
            }
        }
    }
}

