/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.generation;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.generation.RoadGenerationService;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.RoadPositionQuery;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;
import net.shiroha233.roadweaver.planning.RoadPlanningService;
import net.shiroha233.roadweaver.structures.spawn.SpawnCabinService;

public final class InitialGenManager {
    private static volatile boolean active;
    private static final AtomicInteger total;
    private static final AtomicInteger done;
    private static final AtomicInteger generating;
    private static final AtomicInteger failed;

    private InitialGenManager() {
    }

    public static boolean isActive() {
        return active;
    }

    public static int getTotal() {
        return total.get();
    }

    public static int getDone() {
        return done.get();
    }

    public static int getGenerating() {
        return generating.get();
    }

    public static int getFailed() {
        return failed.get();
    }

    public static void begin(class_3218 level) {
        if (level == null || !class_1937.field_25179.equals(level.method_27983())) {
            return;
        }
        active = true;
        total.set(0);
        done.set(0);
        generating.set(0);
        failed.set(0);
        RoadGenerationService.onServerStarted();
        SpawnCabinService.ensurePlaced(level);
        RoadPlanningService.initialPlan(level);
        WorldDataProvider provider = WorldDataProvider.getInstance();
        List<Records.StructureConnection> conns = provider.getStructureConnections(level);
        total.set(conns == null ? 0 : conns.size());
        InitialGenManager.update(level);
    }

    public static void blockUntilDone(class_3218 level) {
        if (!active) {
            return;
        }
        WorldDataProvider provider = WorldDataProvider.getInstance();
        List<Records.StructureConnection> list = provider.getStructureConnections(level);
        if (list != null && !list.isEmpty()) {
            ArrayList<Records.StructureConnection> tasks = new ArrayList<Records.StructureConnection>();
            for (Records.StructureConnection c : list) {
                if (c.status() != Records.ConnectionStatus.PLANNED) continue;
                tasks.add(c);
            }
            if (!tasks.isEmpty()) {
                int nThreads = ConfigService.get().initialGenerationThreads();
                ExecutorService executor = Executors.newFixedThreadPool(nThreads, new ThreadFactory(){
                    private final AtomicInteger count = new AtomicInteger(1);

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread t = new Thread(r, "RoadWeaver-InitialGen-" + this.count.getAndIncrement());
                        t.setDaemon(true);
                        return t;
                    }
                });
                ArrayList<Future<AbstractMap.SimpleEntry>> futures = new ArrayList<Future<AbstractMap.SimpleEntry>>();
                for (Records.StructureConnection structureConnection : tasks) {
                    futures.add(executor.submit(() -> {
                        generating.incrementAndGet();
                        boolean success = RoadGenerationService.generateTask(level, structureConnection);
                        generating.decrementAndGet();
                        if (success) {
                            done.incrementAndGet();
                        } else {
                            failed.incrementAndGet();
                        }
                        return new AbstractMap.SimpleEntry<Records.StructureConnection, Boolean>(structureConnection, success);
                    }));
                }
                HashMap<Records.StructureConnection, Boolean> results = new HashMap<Records.StructureConnection, Boolean>();
                for (Future future : futures) {
                    try {
                        Map.Entry entry = (Map.Entry)future.get();
                        results.put((Records.StructureConnection)entry.getKey(), (Boolean)entry.getValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                executor.shutdown();
                try {
                    if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                        executor.shutdownNow();
                    }
                }
                catch (InterruptedException interruptedException) {
                    executor.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                List<Records.StructureConnection> list2 = provider.getStructureConnections(level);
                if (list2 != null) {
                    ArrayList<Records.StructureConnection> arrayList = new ArrayList<Records.StructureConnection>(list2);
                    boolean changed = false;
                    block7: for (int i = 0; i < arrayList.size(); ++i) {
                        Records.StructureConnection original = (Records.StructureConnection)arrayList.get(i);
                        for (Map.Entry entry : results.entrySet()) {
                            Records.StructureConnection task = (Records.StructureConnection)entry.getKey();
                            if (!InitialGenManager.sameEdge(original, task)) continue;
                            Records.ConnectionStatus newStatus = (Boolean)entry.getValue() != false ? Records.ConnectionStatus.COMPLETED : Records.ConnectionStatus.FAILED;
                            arrayList.set(i, new Records.StructureConnection(original.from(), original.to(), newStatus));
                            changed = true;
                            continue block7;
                        }
                    }
                    if (changed) {
                        provider.setStructureConnections(level, arrayList);
                    }
                }
            }
        }
        RoadShardStorage.flushAll(level);
        RoadPositionQuery.clearCache(level);
        active = false;
    }

    private static boolean sameEdge(Records.StructureConnection a, Records.StructureConnection b) {
        class_2338 af = a.from();
        class_2338 at = a.to();
        class_2338 bf = b.from();
        class_2338 bt = b.to();
        return af.equals((Object)bf) && at.equals((Object)bt) || af.equals((Object)bt) && at.equals((Object)bf);
    }

    public static void update(class_3218 level) {
        if (active) {
            return;
        }
        WorldDataProvider provider = WorldDataProvider.getInstance();
        List<Records.StructureConnection> conns = provider.getStructureConnections(level);
        if (conns == null) {
            total.set(0);
            generating.set(0);
            done.set(0);
            failed.set(0);
            return;
        }
        int g = 0;
        int c = 0;
        int f = 0;
        for (Records.StructureConnection sc : conns) {
            Records.ConnectionStatus s = sc.status();
            if (s == Records.ConnectionStatus.GENERATING) {
                ++g;
                continue;
            }
            if (s == Records.ConnectionStatus.COMPLETED) {
                ++c;
                continue;
            }
            if (s != Records.ConnectionStatus.FAILED) continue;
            ++f;
        }
        total.set(conns.size());
        generating.set(g);
        done.set(c);
        failed.set(f);
    }

    static {
        total = new AtomicInteger(0);
        done = new AtomicInteger(0);
        generating = new AtomicInteger(0);
        failed = new AtomicInteger(0);
    }
}

