/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.generation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.features.config.RoadFeatureConfig;
import net.shiroha233.roadweaver.features.roadlogic.core.Road;
import net.shiroha233.roadweaver.generation.InitialGenManager;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.planning.PlanningUtils;
import net.shiroha233.roadweaver.planning.RoadPlanningService;
import net.shiroha233.roadweaver.runtime.ThreadPoolManager;

public final class RoadGenerationService {
    private static final ConcurrentHashMap<class_3218, ConcurrentLinkedQueue<Records.StructureConnection>> QUEUES = new ConcurrentHashMap();
    private static final ConcurrentHashMap<class_3218, ConcurrentHashMap<Long, Boolean>> PROCESSED = new ConcurrentHashMap();
    private static final ConcurrentHashMap<class_3218, AtomicInteger> RUNNING_COUNT = new ConcurrentHashMap();
    private static final Set<Future<?>> ALL_RUNNING = ConcurrentHashMap.newKeySet();
    private static final class_2960 ROAD_CF_ID = class_2960.method_60655((String)"roadweaver", (String)"road_feature");

    private RoadGenerationService() {
    }

    public static void onServerStopping() {
        ALL_RUNNING.forEach(f -> f.cancel(true));
        ALL_RUNNING.clear();
        QUEUES.clear();
        PROCESSED.clear();
        RUNNING_COUNT.clear();
        RoadPlanningService.resetAll();
    }

    public static boolean generateTask(class_3218 level, Records.StructureConnection conn) {
        if (level == null || conn == null) {
            return false;
        }
        try {
            RoadFeatureConfig rfc;
            class_3037 class_30372;
            RoadFeatureConfig cfg;
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            class_2378 reg = level.method_30349().method_30530(class_7924.field_41239);
            class_2975 cf = (class_2975)reg.method_10223(ROAD_CF_ID);
            RoadFeatureConfig roadFeatureConfig = cfg = cf != null && (class_30372 = cf.comp_333()) instanceof RoadFeatureConfig ? (rfc = (RoadFeatureConfig)class_30372) : RoadGenerationService.defaultConfig();
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            new Road(level, conn, cfg).generateRoad(ConfigService.get().aStarMaxSteps());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Deprecated
    public static void generateInline(class_3218 level, Records.StructureConnection conn) {
        block12: {
            if (level == null || conn == null) {
                return;
            }
            WorldDataProvider provider = WorldDataProvider.getInstance();
            try {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                List<Records.StructureConnection> origin0 = provider.getStructureConnections(level);
                ArrayList<Records.StructureConnection> all0 = origin0 != null ? new ArrayList<Records.StructureConnection>(origin0) : new ArrayList();
                for (int i = 0; i < all0.size(); ++i) {
                    Records.StructureConnection c = (Records.StructureConnection)all0.get(i);
                    if (!RoadGenerationService.sameEdge(c, conn)) continue;
                    all0.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.GENERATING));
                }
                if (!all0.isEmpty()) {
                    provider.setStructureConnections(level, all0);
                }
                InitialGenManager.update(level);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException i) {
                    // empty catch block
                }
                if (RoadGenerationService.generateTask(level, conn)) {
                    List<Records.StructureConnection> origin = provider.getStructureConnections(level);
                    ArrayList<Records.StructureConnection> all = origin != null ? new ArrayList<Records.StructureConnection>(origin) : new ArrayList();
                    for (int i = 0; i < all.size(); ++i) {
                        Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                        if (!RoadGenerationService.sameEdge(c, conn)) continue;
                        all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.COMPLETED));
                    }
                    provider.setStructureConnections(level, all);
                    long k = PlanningUtils.edgeKey(conn.from(), conn.to());
                    ConcurrentHashMap<Long, Boolean> proc = PROCESSED.get(level);
                    if (proc != null) {
                        proc.remove(k);
                    }
                    break block12;
                }
                throw new RuntimeException("Generation failed");
            }
            catch (Throwable t) {
                List<Records.StructureConnection> origin = provider.getStructureConnections(level);
                ArrayList<Records.StructureConnection> all = origin != null ? new ArrayList<Records.StructureConnection>(origin) : new ArrayList();
                for (int i = 0; i < all.size(); ++i) {
                    Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                    if (!RoadGenerationService.sameEdge(c, conn)) continue;
                    all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.FAILED));
                }
                provider.setStructureConnections(level, all);
                long k = PlanningUtils.edgeKey(conn.from(), conn.to());
                ConcurrentHashMap<Long, Boolean> proc = PROCESSED.get(level);
                if (proc == null) break block12;
                proc.remove(k);
            }
        }
    }

    public static void onServerStarted() {
        ALL_RUNNING.clear();
        QUEUES.clear();
        PROCESSED.clear();
        RUNNING_COUNT.clear();
    }

    public static void tick(class_3218 level) {
        Records.StructureConnection conn;
        RoadGenerationService.refreshQueue(level);
        ALL_RUNNING.removeIf(f -> f == null || f.isDone() || f.isCancelled());
        ConcurrentLinkedQueue q = QUEUES.computeIfAbsent(level, l -> new ConcurrentLinkedQueue());
        if (q.isEmpty()) {
            return;
        }
        int limit = Math.max(1, ConfigService.get().maxConcurrentGenerations());
        AtomicInteger cnt = RUNNING_COUNT.computeIfAbsent(level, l -> new AtomicInteger(0));
        ArrayList<class_3222> players = new ArrayList<class_3222>();
        for (class_3222 p : level.method_8503().method_3760().method_14571()) {
            if (p == null || p.method_51469() != level) continue;
            players.add(p);
        }
        int sample = Math.max(64, limit * 8);
        while (cnt.get() < limit && (conn = RoadGenerationService.pollNearest(q, players, sample)) != null) {
            WorldDataProvider provider = WorldDataProvider.getInstance();
            List<Records.StructureConnection> origin = provider.getStructureConnections(level);
            ArrayList<Records.StructureConnection> all = origin != null ? new ArrayList<Records.StructureConnection>(origin) : new ArrayList();
            for (int i = 0; i < all.size(); ++i) {
                Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                if (!RoadGenerationService.sameEdge(c, conn)) continue;
                all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.GENERATING));
            }
            if (!all.isEmpty()) {
                provider.setStructureConnections(level, all);
            }
            Records.StructureConnection task = conn;
            cnt.incrementAndGet();
            long epoch = ThreadPoolManager.currentEpoch();
            Future<?> fut = ThreadPoolManager.generationExecutor().submit(() -> {
                try {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (!ThreadPoolManager.isEpoch(epoch)) {
                        return;
                    }
                    RoadGenerationService.safeGenerate(level, task, epoch);
                }
                finally {
                    cnt.decrementAndGet();
                }
            });
            ALL_RUNNING.add(fut);
        }
    }

    private static void refreshQueue(class_3218 level) {
        WorldDataProvider provider = WorldDataProvider.getInstance();
        List<Records.StructureConnection> list = provider.getStructureConnections(level);
        if (list == null) {
            return;
        }
        ConcurrentLinkedQueue q = QUEUES.computeIfAbsent(level, l -> new ConcurrentLinkedQueue());
        ConcurrentHashMap proc = PROCESSED.computeIfAbsent(level, l -> new ConcurrentHashMap());
        for (Records.StructureConnection c : list) {
            long key = PlanningUtils.edgeKey(c.from(), c.to());
            if (proc.putIfAbsent(key, Boolean.TRUE) != null || c.status() != Records.ConnectionStatus.PLANNED && c.status() != Records.ConnectionStatus.GENERATING) continue;
            q.add(c);
        }
    }

    private static void safeGenerate(class_3218 level, Records.StructureConnection conn, long epoch) {
        block12: {
            try {
                RoadFeatureConfig rfc;
                class_3037 class_30372;
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (!ThreadPoolManager.isEpoch(epoch)) {
                    return;
                }
                WorldDataProvider provider = WorldDataProvider.getInstance();
                class_2378 reg = level.method_30349().method_30530(class_7924.field_41239);
                class_2975 cf = (class_2975)reg.method_10223(ROAD_CF_ID);
                RoadFeatureConfig cfg = cf != null && (class_30372 = cf.comp_333()) instanceof RoadFeatureConfig ? (rfc = (RoadFeatureConfig)class_30372) : RoadGenerationService.defaultConfig();
                new Road(level, conn, cfg).generateRoad(ConfigService.get().aStarMaxSteps());
                MinecraftServer server = level.method_8503();
                if (server != null) {
                    server.execute(() -> {
                        if (!ThreadPoolManager.isEpoch(epoch)) {
                            return;
                        }
                        List<Records.StructureConnection> origin2 = provider.getStructureConnections(level);
                        ArrayList<Records.StructureConnection> all = origin2 != null ? new ArrayList<Records.StructureConnection>(origin2) : new ArrayList();
                        for (int i = 0; i < all.size(); ++i) {
                            Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                            if (!RoadGenerationService.sameEdge(c, conn)) continue;
                            all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.COMPLETED));
                        }
                        provider.setStructureConnections(level, all);
                        long k = PlanningUtils.edgeKey(conn.from(), conn.to());
                        ConcurrentHashMap<Long, Boolean> proc = PROCESSED.get(level);
                        if (proc != null) {
                            proc.remove(k);
                        }
                    });
                } else {
                    if (!ThreadPoolManager.isEpoch(epoch)) {
                        return;
                    }
                    List<Records.StructureConnection> origin2 = provider.getStructureConnections(level);
                    ArrayList<Records.StructureConnection> all = origin2 != null ? new ArrayList<Records.StructureConnection>(origin2) : new ArrayList();
                    for (int i = 0; i < all.size(); ++i) {
                        Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                        if (!RoadGenerationService.sameEdge(c, conn)) continue;
                        all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.COMPLETED));
                    }
                    provider.setStructureConnections(level, all);
                    long k = PlanningUtils.edgeKey(conn.from(), conn.to());
                    ConcurrentHashMap<Long, Boolean> proc = PROCESSED.get(level);
                    if (proc != null) {
                        proc.remove(k);
                    }
                }
            }
            catch (Throwable t) {
                WorldDataProvider provider = WorldDataProvider.getInstance();
                MinecraftServer server = level.method_8503();
                if (server != null) {
                    server.execute(() -> {
                        if (!ThreadPoolManager.isEpoch(epoch)) {
                            return;
                        }
                        List<Records.StructureConnection> origin2 = provider.getStructureConnections(level);
                        ArrayList<Records.StructureConnection> all = origin2 != null ? new ArrayList<Records.StructureConnection>(origin2) : new ArrayList();
                        for (int i = 0; i < all.size(); ++i) {
                            Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                            if (!RoadGenerationService.sameEdge(c, conn)) continue;
                            all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.FAILED));
                        }
                        provider.setStructureConnections(level, all);
                        long k = PlanningUtils.edgeKey(conn.from(), conn.to());
                        ConcurrentHashMap<Long, Boolean> proc = PROCESSED.get(level);
                        if (proc != null) {
                            proc.remove(k);
                        }
                    });
                }
                if (!ThreadPoolManager.isEpoch(epoch)) {
                    return;
                }
                List<Records.StructureConnection> origin2 = provider.getStructureConnections(level);
                ArrayList<Records.StructureConnection> all = origin2 != null ? new ArrayList<Records.StructureConnection>(origin2) : new ArrayList();
                for (int i = 0; i < all.size(); ++i) {
                    Records.StructureConnection c = (Records.StructureConnection)all.get(i);
                    if (!RoadGenerationService.sameEdge(c, conn)) continue;
                    all.set(i, new Records.StructureConnection(c.from(), c.to(), Records.ConnectionStatus.FAILED));
                }
                provider.setStructureConnections(level, all);
                long k = PlanningUtils.edgeKey(conn.from(), conn.to());
                ConcurrentHashMap<Long, Boolean> proc = PROCESSED.get(level);
                if (proc == null) break block12;
                proc.remove(k);
            }
        }
    }

    private static RoadFeatureConfig defaultConfig() {
        return new RoadFeatureConfig();
    }

    private static boolean sameEdge(Records.StructureConnection a, Records.StructureConnection b) {
        class_2338 af = a.from();
        class_2338 at = a.to();
        class_2338 bf = b.from();
        class_2338 bt = b.to();
        return af.equals((Object)bf) && at.equals((Object)bt) || af.equals((Object)bt) && at.equals((Object)bf);
    }

    private static long dist2XZ(class_2338 a, class_2338 b) {
        long dx = (long)a.method_10263() - (long)b.method_10263();
        long dz = (long)a.method_10260() - (long)b.method_10260();
        return dx * dx + dz * dz;
    }

    private static long playerDistance2(Records.StructureConnection c, List<class_3222> players) {
        if (players == null || players.isEmpty()) {
            return Long.MAX_VALUE;
        }
        long best = Long.MAX_VALUE;
        int mx = c.from().method_10263() + c.to().method_10263() >> 1;
        int mz = c.from().method_10260() + c.to().method_10260() >> 1;
        class_2338 mid = new class_2338(mx, 0, mz);
        for (class_3222 p : players) {
            class_2338 pb = p.method_24515();
            long d = RoadGenerationService.dist2XZ(pb, c.from());
            if (d < best) {
                best = d;
            }
            if ((d = RoadGenerationService.dist2XZ(pb, c.to())) < best) {
                best = d;
            }
            if ((d = RoadGenerationService.dist2XZ(pb, mid)) >= best) continue;
            best = d;
        }
        return best;
    }

    private static Records.StructureConnection pollNearest(ConcurrentLinkedQueue<Records.StructureConnection> q, List<class_3222> players, int sample) {
        if (q.isEmpty()) {
            return null;
        }
        if (players == null || players.isEmpty()) {
            return q.poll();
        }
        Iterator<Records.StructureConnection> it = q.iterator();
        Records.StructureConnection best = null;
        long bestd = Long.MAX_VALUE;
        while (it.hasNext()) {
            Records.StructureConnection e = it.next();
            long d = RoadGenerationService.playerDistance2(e, players);
            if (d >= bestd) continue;
            bestd = d;
            best = e;
        }
        if (best != null && q.remove(best)) {
            return best;
        }
        return q.poll();
    }
}

