/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.shiroha233.roadweaver.client.map.data.MapSnapshot;
import net.shiroha233.roadweaver.helpers.Records;

public final class MapSnapshotCodec {
    private MapSnapshotCodec() {
    }

    public static void write(class_2540 buf, MapSnapshot s) {
        List<class_2338> structures = s.structures();
        List<Records.StructureConnection> conns = s.connections();
        buf.method_10804(structures.size());
        for (class_2338 p : structures) {
            buf.method_10807(p);
        }
        for (class_2338 p : structures) {
            String name = s.structureName(p);
            boolean has = name != null;
            buf.method_52964(has);
            if (!has) continue;
            buf.method_10814(name);
        }
        buf.method_10804(conns.size());
        for (Records.StructureConnection c : conns) {
            buf.method_10807(c.from());
            buf.method_10807(c.to());
            buf.method_10804(c.status().ordinal());
        }
        List<List<class_2338>> roads = s.roadPolylines();
        buf.method_10804(roads.size());
        for (List<class_2338> pl : roads) {
            buf.method_10804(pl.size());
            for (class_2338 p : pl) {
                buf.method_10807(p);
            }
        }
    }

    public static MapSnapshot read(class_2540 buf) {
        int sc = buf.method_10816();
        ArrayList<class_2338> structures = new ArrayList<class_2338>(sc);
        for (int i = 0; i < sc; ++i) {
            structures.add(buf.method_10811());
        }
        ArrayList<Records.StructureInfo> infos = new ArrayList<Records.StructureInfo>(sc);
        for (int i = 0; i < sc; ++i) {
            boolean has = buf.readBoolean();
            if (!has) continue;
            String id = buf.method_19772();
            infos.add(new Records.StructureInfo((class_2338)structures.get(i), id));
        }
        int cc = buf.method_10816();
        ArrayList<Records.StructureConnection> conns = new ArrayList<Records.StructureConnection>(cc);
        for (int i = 0; i < cc; ++i) {
            class_2338 a = buf.method_10811();
            class_2338 b = buf.method_10811();
            int ord = buf.method_10816();
            Records.ConnectionStatus st = Records.ConnectionStatus.values()[ord];
            conns.add(new Records.StructureConnection(a, b, st));
        }
        int rp = buf.method_10816();
        ArrayList<List<class_2338>> roads = new ArrayList<List<class_2338>>(rp);
        for (int i = 0; i < rp; ++i) {
            int pc = buf.method_10816();
            ArrayList<class_2338> poly = new ArrayList<class_2338>(pc);
            for (int j = 0; j < pc; ++j) {
                poly.add(buf.method_10811());
            }
            roads.add(poly);
        }
        return new MapSnapshot(structures, conns, infos, roads);
    }
}

