/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.network.fabric;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.shiroha233.roadweaver.client.map.RoadMapScreen;
import net.shiroha233.roadweaver.client.map.data.MapDataCollector;
import net.shiroha233.roadweaver.client.map.data.MapSnapshot;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.network.MapSnapshotCodec;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.util.ComputeService;

public class MapNetworkFabric {
    public static final class_2960 REQ_RECT_ID = class_2960.method_60655((String)"roadweaver", (String)"map_request_rect");
    public static final class_2960 SNAP_ID = class_2960.method_60655((String)"roadweaver", (String)"map_snapshot");
    public static final class_2960 TP_REQ_ID = class_2960.method_60655((String)"roadweaver", (String)"map_teleport");
    public static final class_2960 TP_ACK_ID = class_2960.method_60655((String)"roadweaver", (String)"map_teleport_ack");
    public static final class_2960 MAN_REQ_ID = class_2960.method_60655((String)"roadweaver", (String)"map_manual_connect");

    public static void register() {
        PayloadTypeRegistry.playC2S().register(RequestMapSnapshotC2S.TYPE, RequestMapSnapshotC2S.CODEC);
        PayloadTypeRegistry.playS2C().register(MapSnapshotS2C.TYPE, MapSnapshotS2C.CODEC);
        PayloadTypeRegistry.playC2S().register(TeleportC2S.TYPE, TeleportC2S.CODEC);
        PayloadTypeRegistry.playS2C().register(TeleportAckS2C.TYPE, TeleportAckS2C.CODEC);
        PayloadTypeRegistry.playC2S().register(ManualConnectC2S.TYPE, ManualConnectC2S.CODEC);
    }

    public static void registerServerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(RequestMapSnapshotC2S.TYPE, (payload, context) -> {
            int radiusChunks;
            class_3222 sp = context.player();
            int minX = payload.minX;
            int minZ = payload.minZ;
            int maxX = payload.maxX;
            int maxZ = payload.maxZ;
            int cx = (int)Math.round(sp.method_23317());
            int cz = (int)Math.round(sp.method_23321());
            try {
                ModConfig cfg = ConfigService.get();
                radiusChunks = cfg.dynamicPlanEnabled() ? cfg.dynamicPlanRadiusChunks() : cfg.initialPlanRadiusChunks();
            }
            catch (Throwable t) {
                radiusChunks = 256;
            }
            int radiusBlocks = Math.max(1, radiusChunks) * 16;
            CompletableFuture.supplyAsync(() -> MapDataCollector.build(sp.method_51469(), minX, minZ, maxX, maxZ, cx, cz, radiusBlocks), ComputeService.executor()).thenAccept(snapshot -> context.server().execute(() -> ServerPlayNetworking.send((class_3222)sp, (class_8710)new MapSnapshotS2C((MapSnapshot)snapshot))));
        });
        ServerPlayNetworking.registerGlobalReceiver(TeleportC2S.TYPE, (payload, context) -> {
            class_3222 sp = context.player();
            context.server().execute(() -> {
                boolean allowed;
                boolean bl = allowed = sp.method_7337() || sp.method_5687(2);
                if (!allowed) {
                    ServerPlayNetworking.send((class_3222)sp, (class_8710)new TeleportAckS2C(false, 0, 0, 0));
                    return;
                }
                class_3218 level = sp.method_51469();
                int x = payload.x;
                int z = payload.z;
                level.method_8497(x >> 4, z >> 4);
                int ty = level.method_8624(class_2902.class_2903.field_13203, x, z);
                ty = ty <= level.method_31607() ? level.method_8615() + 1 : ++ty;
                sp.method_14251(level, (double)x + 0.5, (double)ty, (double)z + 0.5, sp.method_36454(), sp.method_36455());
                ServerPlayNetworking.send((class_3222)sp, (class_8710)new TeleportAckS2C(true, x, ty, z));
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(ManualConnectC2S.TYPE, (payload, context) -> {
            class_3222 sp = context.player();
            context.server().execute(() -> {
                class_3218 level = sp.method_51469();
                WorldDataProvider provider = WorldDataProvider.getInstance();
                List<Records.StructureConnection> origin = provider.getStructureConnections(level);
                ArrayList<Records.StructureConnection> list = origin != null ? new ArrayList<Records.StructureConnection>(origin) : new ArrayList();
                class_2338 a = new class_2338(payload.ax, 0, payload.az);
                class_2338 b = new class_2338(payload.bx, 0, payload.bz);
                boolean exists = false;
                for (Records.StructureConnection c : list) {
                    class_2338 f = c.from();
                    class_2338 t = c.to();
                    if ((!f.equals((Object)a) || !t.equals((Object)b)) && (!f.equals((Object)b) || !t.equals((Object)a))) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    list.add(new Records.StructureConnection(a, b, Records.ConnectionStatus.PLANNED));
                    provider.setStructureConnections(level, list);
                }
            });
        });
    }

    public static void registerClientReceivers() {
        ClientPlayNetworking.registerGlobalReceiver(MapSnapshotS2C.TYPE, (payload, context) -> {
            MapSnapshot s = payload.snapshot;
            context.client().execute(() -> {
                class_437 patt0$temp = context.client().field_1755;
                if (patt0$temp instanceof RoadMapScreen) {
                    RoadMapScreen screen = (RoadMapScreen)patt0$temp;
                    screen.setSnapshot(s);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(TeleportAckS2C.TYPE, (payload, context) -> {
            boolean ok = payload.ok;
            int fx = payload.x;
            int fy = payload.y;
            int fz = payload.z;
            context.client().execute(() -> {
                if (context.client().field_1724 == null) {
                    return;
                }
                if (ok) {
                    context.client().field_1724.method_7353((class_2561)class_2561.method_43469((String)"gui.roadweaver.map.teleport.success_pos", (Object[])new Object[]{fx, fy, fz}), true);
                } else {
                    context.client().field_1724.method_7353((class_2561)class_2561.method_43471((String)"gui.roadweaver.map.teleport.denied"), true);
                }
            });
        });
    }

    public static void requestSnapshot(int minX, int minZ, int maxX, int maxZ) {
        ClientPlayNetworking.send((class_8710)new RequestMapSnapshotC2S(minX, minZ, maxX, maxZ));
    }

    public static void requestTeleport(int x, int y, int z) {
        ClientPlayNetworking.send((class_8710)new TeleportC2S(x, y, z));
    }

    public static void requestManualConnect(int ax, int az, int bx, int bz) {
        ClientPlayNetworking.send((class_8710)new ManualConnectC2S(ax, az, bx, bz));
    }

    public record RequestMapSnapshotC2S(int minX, int minZ, int maxX, int maxZ) implements class_8710
    {
        public static final class_8710.class_9154<RequestMapSnapshotC2S> TYPE = new class_8710.class_9154(REQ_RECT_ID);
        public static final class_9139<class_2540, RequestMapSnapshotC2S> CODEC = class_9139.method_56437((buf, v) -> {
            buf.method_10804(v.minX);
            buf.method_10804(v.minZ);
            buf.method_10804(v.maxX);
            buf.method_10804(v.maxZ);
        }, buf -> new RequestMapSnapshotC2S(buf.method_10816(), buf.method_10816(), buf.method_10816(), buf.method_10816()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record MapSnapshotS2C(MapSnapshot snapshot) implements class_8710
    {
        public static final class_8710.class_9154<MapSnapshotS2C> TYPE = new class_8710.class_9154(SNAP_ID);
        public static final class_9139<class_2540, MapSnapshotS2C> CODEC = class_9139.method_56437((buf, v) -> MapSnapshotCodec.write(buf, v.snapshot), buf -> new MapSnapshotS2C(MapSnapshotCodec.read(buf)));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record TeleportC2S(int x, int y, int z) implements class_8710
    {
        public static final class_8710.class_9154<TeleportC2S> TYPE = new class_8710.class_9154(TP_REQ_ID);
        public static final class_9139<class_2540, TeleportC2S> CODEC = class_9139.method_56437((buf, v) -> {
            buf.method_10804(v.x);
            buf.method_10804(v.y);
            buf.method_10804(v.z);
        }, buf -> new TeleportC2S(buf.method_10816(), buf.method_10816(), buf.method_10816()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record TeleportAckS2C(boolean ok, int x, int y, int z) implements class_8710
    {
        public static final class_8710.class_9154<TeleportAckS2C> TYPE = new class_8710.class_9154(TP_ACK_ID);
        public static final class_9139<class_2540, TeleportAckS2C> CODEC = class_9139.method_56437((buf, v) -> {
            buf.method_52964(v.ok);
            buf.method_10804(v.x);
            buf.method_10804(v.y);
            buf.method_10804(v.z);
        }, buf -> new TeleportAckS2C(buf.readBoolean(), buf.method_10816(), buf.method_10816(), buf.method_10816()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }

    public record ManualConnectC2S(int ax, int az, int bx, int bz) implements class_8710
    {
        public static final class_8710.class_9154<ManualConnectC2S> TYPE = new class_8710.class_9154(MAN_REQ_ID);
        public static final class_9139<class_2540, ManualConnectC2S> CODEC = class_9139.method_56437((buf, v) -> {
            buf.method_10804(v.ax);
            buf.method_10804(v.az);
            buf.method_10804(v.bx);
            buf.method_10804(v.bz);
        }, buf -> new ManualConnectC2S(buf.method_10816(), buf.method_10816(), buf.method_10816(), buf.method_10816()));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }
}

