/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.persistence;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_5281;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;

public final class RoadPositionQuery {
    private static final Map<String, Map<Long, Set<Long>>> CHUNK_CACHE = new ConcurrentHashMap<String, Map<Long, Set<Long>>>();
    private static final int EXTRA_MARGIN = 1;
    private static final int Y_CHECK_ABOVE = 12;
    private static final int Y_CHECK_BELOW = 2;

    private RoadPositionQuery() {
    }

    public static boolean isOnRoad(class_3218 level, class_2338 pos) {
        if (level == null || pos == null) {
            return false;
        }
        if (!ConfigService.get().preventTreesOnRoad()) {
            return false;
        }
        int cx = pos.method_10263() >> 4;
        int cz = pos.method_10260() >> 4;
        long chunkKey = RoadPositionQuery.chunkKey(cx, cz);
        String dimKey = RoadPositionQuery.dimKey(level);
        Map dimCache = CHUNK_CACHE.computeIfAbsent(dimKey, k -> new ConcurrentHashMap());
        Set roadPoints = dimCache.computeIfAbsent(chunkKey, k -> RoadPositionQuery.buildChunkRoadPoints(level, cx, cz));
        if (roadPoints.isEmpty()) {
            return false;
        }
        int tx = pos.method_10263();
        int ty = pos.method_10264();
        int tz = pos.method_10260();
        int margin = ConfigService.get().roadWidth() / 2 + 1;
        Iterator iterator = roadPoints.iterator();
        while (iterator.hasNext()) {
            int yDiff;
            long packed = (Long)iterator.next();
            class_2338 road = class_2338.method_10092((long)packed);
            if (Math.abs(tx - road.method_10263()) > margin || Math.abs(tz - road.method_10260()) > margin || (yDiff = ty - road.method_10264()) < -2 || yDiff > 12) continue;
            return true;
        }
        return false;
    }

    private static Set<Long> buildChunkRoadPoints(class_3218 level, int cx, int cz) {
        int minX = cx << 4;
        int minZ = cz << 4;
        int maxX = minX + 15;
        int maxZ = minZ + 15;
        List<Records.RoadData> roads = RoadShardStorage.queryRect(level, minX - 8, minZ - 8, maxX + 8, maxZ + 8);
        if (roads.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> points = new HashSet<Long>();
        for (Records.RoadData rd : roads) {
            if (rd.roadSegmentList() == null) continue;
            for (Records.RoadSegmentPlacement seg : rd.roadSegmentList()) {
                RoadPositionQuery.addIfInChunk(points, seg.middlePos(), minX, minZ, maxX, maxZ);
                if (seg.positions() == null) continue;
                for (class_2338 p : seg.positions()) {
                    RoadPositionQuery.addIfInChunk(points, p, minX, minZ, maxX, maxZ);
                }
            }
        }
        return points.isEmpty() ? Collections.emptySet() : points;
    }

    private static void addIfInChunk(Set<Long> set, class_2338 p, int minX, int minZ, int maxX, int maxZ) {
        int x = p.method_10263();
        int z = p.method_10260();
        if (x >= minX - 8 && x <= maxX + 8 && z >= minZ - 8 && z <= maxZ + 8) {
            set.add(p.method_10063());
        }
    }

    public static boolean isOnRoad(class_5281 level, class_2338 pos) {
        class_3218 sl = RoadPositionQuery.extractServerLevel(level);
        return sl != null && RoadPositionQuery.isOnRoad(sl, pos);
    }

    private static class_3218 extractServerLevel(class_5281 level) {
        if (level instanceof class_3218) {
            class_3218 sl = (class_3218)level;
            return sl;
        }
        if (level instanceof class_3233) {
            class_3233 region = (class_3233)level;
            return region.method_8410();
        }
        return null;
    }

    private static long chunkKey(int cx, int cz) {
        return (long)cx << 32 | (long)cz & 0xFFFFFFFFL;
    }

    private static String dimKey(class_3218 level) {
        return level.method_27983().method_29177().toString();
    }

    public static void clearCache(class_3218 level) {
        if (level != null) {
            CHUNK_CACHE.remove(RoadPositionQuery.dimKey(level));
        }
    }

    public static void clearAllCache() {
        CHUNK_CACHE.clear();
    }
}

