/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.persistence.sharded;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.shiroha233.roadweaver.helpers.Records;

public final class RoadShardStorage {
    private static final int SHARD_SIZE_CHUNKS = 32;
    private static final int MAX_CACHE_SHARDS = 128;
    private static final DynamicOps<class_2520> OPS = class_2509.field_11560;
    private static final ConcurrentHashMap<String, LinkedHashMap<Long, Shard>> CACHE = new ConcurrentHashMap();

    private RoadShardStorage() {
    }

    private static String dimKey(class_3218 level) {
        class_2960 rl = level.method_27983().method_29177();
        return rl.method_12836() + "/" + rl.method_12832();
    }

    private static String cacheKey(class_3218 level) {
        Path worldRoot = level.method_8503().method_27050(class_5218.field_24188);
        String worldId = worldRoot == null ? "unknown" : worldRoot.toAbsolutePath().normalize().toString();
        return worldId + "|" + RoadShardStorage.dimKey(level);
    }

    private static Path basePath(class_3218 level) {
        Path worldRoot = level.method_8503().method_27050(class_5218.field_24188);
        return worldRoot.resolve("data/roadweaver/roads").resolve(RoadShardStorage.dimKey(level));
    }

    private static long shardKey(int rx, int rz) {
        return (long)rx << 32 ^ (long)rz & 0xFFFFFFFFL;
    }

    private static int floorDiv(int a, int b) {
        int r = a / b;
        if ((a ^ b) < 0 && r * b != a) {
            --r;
        }
        return r;
    }

    private static int blockToRegion(int block) {
        int chunk = RoadShardStorage.floorDiv(block, 16);
        return RoadShardStorage.floorDiv(chunk, 32);
    }

    private static Path shardPath(class_3218 level, int rx, int rz) throws IOException {
        Path dir = RoadShardStorage.basePath(level);
        Files.createDirectories(dir, new FileAttribute[0]);
        return dir.resolve("r." + rx + "." + rz + ".nbt");
    }

    private static LinkedHashMap<Long, Shard> cacheForDim(final class_3218 level) {
        String dk = RoadShardStorage.cacheKey(level);
        return CACHE.computeIfAbsent(dk, k -> new LinkedHashMap<Long, Shard>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, Shard> eldest) {
                if (this.size() > 128) {
                    Shard s = eldest.getValue();
                    if (s != null) {
                        try {
                            RoadShardStorage.saveShard(level, s);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return true;
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Shard loadShard(class_3218 level, int rx, int rz) throws IOException {
        LinkedHashMap<Long, Shard> cache = RoadShardStorage.cacheForDim(level);
        long sk = RoadShardStorage.shardKey(rx, rz);
        LinkedHashMap<Long, Shard> linkedHashMap = cache;
        synchronized (linkedHashMap) {
            class_2487 tag;
            Shard s = cache.get(sk);
            if (s != null) {
                return s;
            }
            Path p = RoadShardStorage.shardPath(level, rx, rz);
            ArrayList<Records.RoadData> roads = new ArrayList<Records.RoadData>();
            if (Files.exists(p, new LinkOption[0]) && (tag = class_2507.method_30613((Path)p, (class_2505)class_2505.method_53898())) != null && tag.method_10545("roads")) {
                class_2520 list = tag.method_10580("roads");
                DataResult res = Codec.list(Records.RoadData.CODEC).parse(new Dynamic(OPS, (Object)list));
                res.result().ifPresent(roads::addAll);
            }
            s = new Shard(rx, rz, roads);
            cache.put(sk, s);
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveShard(class_3218 level, Shard s) throws IOException {
        ArrayList<Records.RoadData> snapshot;
        Shard shard = s;
        synchronized (shard) {
            if (!s.dirty) {
                return;
            }
            snapshot = new ArrayList<Records.RoadData>(s.roads);
            s.dirty = false;
        }
        class_2487 tag = new class_2487();
        Codec.list(Records.RoadData.CODEC).encodeStart(OPS, snapshot).result().ifPresent(nbt -> tag.method_10566("roads", nbt));
        Path p = RoadShardStorage.shardPath(level, s.rx, s.rz);
        class_2507.method_30614((class_2487)tag, (Path)p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushAll(class_3218 level) {
        LinkedHashMap<Long, Shard> cache;
        LinkedHashMap<Long, Shard> linkedHashMap = cache = RoadShardStorage.cacheForDim(level);
        synchronized (linkedHashMap) {
            for (Shard s : cache.values()) {
                try {
                    RoadShardStorage.saveShard(level, s);
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAll(class_3218 level) {
        LinkedHashMap<Long, Shard> cache;
        LinkedHashMap<Long, Shard> linkedHashMap = cache = RoadShardStorage.cacheForDim(level);
        synchronized (linkedHashMap) {
            cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRoad(class_3218 level, Records.RoadData rd) {
        if (rd == null || rd.roadSegmentList() == null || rd.roadSegmentList().isEmpty()) {
            return;
        }
        int minx = Integer.MAX_VALUE;
        int minz = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxz = Integer.MIN_VALUE;
        for (Records.RoadSegmentPlacement seg : rd.roadSegmentList()) {
            class_2338 p = seg.middlePos();
            int x = p.method_10263();
            int z = p.method_10260();
            if (x < minx) {
                minx = x;
            }
            if (z < minz) {
                minz = z;
            }
            if (x > maxx) {
                maxx = x;
            }
            if (z <= maxz) continue;
            maxz = z;
        }
        int rx0 = RoadShardStorage.blockToRegion(minx);
        int rz0 = RoadShardStorage.blockToRegion(minz);
        int rx1 = RoadShardStorage.blockToRegion(maxx);
        int rz1 = RoadShardStorage.blockToRegion(maxz);
        for (int rx = rx0; rx <= rx1; ++rx) {
            for (int rz = rz0; rz <= rz1; ++rz) {
                try {
                    Shard s = RoadShardStorage.loadShard(level, rx, rz);
                    long id = RoadShardStorage.fingerprint(rd);
                    Shard shard = s;
                    synchronized (shard) {
                        if (s.ids.add(id)) {
                            s.roads.add(rd);
                            s.dirty = true;
                        }
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static long fingerprint(Records.RoadData rd) {
        if (rd == null || rd.roadSegmentList() == null || rd.roadSegmentList().isEmpty()) {
            return 0L;
        }
        class_2338 a = rd.roadSegmentList().get(0).middlePos();
        class_2338 b = rd.roadSegmentList().get(rd.roadSegmentList().size() - 1).middlePos();
        long ka = (long)a.method_10263() << 32 ^ (long)a.method_10260() & 0xFFFFFFFFL;
        long kb = (long)b.method_10263() << 32 ^ (long)b.method_10260() & 0xFFFFFFFFL;
        long lo = Math.min(ka, kb);
        long hi = Math.max(ka, kb);
        long f = hi << 1 ^ lo;
        f ^= (long)rd.width() & 0xFFFFFFFFL;
        return f ^= ((long)rd.roadType() & 0xFFFFFFFFL) << 33;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Records.RoadData> queryRect(class_3218 level, int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        int rx0 = RoadShardStorage.blockToRegion(minBlockX);
        int rz0 = RoadShardStorage.blockToRegion(minBlockZ);
        int rx1 = RoadShardStorage.blockToRegion(maxBlockX);
        int rz1 = RoadShardStorage.blockToRegion(maxBlockZ);
        ArrayList<Records.RoadData> out = new ArrayList<Records.RoadData>();
        HashSet<Long> seen = new HashSet<Long>();
        for (int rx = rx0; rx <= rx1; ++rx) {
            for (int rz = rz0; rz <= rz1; ++rz) {
                try {
                    ArrayList<Records.RoadData> snapshot;
                    Shard s = RoadShardStorage.loadShard(level, rx, rz);
                    Shard shard = s;
                    synchronized (shard) {
                        snapshot = new ArrayList<Records.RoadData>(s.roads);
                    }
                    for (Records.RoadData rd : snapshot) {
                        long id;
                        if (!RoadShardStorage.intersects(rd, minBlockX, minBlockZ, maxBlockX, maxBlockZ) || !seen.add(id = RoadShardStorage.fingerprint(rd))) continue;
                        out.add(rd);
                    }
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return out;
    }

    private static boolean intersects(Records.RoadData rd, int minx, int minz, int maxx, int maxz) {
        if (rd == null || rd.roadSegmentList() == null || rd.roadSegmentList().isEmpty()) {
            return false;
        }
        int rminx = Integer.MAX_VALUE;
        int rminz = Integer.MAX_VALUE;
        int rmaxx = Integer.MIN_VALUE;
        int rmaxz = Integer.MIN_VALUE;
        for (Records.RoadSegmentPlacement seg : rd.roadSegmentList()) {
            class_2338 p = seg.middlePos();
            int x = p.method_10263();
            int z = p.method_10260();
            if (x < rminx) {
                rminx = x;
            }
            if (z < rminz) {
                rminz = z;
            }
            if (x > rmaxx) {
                rmaxx = x;
            }
            if (z <= rmaxz) continue;
            rmaxz = z;
        }
        return rmaxx >= minx && rminx <= maxx && rmaxz >= minz && rminz <= maxz;
    }

    private static final class Shard {
        final int rx;
        final int rz;
        final List<Records.RoadData> roads;
        final Set<Long> ids = new HashSet<Long>();
        boolean dirty;

        Shard(int rx, int rz, List<Records.RoadData> roads) {
            this.rx = rx;
            this.rz = rz;
            this.roads = new ArrayList<Records.RoadData>(roads != null ? roads : List.of());
            for (Records.RoadData rd : this.roads) {
                this.ids.add(RoadShardStorage.fingerprint(rd));
            }
            this.dirty = false;
        }
    }
}

