/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.shiroha233.roadweaver.structures.StructureSystem;
import net.shiroha233.roadweaver.structures.api.BlendProfile;
import net.shiroha233.roadweaver.structures.api.SpawnRule;
import net.shiroha233.roadweaver.structures.api.StructureBlueprint;
import net.shiroha233.roadweaver.structures.api.StructureConnector;
import net.shiroha233.roadweaver.structures.api.StructureVariant;
import net.shiroha233.roadweaver.structures.roadside.RoadsideType;
import net.shiroha233.roadweaver.structures.roadside.StructureScale;

public final class RoadsideBlueprints {
    private static final Map<RoadsideType, StructureBlueprint> CACHE = new EnumMap<RoadsideType, StructureBlueprint>(RoadsideType.class);
    private static volatile boolean initialized = false;

    private RoadsideBlueprints() {
    }

    public static synchronized void registerAll() {
        if (initialized) {
            return;
        }
        for (RoadsideType type : RoadsideType.values()) {
            StructureBlueprint bp = RoadsideBlueprints.createBlueprint(type);
            CACHE.put(type, bp);
            StructureSystem.registerBlueprint(bp);
        }
        initialized = true;
    }

    public static StructureBlueprint get(RoadsideType type) {
        if (!initialized) {
            RoadsideBlueprints.registerAll();
        }
        return CACHE.get((Object)type);
    }

    public static class_2960 blueprintId(RoadsideType type) {
        return class_2960.method_60655((String)"roadweaver", (String)("roadside_" + type.name().toLowerCase()));
    }

    private static StructureBlueprint createBlueprint(RoadsideType type) {
        class_2960 id = RoadsideBlueprints.blueprintId(type);
        class_2960 templateId = type.templateId();
        class_2382 sizeHint = type.sizeHint();
        List<StructureVariant> variants = Collections.singletonList(new StructureVariant(templateId, type.weight(), true));
        List<StructureConnector> connectors = Collections.emptyList();
        BlendProfile blend = null;
        SpawnRule rule = RoadsideBlueprints.createSpawnRule(type);
        return new StructureBlueprint(id, variants, connectors, sizeHint, blend, rule);
    }

    private static SpawnRule createSpawnRule(RoadsideType type) {
        StructureScale scale = type.scale();
        int spacing = scale.defaultSpacing();
        int separation = scale.defaultSeparation();
        return new SpawnRule(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), spacing, separation, -64, 320, 0, 0);
    }

    public static synchronized void clearCache() {
        CACHE.clear();
        initialized = false;
    }
}

