/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.structures.StructureSystem;
import net.shiroha233.roadweaver.structures.pipeline.StructurePlacer;
import net.shiroha233.roadweaver.structures.roadside.BiomeCategory;
import net.shiroha233.roadweaver.structures.roadside.RoadPlacementContext;
import net.shiroha233.roadweaver.structures.roadside.RoadsideType;
import net.shiroha233.roadweaver.structures.roadside.StructureScale;

public final class RoadsideStructureService {
    private static final int RANDOM_OFFSET_RANGE = 3;

    private RoadsideStructureService() {
    }

    public static boolean tryPlace(class_5281 world, class_3218 server, class_2338 middlePos, class_2338 prevPos, class_2338 nextPos, int roadWidth, int roadLength, RoadPlacementContext ctx, class_5819 random, ModConfig cfg) {
        int dz;
        if (!cfg.roadsideStructuresEnabled()) {
            return false;
        }
        if (ctx.isMaxReached(cfg.maxStructuresPerRoad())) {
            return false;
        }
        class_6880 biome = world.method_23753(middlePos);
        BiomeCategory biomeCategory = BiomeCategory.fromBiome((class_6880<class_1959>)biome);
        RoadsideType type = RoadsideType.chooseWeightedFiltered(random, biomeCategory, roadLength);
        if (type == null) {
            return false;
        }
        int dx = nextPos.method_10263() - prevPos.method_10263();
        double len = Math.sqrt((double)dx * (double)dx + (double)(dz = nextPos.method_10260() - prevPos.method_10260()) * (double)dz);
        if (len < 0.001) {
            return false;
        }
        double dirX = (double)dx / len;
        double dirZ = (double)dz / len;
        double orthoX = -dirZ;
        double orthoZ = dirX;
        boolean leftSide = random.method_43056();
        double sideMultiplier = leftSide ? 1.0 : -1.0;
        int halfWidth = Math.max(1, roadWidth / 2);
        int sideOffset = halfWidth + RoadsideStructureService.getOffsetForScale(type.scale(), cfg) + random.method_43048(4);
        int placeX = middlePos.method_10263() + (int)Math.round(orthoX * (double)sideOffset * sideMultiplier);
        int placeZ = middlePos.method_10260() + (int)Math.round(orthoZ * (double)sideOffset * sideMultiplier);
        class_2382 sizeHint = type.sizeHint();
        int halfSizeX = sizeHint.method_10263() / 2;
        int halfSizeZ = sizeHint.method_10260() / 2;
        int[] sampleHeights = RoadsideStructureService.sampleGroundHeights(world, placeX, placeZ, halfSizeX, halfSizeZ);
        int placeY = sampleHeights[0];
        int slopeHeight = sampleHeights[0] - sampleHeights[1];
        StructureScale scale = type.scale();
        if (slopeHeight > scale.maxSlope()) {
            return false;
        }
        class_2338 placePos = new class_2338(placeX, placeY, placeZ);
        if (RoadsideStructureService.isOnWater(world, placeX, placeY, placeZ, halfSizeX, halfSizeZ)) {
            return false;
        }
        int heightDiff = Math.abs(placeY - middlePos.method_10264());
        if (heightDiff > scale.maxHeightDiff()) {
            return false;
        }
        if (!ctx.checkSpacing(placePos, cfg.minStructureSpacing())) {
            return false;
        }
        if (StructureSystem.index(server).existsNear(placePos, cfg.minStructureSpacing())) {
            return false;
        }
        class_2470 rotation = RoadsideStructureService.calculateRotation(dirX, dirZ, leftSide, type.faceRoad());
        class_2960 templateId = type.templateId();
        boolean placed = StructurePlacer.placeSimple(world, server, templateId, placePos, rotation, true, true, true, random);
        if (placed) {
            ctx.recordPlacement(placePos);
        }
        return placed;
    }

    private static int getOffsetForScale(StructureScale scale, ModConfig cfg) {
        return switch (scale) {
            default -> throw new MatchException(null, null);
            case StructureScale.SMALL -> cfg.smallStructureOffset();
            case StructureScale.MEDIUM -> cfg.mediumStructureOffset();
            case StructureScale.LARGE -> cfg.largeStructureOffset();
        };
    }

    public static void processSegments(class_5281 world, class_3218 server, List<class_2338> middlePositions, int roadWidth, class_5819 random, ModConfig cfg, int startIndex, int endIndex) {
        if (middlePositions == null || middlePositions.size() < 5) {
            return;
        }
        int roadLength = middlePositions.size();
        RoadPlacementContext ctx = new RoadPlacementContext(roadLength);
        int safeStart = Math.max(2, startIndex);
        int safeEnd = Math.min(middlePositions.size() - 3, endIndex);
        int checkInterval = RoadsideStructureService.calculateCheckInterval(safeEnd - safeStart, cfg.maxStructuresPerRoad());
        for (int i = safeStart; i < safeEnd; ++i) {
            if ((i - safeStart) % checkInterval != 0) continue;
            if (ctx.isMaxReached(cfg.maxStructuresPerRoad())) break;
            class_2338 middle = middlePositions.get(i);
            class_2338 prev = middlePositions.get(i - 2);
            class_2338 next = middlePositions.get(i + 2);
            RoadsideStructureService.tryPlace(world, server, middle, prev, next, roadWidth, roadLength, ctx, random, cfg);
        }
    }

    private static int calculateCheckInterval(int totalSegments, int maxStructures) {
        if (maxStructures <= 0 || totalSegments <= 0) {
            return Integer.MAX_VALUE;
        }
        return Math.max(1, totalSegments / (maxStructures + 1));
    }

    private static class_2470 calculateRotation(double dirX, double dirZ, boolean leftSide, boolean faceRoad) {
        double absZ;
        if (!faceRoad) {
            return class_2470.field_11467;
        }
        double absX = Math.abs(dirX);
        if (absX > (absZ = Math.abs(dirZ))) {
            if (leftSide) {
                return dirX > 0.0 ? class_2470.field_11464 : class_2470.field_11467;
            }
            return dirX > 0.0 ? class_2470.field_11467 : class_2470.field_11464;
        }
        if (leftSide) {
            return dirZ > 0.0 ? class_2470.field_11463 : class_2470.field_11465;
        }
        return dirZ > 0.0 ? class_2470.field_11465 : class_2470.field_11463;
    }

    private static int[][] getSampleOffsets(int halfX, int halfZ) {
        return new int[][]{{0, 0}, {-halfX, -halfZ}, {halfX, -halfZ}, {-halfX, halfZ}, {halfX, halfZ}};
    }

    private static int[] sampleGroundHeights(class_5281 world, int centerX, int centerZ, int halfX, int halfZ) {
        int maxY = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        for (int[] offset : RoadsideStructureService.getSampleOffsets(halfX, halfZ)) {
            int x = centerX + offset[0];
            int z = centerZ + offset[1];
            int y = world.method_8624(class_2902.class_2903.field_13203, x, z);
            maxY = Math.max(maxY, y);
            minY = Math.min(minY, y);
        }
        return new int[]{maxY, minY};
    }

    private static boolean isOnWater(class_5281 world, int centerX, int centerY, int centerZ, int halfX, int halfZ) {
        for (int[] offset : RoadsideStructureService.getSampleOffsets(halfX, halfZ)) {
            int x = centerX + offset[0];
            int z = centerZ + offset[1];
            for (int dy = 0; dy >= -2; --dy) {
                class_2680 state = world.method_8320(new class_2338(x, centerY + dy, z));
                if (!state.method_27852(class_2246.field_10382) && !state.method_26227().method_15771()) continue;
                return true;
            }
        }
        return false;
    }
}

