/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.roadside;

import java.util.ArrayList;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.shiroha233.roadweaver.structures.roadside.BiomeCategory;
import net.shiroha233.roadweaver.structures.roadside.RoadsidePlacementRule;
import net.shiroha233.roadweaver.structures.roadside.StructureScale;

public enum RoadsideType {
    BENCH("roadside/roadside_bench", 3, 2, 2, 10, true, StructureScale.SMALL, RoadsidePlacementRule.TEMPERATE),
    CAMPFIRE("roadside/small_campfire", 3, 3, 3, 8, false, StructureScale.SMALL, RoadsidePlacementRule.UNIVERSAL),
    SAKURA_COFFEE_HOUSE("roadside/sakura_coffee_house", 12, 10, 12, 5, true, StructureScale.MEDIUM, RoadsidePlacementRule.builder().allow(BiomeCategory.CHERRY_GROVE).minRoadLength(50).build());

    private final class_2960 templateId;
    private final class_2382 sizeHint;
    private final int weight;
    private final boolean faceRoad;
    private final StructureScale scale;
    private final RoadsidePlacementRule placementRule;

    private RoadsideType(String path, int sizeX, int sizeY, int sizeZ, int weight, boolean faceRoad, StructureScale scale, RoadsidePlacementRule placementRule) {
        this.templateId = class_2960.method_60655((String)"roadweaver", (String)path);
        this.sizeHint = new class_2382(sizeX, sizeY, sizeZ);
        this.weight = weight;
        this.faceRoad = faceRoad;
        this.scale = scale;
        this.placementRule = placementRule;
    }

    public class_2960 templateId() {
        return this.templateId;
    }

    public class_2382 sizeHint() {
        return this.sizeHint;
    }

    public int weight() {
        return this.weight;
    }

    public boolean faceRoad() {
        return this.faceRoad;
    }

    public StructureScale scale() {
        return this.scale;
    }

    public RoadsidePlacementRule placementRule() {
        return this.placementRule;
    }

    @Deprecated
    public static RoadsideType chooseWeighted(class_5819 random) {
        int total = 0;
        for (RoadsideType t : RoadsideType.values()) {
            total += t.weight;
        }
        int roll = random.method_43048(total);
        int sum = 0;
        for (RoadsideType t : RoadsideType.values()) {
            if (roll >= (sum += t.weight)) continue;
            return t;
        }
        return RoadsideType.values()[0];
    }

    public static RoadsideType chooseWeightedFiltered(class_5819 random, BiomeCategory biome, int roadLength) {
        ArrayList<RoadsideType> candidates = new ArrayList<RoadsideType>();
        int totalWeight = 0;
        for (RoadsideType type : RoadsideType.values()) {
            RoadsidePlacementRule rule = type.placementRule;
            if (!rule.isBiomeAllowed(biome) || !rule.isRoadLongEnough(roadLength)) continue;
            candidates.add(type);
            totalWeight += type.weight;
        }
        if (candidates.isEmpty() || totalWeight <= 0) {
            return null;
        }
        int roll = random.method_43048(totalWeight);
        int sum = 0;
        for (RoadsideType type : candidates) {
            if (roll >= (sum += type.weight)) continue;
            return type;
        }
        return (RoadsideType)((Object)candidates.get(0));
    }
}

