/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.structures.spawn;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.structures.StructureSystem;
import net.shiroha233.roadweaver.structures.api.BlendProfile;
import net.shiroha233.roadweaver.structures.api.SpawnRule;
import net.shiroha233.roadweaver.structures.api.StructureBlueprint;
import net.shiroha233.roadweaver.structures.api.StructureConnector;
import net.shiroha233.roadweaver.structures.api.StructureVariant;
import net.shiroha233.roadweaver.structures.model.StructureInstance;
import net.shiroha233.roadweaver.structures.pipeline.StructurePlacer;

public final class SpawnCabinService {
    private static final class_2960 BLUEPRINT_ID = class_2960.method_60655((String)"roadweaver", (String)"spawn_cabin");
    private static final class_2960 TEMPLATE_ID = class_2960.method_60655((String)"roadweaver", (String)"structures/starting_cabin");

    private SpawnCabinService() {
    }

    public static boolean ensurePlaced(class_3218 level) {
        if (level == null) {
            return false;
        }
        class_2338 spawn = level.method_43126();
        if (StructureSystem.index(level).existsNear(spawn, 64)) {
            return false;
        }
        WorldDataProvider provider = WorldDataProvider.getInstance();
        Records.StructureLocationData locs = provider.getStructureLocations(level);
        if (locs != null && locs.structureLocations() != null && !locs.structureLocations().isEmpty()) {
            return false;
        }
        StructureBlueprint bp = StructureBlueprints.spawnCabin(BLUEPRINT_ID, TEMPLATE_ID);
        StructureSystem.registerBlueprint(bp);
        int y = level.method_8624(class_2902.class_2903.field_13203, spawn.method_10263(), spawn.method_10260());
        class_2338 anchor = new class_2338(spawn.method_10263(), y, spawn.method_10260());
        class_238 bounds = new class_238(anchor).method_1009(8.0, 5.0, 8.0);
        BlendProfile blend = BlendProfile.platformDefault();
        StructureInstance inst = StructurePlacer.place(level, bp, TEMPLATE_ID, anchor, class_2470.field_11467, class_2415.field_11302, bounds, blend);
        StructureSystem.index(level).add(inst);
        provider.addStructureLocation(level, anchor);
        provider.addStructureInstance(level, inst);
        return true;
    }

    static final class StructureBlueprints {
        StructureBlueprints() {
        }

        static StructureBlueprint spawnCabin(class_2960 id, class_2960 templateId) {
            List<StructureVariant> variants = Collections.singletonList(new StructureVariant(templateId, 1, true));
            List<StructureConnector> connectors = Collections.emptyList();
            class_2382 sizeHint = new class_2382(16, 10, 16);
            SpawnRule rule = new SpawnRule(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), 32, 8, 0, 255, 20, 32);
            return new StructureBlueprint(id, variants, connectors, sizeHint, BlendProfile.platformDefault(), rule);
        }
    }
}

