/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.shiroha233.roadweaver.client.map.data.MapSnapshotCache;
import net.shiroha233.roadweaver.client.neoforge.ConfigScreenFactoryImpl;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.datagen.RoadWeaverDataGenerator;
import net.shiroha233.roadweaver.features.neoforge.RoadFeaturesForge;
import net.shiroha233.roadweaver.network.neoforge.MapNetworkForge;
import net.shiroha233.roadweaver.planning.neoforge.ServerPlanningHooks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="roadweaver")
public class RoadWeaver {
    public static final String MOD_ID = "roadweaver";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");

    public RoadWeaver(IEventBus modEventBus) {
        LOGGER.info("Initializing RoadWeaver (NeoForge)...");
        ConfigService.load();
        modEventBus.addListener(RoadWeaverDataGenerator::gatherData);
        RoadFeaturesForge.register(modEventBus);
        MapNetworkForge.register(modEventBus);
        ServerPlanningHooks.register(modEventBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (mc, screen) -> ConfigScreenFactoryImpl.createConfigScreen(screen));
            NeoForge.EVENT_BUS.addListener(RoadWeaver::onClientLoggingIn);
            NeoForge.EVENT_BUS.addListener(RoadWeaver::onClientLoggingOut);
        }
    }

    private static void onClientLoggingIn(ClientPlayerNetworkEvent.LoggingIn e) {
        MapSnapshotCache.clearNow();
    }

    private static void onClientLoggingOut(ClientPlayerNetworkEvent.LoggingOut e) {
        MapSnapshotCache.clearNow();
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

