/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.shiroha233.roadweaver.client.map.MapState;
import net.shiroha233.roadweaver.client.map.MapView;
import net.shiroha233.roadweaver.client.map.data.MapSnapshot;

public final class MapInputHandler {
    private final MapState state;
    private final MapView view;
    private final Callbacks callbacks;
    private int mapX;
    private int mapY;
    private int mapW;
    private int mapH;
    private int innerPad;

    public MapInputHandler(MapState state, MapView view, Callbacks callbacks) {
        this.state = state;
        this.view = view;
        this.callbacks = callbacks;
    }

    public void updateLayout(int mapX, int mapY, int mapW, int mapH, int innerPad) {
        this.mapX = mapX;
        this.mapY = mapY;
        this.mapW = mapW;
        this.mapH = mapH;
        this.innerPad = innerPad;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (!this.insideMap(mouseX, mouseY)) {
            return false;
        }
        int contentW = this.mapW - this.innerPad * 2;
        int contentH = this.mapH - this.innerPad * 2;
        double factor = delta > 0.0 ? 0.9 : 1.1;
        double cx = this.view.screenToWorldX(mouseX, this.mapX, this.innerPad, contentW);
        double cz = this.view.screenToWorldZ(mouseY, this.mapY, this.innerPad, contentH);
        this.view.applyZoomAround(cx, cz, factor, contentW, contentH, 32);
        this.state.scheduleZoomDebounce(500L);
        this.state.closeContextMenu();
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button, MapSnapshot snapshot, int configBtnX, int configBtnY, int configBtnW, int configBtnH, int manualBtnX, int manualBtnY, int manualBtnW, int manualBtnH) {
        BlockPos best;
        if (button == 0 && this.insideRect(mouseX, mouseY, configBtnX, configBtnY, configBtnW, configBtnH)) {
            this.callbacks.onOpenConfig();
            return true;
        }
        if (button == 0 && this.insideRect(mouseX, mouseY, manualBtnX, manualBtnY, manualBtnW, manualBtnH)) {
            this.state.toggleManualMode();
            return true;
        }
        if (this.state.isContextMenuOpen()) {
            this.state.closeContextMenu();
        }
        if (this.state.isManualMode() && this.insideMap(mouseX, mouseY) && button == 0 && (best = this.findNearestStructure(snapshot, mouseX, mouseY)) != null) {
            if (!this.state.hasSelection()) {
                this.state.selectFirstPoint(best);
            } else if (this.state.getSelectedA().equals((Object)best)) {
                this.state.clearSelection();
            } else {
                this.callbacks.onManualConnect(this.state.getSelectedA(), best);
                this.state.clearSelection();
                this.callbacks.onRequestView();
            }
            this.state.closeContextMenu();
            return true;
        }
        if (this.insideMap(mouseX, mouseY) && button == 0) {
            this.state.startDrag(button, mouseX, mouseY);
            return true;
        }
        if (this.insideMap(mouseX, mouseY) && button == 1 && (best = this.findNearestStructure(snapshot, mouseX, mouseY)) != null) {
            this.state.openContextMenu((int)mouseX, (int)mouseY, best);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.state.isDragging() || button != this.state.getDragButton()) {
            return false;
        }
        int contentW = this.mapW - this.innerPad * 2;
        int contentH = this.mapH - this.innerPad * 2;
        double dx = mouseX - this.state.getLastMouseX();
        double dy = mouseY - this.state.getLastMouseY();
        this.view.panByScreenDelta(dx, dy, contentW, contentH);
        this.state.updateDrag(mouseX, mouseY);
        this.view.lockAspect(contentW, contentH);
        this.state.closeContextMenu();
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.state.isDragging() || button != this.state.getDragButton()) {
            return false;
        }
        this.state.endDrag();
        int contentW = this.mapW - this.innerPad * 2;
        int contentH = this.mapH - this.innerPad * 2;
        this.view.clampZoom(contentW, contentH, 32);
        this.state.cancelZoomDebounce();
        this.callbacks.onRequestView();
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers, Minecraft mc) {
        if (mc != null) {
            for (KeyMapping mapping : mc.options.keyMappings) {
                if (!"key.roadweaver.open_map".equals(mapping.getName()) || !mapping.matches(keyCode, scanCode)) continue;
                while (mapping.consumeClick()) {
                }
                this.callbacks.onCloseScreen();
                return true;
            }
        }
        int contentW = this.mapW - this.innerPad * 2;
        int contentH = this.mapH - this.innerPad * 2;
        double panStep = 50.0;
        switch (keyCode) {
            case 87: 
            case 265: {
                this.view.panByScreenDelta(0.0, panStep, contentW, contentH);
                this.callbacks.onRequestView();
                return true;
            }
            case 83: 
            case 264: {
                this.view.panByScreenDelta(0.0, -panStep, contentW, contentH);
                this.callbacks.onRequestView();
                return true;
            }
            case 65: 
            case 263: {
                this.view.panByScreenDelta(panStep, 0.0, contentW, contentH);
                this.callbacks.onRequestView();
                return true;
            }
            case 68: 
            case 262: {
                this.view.panByScreenDelta(-panStep, 0.0, contentW, contentH);
                this.callbacks.onRequestView();
                return true;
            }
            case 61: 
            case 334: {
                double cx = (this.view.getMinX() + this.view.getMaxX()) / 2.0;
                double cz = (this.view.getMinZ() + this.view.getMaxZ()) / 2.0;
                this.view.applyZoomAround(cx, cz, 0.8, contentW, contentH, 32);
                this.callbacks.onRequestView();
                return true;
            }
            case 45: 
            case 333: {
                double cx = (this.view.getMinX() + this.view.getMaxX()) / 2.0;
                double cz = (this.view.getMinZ() + this.view.getMaxZ()) / 2.0;
                this.view.applyZoomAround(cx, cz, 1.25, contentW, contentH, 32);
                this.callbacks.onRequestView();
                return true;
            }
            case 268: {
                this.callbacks.onCenterToPlayer();
                return true;
            }
            case 269: {
                this.callbacks.onCenterToSpawn();
                return true;
            }
            case 256: {
                if (this.state.isContextMenuOpen()) {
                    this.state.closeContextMenu();
                    return true;
                }
                if (!this.state.isManualMode()) break;
                this.state.setManualMode(false);
                return true;
            }
        }
        return false;
    }

    public boolean insideMap(double x, double y) {
        return x >= (double)(this.mapX + this.innerPad) && x <= (double)(this.mapX + this.mapW - this.innerPad) && y >= (double)(this.mapY + this.innerPad) && y <= (double)(this.mapY + this.mapH - this.innerPad);
    }

    private boolean insideRect(double x, double y, int rx, int ry, int rw, int rh) {
        return x >= (double)rx && x <= (double)(rx + rw) && y >= (double)ry && y <= (double)(ry + rh);
    }

    public BlockPos findNearestStructure(MapSnapshot snapshot, double mouseX, double mouseY) {
        if (snapshot == null) {
            return null;
        }
        int contentW = this.mapW - this.innerPad * 2;
        int contentH = this.mapH - this.innerPad * 2;
        int bestDist = Integer.MAX_VALUE;
        BlockPos best = null;
        List<BlockPos> structures = snapshot.structures();
        for (BlockPos p : structures) {
            int dy;
            if (!this.view.isInViewWorld(p.getX(), p.getZ())) continue;
            int x = this.view.toScreenX(p.getX(), this.mapX, this.innerPad, contentW);
            int y = this.view.toScreenY(p.getZ(), this.mapY, this.innerPad, contentH);
            int dx = (int)Math.abs((double)x - mouseX);
            int d2 = dx * dx + (dy = (int)Math.abs((double)y - mouseY)) * dy;
            if (d2 >= bestDist) continue;
            bestDist = d2;
            best = p;
        }
        if (best != null && bestDist <= 64) {
            return best;
        }
        return null;
    }

    public static interface Callbacks {
        public void onCloseScreen();

        public void onOpenConfig();

        public void onRequestView();

        public void onTeleportTo(BlockPos var1);

        public void onManualConnect(BlockPos var1, BlockPos var2);

        public void onCenterToPlayer();

        public void onCenterToSpawn();
    }
}

