/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map;

import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.shiroha233.roadweaver.client.ConfigScreenFactory;
import net.shiroha233.roadweaver.client.map.MapInputHandler;
import net.shiroha233.roadweaver.client.map.MapState;
import net.shiroha233.roadweaver.client.map.MapView;
import net.shiroha233.roadweaver.client.map.data.ClientMapNotes;
import net.shiroha233.roadweaver.client.map.data.MapDataCollector;
import net.shiroha233.roadweaver.client.map.data.MapSnapshot;
import net.shiroha233.roadweaver.client.map.data.MapSnapshotCache;
import net.shiroha233.roadweaver.client.map.interaction.MapInteraction;
import net.shiroha233.roadweaver.client.map.render.GridRenderer;
import net.shiroha233.roadweaver.client.map.render.MapRenderers;
import net.shiroha233.roadweaver.client.map.render.RenderUtils;
import net.shiroha233.roadweaver.client.map.ui.ContextMenu;
import net.shiroha233.roadweaver.client.map.ui.NoteEditScreen;
import net.shiroha233.roadweaver.client.map.ui.SimpleTextInputScreen;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.network.ClientNetBridge;
import net.shiroha233.roadweaver.util.ComputeService;

public class RoadMapScreen
extends Screen
implements MapInputHandler.Callbacks {
    private static final ResourceLocation MAP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)"textures/gui/map.png");
    private static final Component BTN_CONFIG = Component.translatable((String)"gui.roadweaver.config_button");
    private static final Component BTN_MANUAL = Component.translatable((String)"gui.roadweaver.map.manual_connect");
    private static final Component MENU_TELEPORT = Component.translatable((String)"gui.roadweaver.map.menu.teleport");
    private static final Component MENU_SET_ALIAS = Component.translatable((String)"gui.roadweaver.map.menu.set_alias");
    private static final Component MENU_EDIT_NOTE = Component.translatable((String)"gui.roadweaver.map.menu.edit_note");
    private static final Component DIALOG_ALIAS_TITLE = Component.translatable((String)"gui.roadweaver.map.dialog.alias_title");
    private MapSnapshot snapshot = MapSnapshot.empty();
    private final MapState state = new MapState();
    private final MapView view = new MapView();
    private final MapInputHandler inputHandler;
    private final ContextMenu contextMenu = new ContextMenu();
    private int mapX;
    private int mapY;
    private int mapW;
    private int mapH;

    public RoadMapScreen() {
        super((Component)Component.translatable((String)"gui.roadweaver.map.title"));
        this.inputHandler = new MapInputHandler(this.state, this.view, this);
    }

    protected void init() {
        super.init();
        MapSnapshotCache.cancelClear();
        MapSnapshot cached = MapSnapshotCache.peek();
        if (cached != null) {
            this.snapshot = cached;
        }
        this.computeMapRect();
        this.inputHandler.updateLayout(this.mapX, this.mapY, this.mapW, this.mapH, 25);
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.resetFromSnapshot(this.snapshot);
        Minecraft mc = this.minecraft;
        if (mc != null && mc.player != null) {
            this.view.calibrateInitialToPlayer(mc, contentW, contentH, 32);
        }
        this.onRequestView();
    }

    public void removed() {
        super.removed();
        MapSnapshotCache.scheduleClear(1000L);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.fill(0, 0, this.width, this.height, -1879048192);
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        boolean hasDetailedRoads;
        this.renderBackground(g, mouseX, mouseY, partialTick);
        g.blit(MAP_TEXTURE, this.mapX, this.mapY, this.mapW, this.mapH, 0.0f, 0.0f, 1536, 1024, 1536, 1024);
        int titleY = this.mapY - 8;
        g.drawCenteredString(this.font, this.getTitle(), this.width / 2, Math.max(6, titleY), -10601186);
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.lockAspect(contentW, contentH);
        int left = this.mapX + 25;
        int top = this.mapY + 25;
        int right = this.mapX + this.mapW - 25;
        int bottom = this.mapY + this.mapH - 25;
        g.enableScissor(left, top, right, bottom);
        MapRenderers.renderGrid(g, this.font, this.mapX, this.mapY, this.mapW, this.mapH, 25, this.view.getMinX(), this.view.getMaxX(), this.view.getMinZ(), this.view.getMaxZ(), 0x30999999, 32, -10601186);
        int thickness = this.computeThickness();
        ArrayList<Records.StructureConnection> connForLines = new ArrayList<Records.StructureConnection>(this.snapshot.connections());
        boolean bl = hasDetailedRoads = !this.snapshot.roadPolylines().isEmpty();
        if (hasDetailedRoads) {
            connForLines.removeIf(c -> c.status() == Records.ConnectionStatus.COMPLETED);
        }
        MapRenderers.renderConnections(g, connForLines, (x1, z1, x2, z2) -> this.view.segmentInViewWorld(x1, z1, x2, z2), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), thickness, -11751600, -16777216, -16777216, -522167472, left, top, right, bottom);
        int lodStep = GridRenderer.computeGridStep(this.mapX, this.mapY, this.mapW, this.mapH, 25, this.view.getMinX(), this.view.getMaxX(), this.view.getMinZ(), this.view.getMaxZ(), 32);
        MapRenderers.renderRoadPolylines(g, this.snapshot.roadPolylines(), (x1, z1, x2, z2) -> this.view.segmentInViewWorld(x1, z1, x2, z2), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), thickness, -16777216, left, top, right, bottom, lodStep);
        MapRenderers.renderStructures(g, this.snapshot.structures(), v -> this.view.toScreenX(v, this.mapX, 25, contentW), v -> this.view.toScreenY(v, this.mapY, 25, contentH), (x, z) -> this.view.isInViewWorld((int)x, (int)z), this.computePointSize(), -10601186, left, top, right, bottom);
        this.renderManualModePreview(g, mouseX, mouseY, contentW, contentH, left, top, right, bottom);
        if (!this.contextMenu.isOpen()) {
            MapInteraction.renderHoverHighlight(g, this.snapshot, this.view, this.mapX, this.mapY, this.mapW, this.mapH, 25, mouseX, mouseY);
        }
        this.renderPlayer(g, contentW, contentH, left, top, right, bottom);
        g.disableScissor();
        int legendRight = this.mapX + this.mapW - 25;
        int legendStartY = this.mapY + 25 + 8;
        MapRenderers.renderLegend(g, this.font, legendRight, legendStartY, 8, -10601186, -10601186, -11751600, -16777216, -16777216, -522167472, this.snapshot.structuresCount(), this.snapshot.plannedCount(), this.snapshot.generatingCount(), this.snapshot.completedCount(), this.snapshot.failedCount());
        this.renderToolbarButtons(g, mouseX, mouseY);
        if (!this.contextMenu.isOpen()) {
            MapInteraction.renderHoverTooltip(g, this.font, this.snapshot, this.view, this.mapX, this.mapY, this.mapW, this.mapH, 25, mouseX, mouseY);
        }
        if (this.state.isZoomDebounceReady()) {
            this.state.clearZoomDebounce();
            this.onRequestView();
        }
        this.contextMenu.render(g, this.font, mouseX, mouseY, this.width, this.height);
    }

    private void renderManualModePreview(GuiGraphics g, int mouseX, int mouseY, int contentW, int contentH, int left, int top, int right, int bottom) {
        if (!this.state.isManualMode() || !this.state.hasSelection()) {
            return;
        }
        BlockPos selectedA = this.state.getSelectedA();
        if (!this.view.isInViewWorld(selectedA.getX(), selectedA.getZ())) {
            return;
        }
        int sxA = this.view.toScreenX(selectedA.getX(), this.mapX, 25, contentW);
        int syA = this.view.toScreenY(selectedA.getZ(), this.mapY, 25, contentH);
        int selSize = this.computePointSize() * 2 + 4;
        RenderUtils.drawPoint(g, sxA, syA, selSize, -50384, left, top, right, bottom);
        if (this.inputHandler.insideMap(mouseX, mouseY)) {
            int syB;
            int sxB;
            BlockPos hover = this.inputHandler.findNearestStructure(this.snapshot, mouseX, mouseY);
            if (hover != null && this.view.isInViewWorld(hover.getX(), hover.getZ())) {
                sxB = this.view.toScreenX(hover.getX(), this.mapX, 25, contentW);
                syB = this.view.toScreenY(hover.getZ(), this.mapY, 25, contentH);
            } else {
                sxB = mouseX;
                syB = mouseY;
            }
            RenderUtils.drawThickDashedLine(g, sxA, syA, sxB, syB, -855688400, this.computeThickness(), 8, 6, left, top, right, bottom);
        }
    }

    private void renderPlayer(GuiGraphics g, int contentW, int contentH, int left, int top, int right, int bottom) {
        int sy;
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        double wx = this.minecraft.player.getX();
        double wz = this.minecraft.player.getZ();
        int sx = this.view.toScreenX((int)Math.round(wx), this.mapX, 25, contentW);
        if (!this.inputHandler.insideMap(sx, sy = this.view.toScreenY((int)Math.round(wz), this.mapY, 25, contentH))) {
            return;
        }
        float yaw = this.minecraft.player.getYRot();
        MapRenderers.drawPlayerArrow(g, sx, sy, yaw, 10, 6, 4, -16777216, left, top, right, bottom, this.view.pxPerBlockX(contentW), this.view.pxPerBlockZ(contentH));
    }

    private void renderToolbarButtons(GuiGraphics g, int mouseX, int mouseY) {
        int[] configBtn = this.computeConfigBtnBounds();
        this.renderTextButton(g, BTN_CONFIG, configBtn, mouseX, mouseY);
        int[] manualBtn = this.computeManualBtnBounds();
        MutableComponent manualLabel = Component.empty().append(BTN_MANUAL).append(": ").append((Component)(this.state.isManualMode() ? Component.translatable((String)"gui.roadweaver.common.on") : Component.translatable((String)"gui.roadweaver.common.off")));
        this.renderTextButton(g, (Component)manualLabel, manualBtn, mouseX, mouseY);
    }

    private void renderTextButton(GuiGraphics g, Component label, int[] bounds, int mouseX, int mouseY) {
        int x = bounds[0];
        int y = bounds[1];
        int w = bounds[2];
        int h = bounds[3];
        Objects.requireNonNull(this.font);
        int ty = y + (h - 9) / 2;
        g.drawString(this.font, label, x + 3, ty, -10601186, false);
        if (this.insideRect(mouseX, mouseY, x, y, w, h)) {
            int textW = this.font.width((FormattedText)label);
            Objects.requireNonNull(this.font);
            int uy = ty + 9 + 1;
            int underline = 1616788766;
            g.fill(x + 2, uy, x + 2 + textW + 2, uy + 1, underline);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.inputHandler.mouseScrolled(mouseX, mouseY, deltaY) || super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        BlockPos target;
        if (this.contextMenu.isOpen() && this.contextMenu.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            int[] configBtn = this.computeConfigBtnBounds();
            if (this.insideRect(mouseX, mouseY, configBtn)) {
                this.onOpenConfig();
                return true;
            }
            int[] manualBtn = this.computeManualBtnBounds();
            if (this.insideRect(mouseX, mouseY, manualBtn)) {
                this.state.toggleManualMode();
                return true;
            }
        }
        if (button == 1 && this.inputHandler.insideMap(mouseX, mouseY) && (target = this.inputHandler.findNearestStructure(this.snapshot, mouseX, mouseY)) != null) {
            this.openContextMenuFor(target, (int)mouseX, (int)mouseY);
            return true;
        }
        return this.inputHandler.mouseClicked(mouseX, mouseY, button, this.snapshot, this.computeConfigBtnBounds()[0], this.computeConfigBtnBounds()[1], this.computeConfigBtnBounds()[2], this.computeConfigBtnBounds()[3], this.computeManualBtnBounds()[0], this.computeManualBtnBounds()[1], this.computeManualBtnBounds()[2], this.computeManualBtnBounds()[3]) || super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.inputHandler.mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.inputHandler.mouseReleased(mouseX, mouseY, button) || super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.inputHandler.keyPressed(keyCode, scanCode, modifiers, this.minecraft) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void onCloseScreen() {
        this.onClose();
    }

    @Override
    public void onOpenConfig() {
        if (this.minecraft == null) {
            return;
        }
        try {
            Screen next = ConfigScreenFactory.createConfigScreen(this);
            if (next != null) {
                this.minecraft.setScreen(next);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void onRequestView() {
        int minX = (int)Math.floor(Math.min(this.view.getMinX(), this.view.getMaxX())) - 32;
        int maxX = (int)Math.ceil(Math.max(this.view.getMinX(), this.view.getMaxX())) + 32;
        int minZ = (int)Math.floor(Math.min(this.view.getMinZ(), this.view.getMaxZ())) - 32;
        int maxZ = (int)Math.ceil(Math.max(this.view.getMinZ(), this.view.getMaxZ())) + 32;
        Minecraft mc = this.minecraft;
        if (mc == null) {
            return;
        }
        IntegratedServer server = mc.getSingleplayerServer();
        if (server != null) {
            ServerLevel level = server.getLevel(Level.OVERWORLD);
            if (level != null) {
                int cx = 0;
                int cz = 0;
                if (mc.player != null) {
                    cx = (int)Math.round(mc.player.getX());
                    cz = (int)Math.round(mc.player.getZ());
                }
                int radiusBlocks = this.getRadiusBlocks();
                int fcx = cx;
                int fcz = cz;
                int fMinX = minX;
                int fMaxX = maxX;
                int fMinZ = minZ;
                int fMaxZ = maxZ;
                int currentSeq = this.state.incrementAndGetRequestSeq();
                CompletableFuture.supplyAsync(() -> MapDataCollector.build(level, fMinX, fMinZ, fMaxX, fMaxZ, fcx, fcz, radiusBlocks), ComputeService.executor()).thenAccept(snap -> mc.execute(() -> {
                    if (this.state.getCurrentRequestSeq() == currentSeq) {
                        this.setSnapshot((MapSnapshot)snap);
                    }
                }));
            }
        } else {
            this.state.incrementAndGetRequestSeq();
            ClientNetBridge.requestSnapshot(minX, minZ, maxX, maxZ);
        }
    }

    @Override
    public void onTeleportTo(BlockPos pos) {
        ClientNetBridge.requestTeleport(pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public void onManualConnect(BlockPos a, BlockPos b) {
        ClientNetBridge.requestManualConnect(a.getX(), a.getZ(), b.getX(), b.getZ());
    }

    @Override
    public void onCenterToPlayer() {
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.calibrateInitialToPlayer(this.minecraft, contentW, contentH, 32);
        this.onRequestView();
    }

    @Override
    public void onCenterToSpawn() {
        ServerLevel level;
        Minecraft mc = this.minecraft;
        if (mc == null) {
            return;
        }
        BlockPos spawn = null;
        IntegratedServer server = mc.getSingleplayerServer();
        if (server != null && (level = server.getLevel(Level.OVERWORLD)) != null) {
            spawn = level.getSharedSpawnPos();
        }
        if (spawn == null && mc.level != null) {
            spawn = mc.level.getSharedSpawnPos();
        }
        if (spawn == null) {
            return;
        }
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        this.view.centerOn(spawn.getX(), spawn.getZ(), contentW, contentH);
        this.onRequestView();
    }

    public void setSnapshot(MapSnapshot snapshot) {
        if (snapshot != null) {
            this.snapshot = snapshot;
            MapSnapshotCache.put(snapshot);
        }
    }

    private void computeMapRect() {
        int availW = this.width - 72;
        int availH = this.height - 72;
        int w = availW;
        float ratio = 1.5f;
        int h = Math.round((float)w / ratio);
        if (h > availH) {
            h = availH;
            w = Math.round((float)h * ratio);
        }
        this.mapW = w;
        this.mapH = h;
        this.mapX = (this.width - w) / 2;
        this.mapY = (this.height - h) / 2;
    }

    private int computeThickness() {
        int contentW = this.mapW - 50;
        int contentH = this.mapH - 50;
        double ppb = Math.min(this.view.pxPerBlockX(contentW), this.view.pxPerBlockZ(contentH));
        int t = (int)Math.round(ppb);
        return Math.max(1, Math.min(t, 4));
    }

    private int computePointSize() {
        return 2 + this.computeThickness();
    }

    private int getRadiusBlocks() {
        try {
            ModConfig cfg = ConfigService.get();
            int radiusChunks = cfg.dynamicPlanEnabled() ? cfg.dynamicPlanRadiusChunks() : cfg.initialPlanRadiusChunks();
            return Math.max(1, radiusChunks) * 16;
        }
        catch (Throwable t) {
            return 4096;
        }
    }

    private void openContextMenuFor(BlockPos target, int x, int y) {
        this.contextMenu.clearItems();
        this.contextMenu.addItem(MENU_TELEPORT, () -> this.onTeleportTo(target));
        this.contextMenu.addSeparator();
        this.contextMenu.addItem(MENU_SET_ALIAS, () -> this.openAliasDialog(target));
        this.contextMenu.addItem(MENU_EDIT_NOTE, () -> this.openNoteEditor(target));
        this.contextMenu.open(x, y);
    }

    private void openAliasDialog(BlockPos target) {
        if (this.minecraft == null) {
            return;
        }
        String currentAlias = ClientMapNotes.getAlias(target);
        this.minecraft.setScreen((Screen)new SimpleTextInputScreen(DIALOG_ALIAS_TITLE, currentAlias != null ? currentAlias : "", alias -> ClientMapNotes.setAlias(target, alias), this));
    }

    private void openNoteEditor(BlockPos target) {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.setScreen((Screen)new NoteEditScreen(target, this));
    }

    private int[] computeConfigBtnBounds() {
        int x = this.mapX + 25 + 4;
        int y = this.mapY + 25 + 4;
        int w = this.font.width((FormattedText)BTN_CONFIG) + 6;
        Objects.requireNonNull(this.font);
        int h = 9 + 4;
        return new int[]{x, y, w, h};
    }

    private int[] computeManualBtnBounds() {
        MutableComponent lbl = Component.empty().append(BTN_MANUAL).append(": ").append((Component)Component.translatable((String)"gui.roadweaver.common.on"));
        int w = this.font.width((FormattedText)lbl) + 6;
        Objects.requireNonNull(this.font);
        int h = 9 + 4;
        int x = this.mapX + 25 + 4;
        int y = this.mapY + this.mapH - 25 - 4 - h;
        return new int[]{x, y, w, h};
    }

    private boolean insideRect(double x, double y, int[] bounds) {
        return x >= (double)bounds[0] && x <= (double)(bounds[0] + bounds[2]) && y >= (double)bounds[1] && y <= (double)(bounds[1] + bounds[3]);
    }

    private boolean insideRect(double x, double y, int rx, int ry, int rw, int rh) {
        return x >= (double)rx && x <= (double)(rx + rw) && y >= (double)ry && y <= (double)(ry + rh);
    }
}

