/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.shiroha233.roadweaver.client.map.data.MapDataStorage;
import org.jetbrains.annotations.Nullable;

public final class ClientMapNotes {
    private static String currentWorldId = null;
    private static final Map<BlockPos, String> aliases = new HashMap<BlockPos, String>();
    private static final Map<BlockPos, List<String>> notes = new HashMap<BlockPos, List<String>>();
    private static boolean dirty = false;

    private ClientMapNotes() {
    }

    public static void onWorldJoin() {
        BlockPos pos;
        String worldId = MapDataStorage.getWorldId();
        if (worldId == null) {
            return;
        }
        if (worldId.equals(currentWorldId)) {
            return;
        }
        if (currentWorldId != null && dirty) {
            ClientMapNotes.saveToFile();
        }
        currentWorldId = worldId;
        aliases.clear();
        notes.clear();
        dirty = false;
        MapDataStorage.NotesData data = MapDataStorage.loadNotes();
        for (Map.Entry<String, String> entry : data.aliases.entrySet()) {
            pos = MapDataStorage.keyToPos(entry.getKey());
            if (pos == null) continue;
            aliases.put(pos, entry.getValue());
        }
        for (Map.Entry<String, Object> entry : data.notes.entrySet()) {
            pos = MapDataStorage.keyToPos(entry.getKey());
            if (pos == null) continue;
            notes.put(pos, new ArrayList((Collection)entry.getValue()));
        }
    }

    public static void onWorldLeave() {
        if (dirty) {
            ClientMapNotes.saveToFile();
        }
        currentWorldId = null;
        aliases.clear();
        notes.clear();
        dirty = false;
    }

    public static void saveToFile() {
        MapDataStorage.NotesData data = new MapDataStorage.NotesData();
        for (Map.Entry<BlockPos, String> entry : aliases.entrySet()) {
            data.aliases.put(MapDataStorage.posToKey(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<BlockPos, Object> entry : notes.entrySet()) {
            data.notes.put(MapDataStorage.posToKey(entry.getKey()), (List)entry.getValue());
        }
        MapDataStorage.saveNotes(data);
        dirty = false;
    }

    @Nullable
    public static String getAlias(BlockPos pos) {
        return aliases.get(pos);
    }

    public static void setAlias(BlockPos pos, String alias) {
        if (alias == null || alias.isBlank()) {
            if (aliases.remove(pos) != null) {
                dirty = true;
                ClientMapNotes.saveToFile();
            }
        } else {
            aliases.put(pos, alias);
            dirty = true;
            ClientMapNotes.saveToFile();
        }
    }

    public static boolean hasAlias(BlockPos pos) {
        return aliases.containsKey(pos);
    }

    public static List<String> getNotes(BlockPos pos) {
        return notes.getOrDefault(pos, List.of());
    }

    public static void addNote(BlockPos pos, String note) {
        if (note == null || note.isBlank()) {
            return;
        }
        notes.computeIfAbsent(pos, k -> new ArrayList()).add(note);
        dirty = true;
        ClientMapNotes.saveToFile();
    }

    public static void clearNotes(BlockPos pos) {
        if (notes.remove(pos) != null) {
            dirty = true;
            ClientMapNotes.saveToFile();
        }
    }

    public static void setNotes(BlockPos pos, List<String> noteList) {
        if (noteList == null || noteList.isEmpty()) {
            if (notes.remove(pos) != null) {
                dirty = true;
                ClientMapNotes.saveToFile();
            }
        } else {
            notes.put(pos, new ArrayList<String>(noteList));
            dirty = true;
            ClientMapNotes.saveToFile();
        }
    }

    public static boolean hasNotes(BlockPos pos) {
        List<String> n = notes.get(pos);
        return n != null && !n.isEmpty();
    }
}

