/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.shiroha233.roadweaver.client.map.data.MapSnapshot;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;
import net.shiroha233.roadweaver.planning.RoadPlanningService;
import net.shiroha233.roadweaver.search.StructureIndexService;

public final class MapDataCollector {
    private static final int MAX_DETAILED_ROAD_SPAN_BLOCKS = 7680;

    private MapDataCollector() {
    }

    public static MapSnapshot build(ServerLevel level) {
        List<Records.StructureInfo> verified;
        WorldDataProvider provider = WorldDataProvider.getInstance();
        Records.StructureLocationData loc = provider.getStructureLocations(level);
        List<Records.StructureConnection> connections = provider.getStructureConnections(level);
        ArrayList<BlockPos> structures = loc != null ? new ArrayList<BlockPos>(loc.structureLocations()) : new ArrayList();
        ArrayList<Records.StructureConnection> conns = connections != null ? new ArrayList<Records.StructureConnection>(connections) : new ArrayList();
        ArrayList<Records.StructureInfo> infos = loc != null ? new ArrayList<Records.StructureInfo>(loc.structureInfos()) : new ArrayList();
        ArrayList<List<BlockPos>> roads = new ArrayList<List<BlockPos>>();
        ModConfig cfg = ConfigService.get();
        BlockPos spawn = level.getSharedSpawnPos();
        int radiusChunks = Math.max(1, cfg.initialPlanRadiusChunks());
        int minX = ((spawn.getX() >> 4) - radiusChunks) * 16;
        int maxX = ((spawn.getX() >> 4) + radiusChunks) * 16;
        int minZ = ((spawn.getZ() >> 4) - radiusChunks) * 16;
        int maxZ = ((spawn.getZ() >> 4) + radiusChunks) * 16;
        List<Records.RoadData> roadDataList = RoadShardStorage.queryRect(level, minX, minZ, maxX, maxZ);
        for (Records.RoadData rd : roadDataList) {
            List<Records.RoadSegmentPlacement> segs = rd.roadSegmentList();
            if (segs == null || segs.isEmpty()) continue;
            ArrayList<BlockPos> poly = new ArrayList<BlockPos>(segs.size());
            for (Records.RoadSegmentPlacement sp : segs) {
                poly.add(sp.middlePos());
            }
            if (poly.size() < 2) continue;
            roads.add(poly);
        }
        if (Level.OVERWORLD.equals(level.dimension()) && !(verified = StructureIndexService.predictAndVerifyAroundSpawn(level)).isEmpty()) {
            HashSet<BlockPos> existing = new HashSet<BlockPos>(structures);
            for (Records.StructureInfo info : verified) {
                BlockPos p = info.pos();
                if (existing.contains(p)) continue;
                structures.add(p);
                infos.add(info);
                existing.add(p);
            }
        }
        return new MapSnapshot(structures, conns, infos, roads);
    }

    public static MapSnapshot build(ServerLevel level, int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        List<Records.StructureInfo> verified;
        WorldDataProvider provider = WorldDataProvider.getInstance();
        Records.StructureLocationData loc = provider.getStructureLocations(level);
        List<Records.StructureConnection> connections = provider.getStructureConnections(level);
        ArrayList<BlockPos> structures = new ArrayList<BlockPos>();
        if (loc != null && loc.structureLocations() != null) {
            for (BlockPos p : loc.structureLocations()) {
                int x = p.getX();
                int z = p.getZ();
                if (x < minBlockX || x > maxBlockX || z < minBlockZ || z > maxBlockZ) continue;
                structures.add(p);
            }
        }
        ArrayList<Records.StructureConnection> conns = new ArrayList<Records.StructureConnection>();
        if (connections != null) {
            for (Records.StructureConnection c : connections) {
                boolean inb;
                BlockPos a = c.from();
                BlockPos b = c.to();
                boolean ina = a.getX() >= minBlockX && a.getX() <= maxBlockX && a.getZ() >= minBlockZ && a.getZ() <= maxBlockZ;
                boolean bl = inb = b.getX() >= minBlockX && b.getX() <= maxBlockX && b.getZ() >= minBlockZ && b.getZ() <= maxBlockZ;
                if (!ina && !inb) continue;
                conns.add(c);
            }
        }
        ArrayList<Records.StructureInfo> infos = new ArrayList<Records.StructureInfo>();
        if (loc != null && loc.structureInfos() != null) {
            for (Records.StructureInfo info : loc.structureInfos()) {
                BlockPos p = info.pos();
                int x = p.getX();
                int z = p.getZ();
                if (x < minBlockX || x > maxBlockX || z < minBlockZ || z > maxBlockZ) continue;
                infos.add(info);
            }
        }
        if (Level.OVERWORLD.equals(level.dimension()) && !(verified = StructureIndexService.predictAndVerifyInRect(level, minBlockX, minBlockZ, maxBlockX, maxBlockZ)).isEmpty()) {
            HashSet<BlockPos> existing = new HashSet<BlockPos>(structures);
            for (Records.StructureInfo info : verified) {
                BlockPos p = info.pos();
                if (existing.contains(p)) continue;
                int x = p.getX();
                int z = p.getZ();
                if (x < minBlockX || x > maxBlockX || z < minBlockZ || z > maxBlockZ) continue;
                structures.add(p);
                infos.add(info);
                existing.add(p);
            }
        }
        ArrayList<List<BlockPos>> roads = new ArrayList<List<BlockPos>>();
        List<Records.RoadData> roadDataList = RoadShardStorage.queryRect(level, minBlockX, minBlockZ, maxBlockX, maxBlockZ);
        for (Records.RoadData rd : roadDataList) {
            List<Records.RoadSegmentPlacement> segs = rd.roadSegmentList();
            if (segs == null || segs.isEmpty()) continue;
            ArrayList<BlockPos> poly = new ArrayList<BlockPos>(segs.size());
            for (Records.RoadSegmentPlacement sp : segs) {
                BlockPos p = sp.middlePos();
                int x = p.getX();
                int z = p.getZ();
                if (x < minBlockX || x > maxBlockX || z < minBlockZ || z > maxBlockZ) continue;
                poly.add(p);
            }
            if (poly.size() < 2) continue;
            roads.add(poly);
        }
        return new MapSnapshot(structures, conns, infos, roads);
    }

    public static MapSnapshot build(ServerLevel level, int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ, int centerX, int centerZ, int radiusBlocks) {
        boolean loadDetailedRoads;
        WorldDataProvider provider = WorldDataProvider.getInstance();
        Records.StructureLocationData loc = provider.getStructureLocations(level);
        List<Records.StructureConnection> connections = provider.getStructureConnections(level);
        long r2 = (long)Math.max(0, radiusBlocks) * (long)Math.max(0, radiusBlocks);
        BiPredicate<Integer, Integer> inAOI = (x, z) -> {
            long dz;
            if (r2 <= 0L) {
                return true;
            }
            long dx = (long)x.intValue() - (long)centerX;
            return dx * dx + (dz = (long)z.intValue() - (long)centerZ) * dz <= r2;
        };
        int spanX = Math.abs(maxBlockX - minBlockX);
        int spanZ = Math.abs(maxBlockZ - minBlockZ);
        HashSet<BlockPos> plannedEndpoints = new HashSet<BlockPos>();
        if (connections != null) {
            for (Records.StructureConnection c : connections) {
                plannedEndpoints.add(c.from());
                plannedEndpoints.add(c.to());
            }
        }
        ModConfig cfgAll = ConfigService.get();
        int initialRadiusBlocks = Math.max(1, cfgAll.initialPlanRadiusChunks()) * 16;
        int strideChunks = RoadPlanningService.getStrideTileSizeChunks();
        int dynRadiusChunks = RoadPlanningService.getDynamicPlanRadiusChunks();
        int dynRadiusBlocks = Math.max(1, dynRadiusChunks) * 16;
        long initialR2 = (long)initialRadiusBlocks * (long)initialRadiusBlocks;
        BlockPos spawn = level.getSharedSpawnPos();
        ArrayList<int[]> plannedRects = new ArrayList<int[]>();
        Map<Long, Long> centersMap = RoadPlanningService.getPlannedTileCenters(level);
        for (Long key : RoadPlanningService.getPlannedTiles(level)) {
            int centerChunkZ;
            int centerChunkX;
            int kx = (int)(key >> 32);
            int kz = (int)(key & 0xFFFFFFFFL);
            Long cval = centersMap.get(key);
            if (cval != null) {
                centerChunkX = (int)(cval >> 32);
                centerChunkZ = (int)(cval & 0xFFFFFFFFL);
            } else {
                centerChunkX = kx * strideChunks + strideChunks / 2;
                centerChunkZ = kz * strideChunks + strideChunks / 2;
            }
            int cxBlocks = centerChunkX * 16;
            int czBlocks = centerChunkZ * 16;
            int minBx = cxBlocks - dynRadiusBlocks;
            int maxBx = cxBlocks + dynRadiusBlocks;
            int minBz = czBlocks - dynRadiusBlocks;
            int maxBz = czBlocks + dynRadiusBlocks;
            plannedRects.add(new int[]{minBx, minBz, maxBx, maxBz});
        }
        BiPredicate<Integer, Integer> inPlannedCoverage = (x, z) -> {
            long dzs;
            long dxs;
            if (Level.OVERWORLD.equals(level.dimension()) && (dxs = (long)x.intValue() - (long)spawn.getX()) * dxs + (dzs = (long)z.intValue() - (long)spawn.getZ()) * dzs <= initialR2) {
                return true;
            }
            for (int[] r : plannedRects) {
                if (x < r[0] || x > r[2] || z < r[1] || z > r[3]) continue;
                return true;
            }
            return false;
        };
        ArrayList<BlockPos> structures = new ArrayList<BlockPos>();
        if (loc != null && loc.structureLocations() != null) {
            for (BlockPos p : loc.structureLocations()) {
                int x2 = p.getX();
                int z2 = p.getZ();
                boolean inRect = x2 >= minBlockX && x2 <= maxBlockX && z2 >= minBlockZ && z2 <= maxBlockZ;
                if (!inRect || !plannedEndpoints.contains(p) && !inPlannedCoverage.test(x2, z2) && !inAOI.test(x2, z2)) continue;
                structures.add(p);
            }
        }
        if (connections != null) {
            HashSet<BlockPos> existing = new HashSet<BlockPos>(structures);
            for (Records.StructureConnection c : connections) {
                BlockPos[] eps;
                for (BlockPos ep : eps = new BlockPos[]{c.from(), c.to()}) {
                    boolean inRect;
                    int x3 = ep.getX();
                    int z3 = ep.getZ();
                    boolean bl = inRect = x3 >= minBlockX && x3 <= maxBlockX && z3 >= minBlockZ && z3 <= maxBlockZ;
                    if (!inRect || existing.contains(ep)) continue;
                    structures.add(ep);
                    existing.add(ep);
                }
            }
        }
        ArrayList<Records.StructureConnection> conns = new ArrayList<Records.StructureConnection>();
        if (connections != null) {
            for (Records.StructureConnection c : connections) {
                boolean inb;
                BlockPos a = c.from();
                BlockPos b = c.to();
                boolean ina = a.getX() >= minBlockX && a.getX() <= maxBlockX && a.getZ() >= minBlockZ && a.getZ() <= maxBlockZ;
                boolean bl = inb = b.getX() >= minBlockX && b.getX() <= maxBlockX && b.getZ() >= minBlockZ && b.getZ() <= maxBlockZ;
                if (!ina && !inb) continue;
                conns.add(c);
            }
        }
        ArrayList<Records.StructureInfo> infos = new ArrayList<Records.StructureInfo>();
        if (loc != null && loc.structureInfos() != null) {
            for (Records.StructureInfo info : loc.structureInfos()) {
                BlockPos p = info.pos();
                int x4 = p.getX();
                int z4 = p.getZ();
                boolean inRect = x4 >= minBlockX && x4 <= maxBlockX && z4 >= minBlockZ && z4 <= maxBlockZ;
                if (!inRect || !plannedEndpoints.contains(p) && !inPlannedCoverage.test(x4, z4) && !inAOI.test(x4, z4)) continue;
                infos.add(info);
            }
        }
        ArrayList<List<BlockPos>> roads = new ArrayList<List<BlockPos>>();
        boolean bl = loadDetailedRoads = spanX <= 7680 && spanZ <= 7680;
        if (loadDetailedRoads) {
            List<Records.RoadData> roadDataList = RoadShardStorage.queryRect(level, minBlockX, minBlockZ, maxBlockX, maxBlockZ);
            for (Records.RoadData rd : roadDataList) {
                List<Records.RoadSegmentPlacement> segs = rd.roadSegmentList();
                if (segs == null || segs.isEmpty()) continue;
                ArrayList<BlockPos> poly = new ArrayList<BlockPos>(segs.size());
                for (Records.RoadSegmentPlacement sp : segs) {
                    BlockPos p = sp.middlePos();
                    int x5 = p.getX();
                    int z5 = p.getZ();
                    if (x5 < minBlockX || x5 > maxBlockX || z5 < minBlockZ || z5 > maxBlockZ) continue;
                    poly.add(p);
                }
                if (poly.size() < 2) continue;
                roads.add(poly);
            }
        }
        return new MapSnapshot(structures, conns, infos, roads);
    }
}

