/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapDataStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RoadWeaver");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String DATA_DIR = "config/roadweaver/mapdata";
    private static final String NOTES_FILE = "notes.json";

    private MapDataStorage() {
    }

    private static Path getDataRoot() {
        return Minecraft.getInstance().gameDirectory.toPath().resolve(DATA_DIR);
    }

    public static Path getWorldDataDir() {
        String worldId = MapDataStorage.getWorldId();
        if (worldId == null) {
            return null;
        }
        String safeName = worldId.replaceAll("[<>:\"/\\\\|?*]", "_");
        return MapDataStorage.getDataRoot().resolve(safeName);
    }

    public static String getWorldId() {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.level == null) {
            return null;
        }
        if (mc.isLocalServer() && mc.getSingleplayerServer() != null) {
            return mc.getSingleplayerServer().getWorldData().getLevelName();
        }
        if (mc.getCurrentServer() != null) {
            return mc.getCurrentServer().ip;
        }
        return null;
    }

    public static NotesData loadNotes() {
        Path dir = MapDataStorage.getWorldDataDir();
        if (dir == null) {
            return new NotesData();
        }
        Path file = dir.resolve(NOTES_FILE);
        if (!Files.exists(file, new LinkOption[0])) {
            return new NotesData();
        }
        try {
            String json = Files.readString(file, StandardCharsets.UTF_8);
            NotesData data = (NotesData)GSON.fromJson(json, NotesData.class);
            LOGGER.debug("[RoadWeaver] \u5df2\u52a0\u8f7d\u5730\u56fe\u7b14\u8bb0: {}", (Object)file);
            return data != null ? data : new NotesData();
        }
        catch (IOException e) {
            LOGGER.error("[RoadWeaver] \u52a0\u8f7d\u5730\u56fe\u7b14\u8bb0\u5931\u8d25: {}", (Object)file, (Object)e);
            return new NotesData();
        }
    }

    public static void saveNotes(NotesData data) {
        Path dir = MapDataStorage.getWorldDataDir();
        if (dir == null) {
            return;
        }
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve(NOTES_FILE);
            String json = GSON.toJson((Object)data);
            Files.writeString(file, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
            LOGGER.debug("[RoadWeaver] \u5df2\u4fdd\u5b58\u5730\u56fe\u7b14\u8bb0: {}", (Object)file);
        }
        catch (IOException e) {
            LOGGER.error("[RoadWeaver] \u4fdd\u5b58\u5730\u56fe\u7b14\u8bb0\u5931\u8d25", (Throwable)e);
        }
    }

    public static String posToKey(BlockPos pos) {
        return pos.getX() + "," + pos.getY() + "," + pos.getZ();
    }

    public static BlockPos keyToPos(String key) {
        String[] parts = key.split(",");
        if (parts.length != 3) {
            return null;
        }
        try {
            return new BlockPos(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static class NotesData {
        public Map<String, String> aliases = new HashMap<String, String>();
        public Map<String, List<String>> notes = new HashMap<String, List<String>>();
    }
}

