/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.interaction;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.shiroha233.roadweaver.client.map.MapView;
import net.shiroha233.roadweaver.client.map.data.ClientMapNotes;
import net.shiroha233.roadweaver.client.map.data.MapSnapshot;

public final class MapInteraction {
    private MapInteraction() {
    }

    public static void renderHoverHighlight(GuiGraphics g, MapSnapshot snapshot, MapView view, int mapX, int mapY, int mapW, int mapH, int innerPad, double mouseX, double mouseY) {
        double mx = mouseX;
        double my = mouseY;
        if (!MapInteraction.insideMap(mx, my, mapX, mapY, mapW, mapH, innerPad)) {
            return;
        }
        int bestDist = Integer.MAX_VALUE;
        BlockPos best = null;
        int contentW = mapW - innerPad * 2;
        int contentH = mapH - innerPad * 2;
        for (BlockPos p : snapshot.structures()) {
            int dy;
            if (!view.isInViewWorld(p.getX(), p.getZ())) continue;
            int x = view.toScreenX(p.getX(), mapX, innerPad, contentW);
            int y = view.toScreenY(p.getZ(), mapY, innerPad, contentH);
            int dx = (int)Math.abs((double)x - mx);
            int d2 = dx * dx + (dy = (int)Math.abs((double)y - my)) * dy;
            if (d2 >= bestDist) continue;
            bestDist = d2;
            best = p;
        }
        if (best != null && bestDist <= 64) {
            int x = view.toScreenX(best.getX(), mapX, innerPad, contentW);
            int y = view.toScreenY(best.getZ(), mapY, innerPad, contentH);
            g.fill(x - 4, y - 4, x + 5, y + 5, -855648945);
        }
    }

    public static void renderHoverTooltip(GuiGraphics g, Font font, MapSnapshot snapshot, MapView view, int mapX, int mapY, int mapW, int mapH, int innerPad, double mouseX, double mouseY) {
        double mx = mouseX;
        double my = mouseY;
        int contentW = mapW - innerPad * 2;
        int contentH = mapH - innerPad * 2;
        if (!MapInteraction.insideMap(mx, my, mapX, mapY, mapW, mapH, innerPad)) {
            int wx = (int)Math.round(view.screenToWorldX(mx, mapX, innerPad, contentW));
            int wz = (int)Math.round(view.screenToWorldZ(my, mapY, innerPad, contentH));
            g.renderTooltip(font, (Component)Component.translatable((String)"gui.roadweaver.map.coord", (Object[])new Object[]{wx, wz}), (int)mx, (int)my);
            return;
        }
        int bestDist = Integer.MAX_VALUE;
        BlockPos best = null;
        for (BlockPos p : snapshot.structures()) {
            int dy;
            if (!view.isInViewWorld(p.getX(), p.getZ())) continue;
            int x = view.toScreenX(p.getX(), mapX, innerPad, contentW);
            int y = view.toScreenY(p.getZ(), mapY, innerPad, contentH);
            int dx = (int)Math.abs((double)x - mx);
            int d2 = dx * dx + (dy = (int)Math.abs((double)y - my)) * dy;
            if (d2 >= bestDist) continue;
            bestDist = d2;
            best = p;
        }
        if (best != null && bestDist <= 64) {
            String name = snapshot.structureName(best);
            String alias = ClientMapNotes.getAlias(best);
            MutableComponent coords = Component.translatable((String)"gui.roadweaver.map.coord", (Object[])new Object[]{best.getX(), best.getZ()});
            MutableComponent label = alias != null ? Component.literal((String)alias).append(" ").append((Component)coords) : (name != null ? Component.literal((String)name).append(" ").append((Component)coords) : coords);
            g.renderTooltip(font, (Component)label, (int)mx, (int)my);
        } else {
            int wx = (int)Math.round(view.screenToWorldX(mx, mapX, innerPad, contentW));
            int wz = (int)Math.round(view.screenToWorldZ(my, mapY, innerPad, contentH));
            g.renderTooltip(font, (Component)Component.translatable((String)"gui.roadweaver.map.coord", (Object[])new Object[]{wx, wz}), (int)mx, (int)my);
        }
    }

    private static boolean insideMap(double x, double y, int mapX, int mapY, int mapW, int mapH, int innerPad) {
        return x >= (double)(mapX + innerPad) && x <= (double)(mapX + mapW - innerPad) && y >= (double)(mapY + innerPad) && y <= (double)(mapY + mapH - innerPad);
    }
}

