/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.shiroha233.roadweaver.client.map.ui.Rect;

public final class ContextMenu {
    public static final int PADDING = 6;
    public static final int ITEM_HEIGHT = 16;
    public static final int SEPARATOR_HEIGHT = 8;
    private int anchorX;
    private int anchorY;
    private Rect bounds;
    private final List<Item> items = new ArrayList<Item>();
    private boolean open = false;
    private int hoverIndex = -1;

    public void open(int x, int y) {
        this.anchorX = x;
        this.anchorY = y;
        this.open = true;
        this.hoverIndex = -1;
    }

    public void close() {
        this.open = false;
        this.hoverIndex = -1;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void clearItems() {
        this.items.clear();
    }

    public void addItem(Component label, Runnable action) {
        this.items.add(Item.of(label, action));
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public void addSeparator() {
        this.items.add(Item.createSeparator());
    }

    public void layout(Font font, int screenW, int screenH) {
        int w = 0;
        int h = 12;
        for (Item it : this.items) {
            if (it.isSeparator()) {
                h += 8;
                continue;
            }
            w = Math.max(w, font.width((FormattedText)it.label()));
            h += 16;
        }
        Rect raw = new Rect(this.anchorX + 4, this.anchorY, w += 24, h);
        this.bounds = raw.clampToScreen(screenW, screenH, 4);
    }

    public void render(GuiGraphics g, Font font, int mouseX, int mouseY, int screenW, int screenH) {
        if (!this.open || this.items.isEmpty()) {
            return;
        }
        this.layout(font, screenW, screenH);
        int x = this.bounds.x();
        int y = this.bounds.y();
        int w = this.bounds.width();
        int h = this.bounds.height();
        g.fill(x + 2, y + 2, x + w + 2, y + h + 2, 0x60000000);
        g.fill(x - 1, y - 1, x + w + 1, y + h + 1, -1);
        g.fill(x, y, x + w, y + h, -267382768);
        this.updateHoverIndex(mouseX, mouseY);
        int ty = y + 6;
        for (int i = 0; i < this.items.size(); ++i) {
            Item it = this.items.get(i);
            if (it.isSeparator()) {
                int lineY = ty + 4;
                g.fill(x + 4, lineY, x + w - 4, lineY + 1, 0x40FFFFFF);
                ty += 8;
                continue;
            }
            if (i == this.hoverIndex && it.enabled()) {
                g.fill(x + 2, ty, x + w - 2, ty + 16, 0x40FFFFFF);
            }
            int textColor = it.enabled() ? -1 : -8355712;
            Component component = it.label();
            Objects.requireNonNull(font);
            g.drawString(font, component, x + 6, ty + (16 - 9) / 2, textColor, false);
            ty += 16;
        }
    }

    private void updateHoverIndex(int mouseX, int mouseY) {
        this.hoverIndex = -1;
        if (this.bounds == null || !this.bounds.contains(mouseX, mouseY)) {
            return;
        }
        int y = this.bounds.y() + 6;
        for (int i = 0; i < this.items.size(); ++i) {
            int itemH;
            Item it = this.items.get(i);
            int n = itemH = it.isSeparator() ? 8 : 16;
            if (mouseY >= y && mouseY < y + itemH) {
                if (!it.isSeparator()) {
                    this.hoverIndex = i;
                }
                return;
            }
            y += itemH;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Item it;
        if (!this.open) {
            return false;
        }
        if (button != 0) {
            this.close();
            return true;
        }
        if (this.bounds == null || !this.bounds.contains(mouseX, mouseY)) {
            this.close();
            return true;
        }
        if (this.hoverIndex >= 0 && this.hoverIndex < this.items.size() && (it = this.items.get(this.hoverIndex)).enabled() && it.action() != null) {
            this.close();
            it.action().run();
            return true;
        }
        this.close();
        return true;
    }

    public void updateMousePos(int mouseX, int mouseY) {
        if (this.open && this.bounds != null) {
            this.updateHoverIndex(mouseX, mouseY);
        }
    }

    public record Item(Component label, Runnable action, boolean enabled, boolean isSeparator) {
        public static Item of(Component label, Runnable action) {
            return new Item(label, action, true, false);
        }

        public static Item disabled(Component label) {
            return new Item(label, null, false, false);
        }

        public static Item createSeparator() {
            return new Item((Component)Component.empty(), null, false, true);
        }
    }
}

