/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.ui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.shiroha233.roadweaver.client.map.data.ClientMapNotes;

public class NoteEditScreen
extends Screen {
    private static final ResourceLocation BOOK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/book.png");
    private static final int BOOK_WIDTH = 192;
    private static final int BOOK_HEIGHT = 192;
    private static final int TEXT_WIDTH = 114;
    private static final int TEXT_X_OFFSET = 36;
    private static final int TEXT_Y_OFFSET = 32;
    private static final int MAX_LINES = 14;
    private static final int LINE_HEIGHT = 9;
    private final BlockPos targetPos;
    private final Screen parent;
    private final List<String> lines = new ArrayList<String>();
    private int cursorLine = 0;
    private int cursorPos = 0;
    private int bookX;
    private int bookY;
    private long lastBlink = 0L;
    private boolean cursorVisible = true;

    public NoteEditScreen(BlockPos targetPos, Screen parent) {
        super((Component)Component.translatable((String)"gui.roadweaver.map.note.title"));
        this.targetPos = targetPos;
        this.parent = parent;
        List<String> existing = ClientMapNotes.getNotes(targetPos);
        if (!existing.isEmpty()) {
            this.lines.addAll(existing);
        } else {
            this.lines.add("");
        }
    }

    protected void init() {
        this.bookX = (this.width - 192) / 2;
        this.bookY = (this.height - 192) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.roadweaver.common.save"), b -> this.save()).bounds(this.bookX + 96 - 50, this.bookY + 192 + 4, 100, 20).build());
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.fill(0, 0, this.width, this.height, -1879048192);
        g.blit(BOOK_TEXTURE, this.bookX, this.bookY, 0, 0, 192, 192);
        String alias = ClientMapNotes.getAlias(this.targetPos);
        String titleStr = alias != null && !alias.isEmpty() ? alias : String.format("(%d, %d)", this.targetPos.getX(), this.targetPos.getZ());
        g.drawString(this.font, titleStr, this.bookX + 36, this.bookY + 18, 0, false);
        int textX = this.bookX + 36;
        int textY = this.bookY + 32;
        for (int i = 0; i < Math.min(this.lines.size(), 14); ++i) {
            String line = this.lines.get(i);
            g.drawString(this.font, line, textX, textY + i * 9, 0, false);
        }
        this.updateCursorBlink();
        if (this.cursorVisible && this.cursorLine < this.lines.size()) {
            String currentLine = this.lines.get(this.cursorLine);
            int cursorX = textX + this.font.width(currentLine.substring(0, Math.min(this.cursorPos, currentLine.length())));
            int cursorY = textY + this.cursorLine * 9;
            g.fill(cursorX, cursorY, cursorX + 1, cursorY + 9, -16777216);
        }
        super.render(g, mouseX, mouseY, partialTick);
    }

    private void updateCursorBlink() {
        long now = System.currentTimeMillis();
        if (now - this.lastBlink > 500L) {
            this.cursorVisible = !this.cursorVisible;
            this.lastBlink = now;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.setScreen(this.parent);
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            if (this.lines.size() < 14) {
                String current = this.lines.get(this.cursorLine);
                String before = current.substring(0, Math.min(this.cursorPos, current.length()));
                String after = current.substring(Math.min(this.cursorPos, current.length()));
                this.lines.set(this.cursorLine, before);
                this.lines.add(this.cursorLine + 1, after);
                ++this.cursorLine;
                this.cursorPos = 0;
            }
            return true;
        }
        if (keyCode == 259) {
            if (this.cursorPos > 0) {
                String current = this.lines.get(this.cursorLine);
                String newLine = current.substring(0, this.cursorPos - 1) + current.substring(this.cursorPos);
                this.lines.set(this.cursorLine, newLine);
                --this.cursorPos;
            } else if (this.cursorLine > 0) {
                String current = this.lines.remove(this.cursorLine);
                --this.cursorLine;
                String prev = this.lines.get(this.cursorLine);
                this.cursorPos = prev.length();
                this.lines.set(this.cursorLine, prev + current);
            }
            return true;
        }
        if (keyCode == 261) {
            String current = this.lines.get(this.cursorLine);
            if (this.cursorPos < current.length()) {
                String newLine = current.substring(0, this.cursorPos) + current.substring(this.cursorPos + 1);
                this.lines.set(this.cursorLine, newLine);
            } else if (this.cursorLine < this.lines.size() - 1) {
                String next = this.lines.remove(this.cursorLine + 1);
                this.lines.set(this.cursorLine, current + next);
            }
            return true;
        }
        if (keyCode == 263) {
            if (this.cursorPos > 0) {
                --this.cursorPos;
            } else if (this.cursorLine > 0) {
                --this.cursorLine;
                this.cursorPos = this.lines.get(this.cursorLine).length();
            }
            return true;
        }
        if (keyCode == 262) {
            String current = this.lines.get(this.cursorLine);
            if (this.cursorPos < current.length()) {
                ++this.cursorPos;
            } else if (this.cursorLine < this.lines.size() - 1) {
                ++this.cursorLine;
                this.cursorPos = 0;
            }
            return true;
        }
        if (keyCode == 265) {
            if (this.cursorLine > 0) {
                --this.cursorLine;
                this.cursorPos = Math.min(this.cursorPos, this.lines.get(this.cursorLine).length());
            }
            return true;
        }
        if (keyCode == 264) {
            if (this.cursorLine < this.lines.size() - 1) {
                ++this.cursorLine;
                this.cursorPos = Math.min(this.cursorPos, this.lines.get(this.cursorLine).length());
            }
            return true;
        }
        if (keyCode == 268) {
            this.cursorPos = 0;
            return true;
        }
        if (keyCode == 269) {
            this.cursorPos = this.lines.get(this.cursorLine).length();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int modifiers) {
        if (Character.isISOControl(c)) {
            return false;
        }
        String current = this.lines.get(this.cursorLine);
        String newLine = current.substring(0, this.cursorPos) + c + current.substring(this.cursorPos);
        if (this.font.width(newLine) <= 114) {
            this.lines.set(this.cursorLine, newLine);
            ++this.cursorPos;
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int textX = this.bookX + 36;
        int textY = this.bookY + 32;
        if (mouseX >= (double)textX && mouseX < (double)(textX + 114) && mouseY >= (double)textY && mouseY < (double)(textY + 126)) {
            int clickedLine = (int)((mouseY - (double)textY) / 9.0);
            if (clickedLine < this.lines.size()) {
                this.cursorLine = clickedLine;
                String line = this.lines.get(this.cursorLine);
                int relX = (int)(mouseX - (double)textX);
                this.cursorPos = 0;
                int i = 0;
                while (i <= line.length()) {
                    if (this.font.width(line.substring(0, i)) >= relX) {
                        this.cursorPos = Math.max(0, i - 1);
                        break;
                    }
                    this.cursorPos = i++;
                }
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void save() {
        ClientMapNotes.clearNotes(this.targetPos);
        for (String line : this.lines) {
            if (line.isEmpty()) continue;
            ClientMapNotes.addNote(this.targetPos, line);
        }
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

