/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.map.ui;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class SimpleTextInputScreen
extends Screen {
    private final Component titleText;
    private final String initial;
    private final Consumer<String> onSubmit;
    private final Screen parent;
    private EditBox box;

    public SimpleTextInputScreen(Component titleText, String initial, Consumer<String> onSubmit) {
        this(titleText, initial, onSubmit, null);
    }

    public SimpleTextInputScreen(Component titleText, String initial, Consumer<String> onSubmit, Screen parent) {
        super(titleText);
        this.titleText = titleText;
        this.initial = initial != null ? initial : "";
        this.onSubmit = onSubmit;
        this.parent = parent;
    }

    protected void init() {
        int w = 240;
        int x = (this.width - w) / 2;
        int y = this.height / 2 - 20;
        this.box = new EditBox(this.font, x, y, w, 20, this.titleText);
        this.box.setMaxLength(512);
        this.box.setValue(this.initial);
        this.addRenderableWidget((GuiEventListener)this.box);
        int bw = 80;
        int by = y + 28;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.roadweaver.common.ok"), b -> this.submit()).bounds(x, by, bw, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.roadweaver.common.cancel"), b -> this.cancel()).bounds(x + w - bw, by, bw, 20).build());
        this.setInitialFocus((GuiEventListener)this.box);
    }

    private void submit() {
        if (this.onSubmit != null) {
            this.onSubmit.accept(this.box.getValue());
        }
        Minecraft.getInstance().setScreen(this.parent);
    }

    private void cancel() {
        Minecraft.getInstance().setScreen(this.parent);
    }

    public void renderBackground(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        g.fill(0, 0, this.width, this.height, -1879048192);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 335) {
            this.submit();
            return true;
        }
        if (keyCode == 256) {
            this.cancel();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

