/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.neoforge;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.shiroha233.roadweaver.client.map.RoadMapScreen;
import net.shiroha233.roadweaver.client.map.data.ClientMapNotes;
import net.shiroha233.roadweaver.client.map.data.MapSnapshotCache;

@EventBusSubscriber(modid="roadweaver", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientKeyMappings {
    public static KeyMapping OPEN_MAP;

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        OPEN_MAP = new KeyMapping("key.roadweaver.open_map", InputConstants.Type.KEYSYM, 72, "key.categories.roadweaver");
        event.register(OPEN_MAP);
    }

    @EventBusSubscriber(modid="roadweaver", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
    public static class ForgeBusHandlers {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            if (OPEN_MAP == null) {
                return;
            }
            if (mc.screen instanceof RoadMapScreen) {
                return;
            }
            while (OPEN_MAP.consumeClick()) {
                mc.setScreen((Screen)new RoadMapScreen());
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
            MapSnapshotCache.clearNow();
            ClientMapNotes.onWorldJoin();
        }

        @SubscribeEvent
        public static void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
            MapSnapshotCache.clearNow();
            ClientMapNotes.onWorldLeave();
        }
    }
}

