/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.client.neoforge;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.shiroha233.roadweaver.client.neoforge.OpenPresetEditorEntry;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.config.PresetService;

public class ConfigScreenFactoryImpl {
    public static Screen createConfigScreen(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.translatable((String)"config.roadweaver.title"));
        PresetService.reload();
        ModConfig conf = ConfigService.get();
        builder.setSavingRunnable(ConfigService::save);
        ConfigCategory filters = builder.getOrCreateCategory((Component)Component.translatable((String)"config.roadweaver.category.structure_filters"));
        ConfigEntryBuilder eb = builder.entryBuilder();
        filters.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.translatable((String)"config.roadweaver.enable_prediction"), conf.villagePredictionEnabled()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.enable_prediction.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setVillagePredictionEnabled((boolean)v);
            }
        }).build());
        filters.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.radius_chunks"), conf.predictRadiusChunks()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.radius_chunks.tooltip")}).setMin(1).setMax(4096).setSaveConsumer(v -> {
            if (v != null) {
                conf.setPredictRadiusChunks((int)v);
            }
        }).build());
        filters.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.translatable((String)"config.roadweaver.biome_prefilter"), conf.biomePrefilter()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.biome_prefilter.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBiomePrefilter((boolean)v);
            }
        }).build());
        ArrayList whitelist = new ArrayList(conf.structureWhitelist() == null ? List.of() : conf.structureWhitelist());
        ArrayList blacklist = new ArrayList(conf.structureBlacklist() == null ? List.of() : conf.structureBlacklist());
        filters.addEntry((AbstractConfigListEntry)eb.startStrList((Component)Component.translatable((String)"config.roadweaver.whitelist"), whitelist).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.whitelist.tooltip")}).setSaveConsumer(list -> conf.setStructureWhitelist(ConfigScreenFactoryImpl.normalize(list))).build());
        filters.addEntry((AbstractConfigListEntry)eb.startStrList((Component)Component.translatable((String)"config.roadweaver.blacklist"), blacklist).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.blacklist.tooltip")}).setSaveConsumer(list -> conf.setStructureBlacklist(ConfigScreenFactoryImpl.normalize(list))).build());
        ConfigCategory planning = builder.getOrCreateCategory((Component)Component.translatable((String)"config.roadweaver.category.road_planning"));
        planning.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.initial_plan_radius_chunks"), conf.initialPlanRadiusChunks()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.initial_plan_radius_chunks.tooltip")}).setMin(1).setMax(4096).setSaveConsumer(v -> {
            if (v != null) {
                conf.setInitialPlanRadiusChunks((int)v);
            }
        }).build());
        planning.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.translatable((String)"config.roadweaver.dynamic_plan_enabled"), conf.dynamicPlanEnabled()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.dynamic_plan_enabled.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setDynamicPlanEnabled((boolean)v);
            }
        }).build());
        planning.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.dynamic_plan_radius_chunks"), conf.dynamicPlanRadiusChunks()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.dynamic_plan_radius_chunks.tooltip")}).setMin(1).setMax(4096).setSaveConsumer(v -> {
            if (v != null) {
                conf.setDynamicPlanRadiusChunks((int)v);
            }
        }).build());
        planning.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.dynamic_plan_stride_chunks"), conf.dynamicPlanStrideChunks()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.dynamic_plan_stride_chunks.tooltip")}).setMin(1).setMax(256).setSaveConsumer(v -> {
            if (v != null) {
                conf.setDynamicPlanStrideChunks((int)v);
            }
        }).build());
        ModConfig.PlanningAlgorithm planningAlgo = conf.planningAlgorithm() != null ? conf.planningAlgorithm() : ModConfig.PlanningAlgorithm.RNG;
        planning.addEntry((AbstractConfigListEntry)eb.startEnumSelector((Component)Component.translatable((String)"config.roadweaver.planning_algorithm"), ModConfig.PlanningAlgorithm.class, (Enum)planningAlgo).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.planning_algorithm.tooltip")}).setEnumNameProvider(v -> Component.translatable((String)("config.roadweaver.planning_algorithm.option." + v.name().toLowerCase(Locale.ROOT)))).setSaveConsumer(v -> {
            if (v != null) {
                conf.setPlanningAlgorithm((ModConfig.PlanningAlgorithm)((Object)v));
            }
        }).build());
        ConfigCategory roadGen = builder.getOrCreateCategory((Component)Component.translatable((String)"config.roadweaver.category.road_generation"));
        roadGen.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.translatable((String)"config.roadweaver.allow_artificial"), conf.allowArtificial()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.allow_artificial.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setAllowArtificial((boolean)v);
            }
        }).build());
        roadGen.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.translatable((String)"config.roadweaver.allow_natural"), conf.allowNatural()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.allow_natural.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setAllowNatural((boolean)v);
            }
        }).build());
        roadGen.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.translatable((String)"config.roadweaver.place_waypoints"), conf.placeWaypoints()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.place_waypoints.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setPlaceWaypoints((boolean)v);
            }
        }).build());
        roadGen.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.road_width"), conf.roadWidth()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.road_width.tooltip")}).setMin(0).setMax(15).setSaveConsumer(v -> {
            if (v != null) {
                conf.setRoadWidth((int)v);
            }
        }).build());
        roadGen.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.structure_road_offset"), conf.structureRoadOffset()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.structure_road_offset.tooltip")}).setMin(0).setMax(256).setSaveConsumer(v -> {
            if (v != null) {
                conf.setStructureRoadOffset((int)v);
            }
        }).build());
        roadGen.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.lamp_interval"), conf.lampInterval()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.lamp_interval.tooltip")}).setMin(1).setMax(2048).setSaveConsumer(v -> {
            if (v != null) {
                conf.setLampInterval((int)v);
            }
        }).build());
        roadGen.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.road_clear_height"), conf.roadClearHeight()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.road_clear_height.tooltip")}).setMin(1).setMax(16).setSaveConsumer(v -> {
            if (v != null) {
                conf.setRoadClearHeight((int)v);
            }
        }).build());
        roadGen.addEntry((AbstractConfigListEntry)new OpenPresetEditorEntry());
        ConfigCategory genSurface = builder.getOrCreateCategory((Component)Component.translatable((String)"config.roadweaver.category.gen_surface"));
        genSurface.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.averaging_radius"), conf.averagingRadius()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.averaging_radius.tooltip")}).setMin(0).setMax(64).setSaveConsumer(v -> {
            if (v != null) {
                conf.setAveragingRadius((int)v);
            }
        }).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.max_slope_step_per_two_segments"), conf.maxSlopeStepPerTwoSegments()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.max_slope_step_per_two_segments.tooltip")}).setMin(0).setMax(8).setSaveConsumer(v -> {
            if (v != null) {
                conf.setMaxSlopeStepPerTwoSegments((int)v);
            }
        }).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.translatable((String)"config.roadweaver.slope_limit_enabled"), conf.slopeLimitEnabled()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.slope_limit_enabled.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setSlopeLimitEnabled((boolean)v);
            }
        }).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.causeway_max_depth"), conf.causewayMaxDepth()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.causeway_max_depth.tooltip")}).setMin(0).setMax(12).setSaveConsumer(v -> {
            if (v != null) {
                conf.setCausewayMaxDepth((int)v);
            }
        }).build());
        genSurface.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.translatable((String)"config.roadweaver.prevent_trees_on_road"), conf.preventTreesOnRoad()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.prevent_trees_on_road.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setPreventTreesOnRoad((boolean)v);
            }
        }).build());
        ConfigCategory bridge = builder.getOrCreateCategory((Component)Component.translatable((String)"config.roadweaver.category.bridge"));
        bridge.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.translatable((String)"config.roadweaver.bridge_enabled"), conf.bridgeEnabled()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.bridge_enabled.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBridgeEnabled((boolean)v);
            }
        }).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.bridge_deck_clearance"), conf.bridgeDeckClearance()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.bridge_deck_clearance.tooltip")}).setMin(1).setMax(8).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBridgeDeckClearance((int)v);
            }
        }).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.translatable((String)"config.roadweaver.bridge_railing_enabled"), conf.bridgeRailingEnabled()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.bridge_railing_enabled.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBridgeRailingEnabled((boolean)v);
            }
        }).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.bridge_pier_interval"), conf.bridgePierInterval()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.bridge_pier_interval.tooltip")}).setMin(3).setMax(32).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBridgePierInterval((int)v);
            }
        }).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.bridge_pier_width"), conf.bridgePierWidth()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.bridge_pier_width.tooltip")}).setMin(1).setMax(3).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBridgePierWidth((int)v);
            }
        }).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.bridge_pier_max_height"), conf.bridgePierMaxHeight()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.bridge_pier_max_height.tooltip")}).setMin(6).setMax(64).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBridgePierMaxHeight((int)v);
            }
        }).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.translatable((String)"config.roadweaver.bridge_keep_lamps"), conf.bridgeKeepLamps()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.bridge_keep_lamps.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBridgeKeepLamps((boolean)v);
            }
        }).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.bridge_ramp_segments"), conf.bridgeRampSegments()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.bridge_ramp_segments.tooltip")}).setMin(0).setMax(12).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBridgeRampSegments((int)v);
            }
        }).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.bridge_min_water_depth"), conf.bridgeMinWaterDepth()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.bridge_min_water_depth.tooltip")}).setMin(1).setMax(10).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBridgeMinWaterDepth((int)v);
            }
        }).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.bridge_min_length"), conf.bridgeMinLength()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.bridge_min_length.tooltip")}).setMin(1).setMax(32).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBridgeMinLength((int)v);
            }
        }).build());
        bridge.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.bridge_merge_gap"), conf.bridgeMergeGap()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.bridge_merge_gap.tooltip")}).setMin(1).setMax(32).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBridgeMergeGap((int)v);
            }
        }).build());
        ConfigCategory roadsideStructures = builder.getOrCreateCategory((Component)Component.translatable((String)"config.roadweaver.category.roadside_structures"));
        roadsideStructures.addEntry((AbstractConfigListEntry)eb.startBooleanToggle((Component)Component.translatable((String)"config.roadweaver.roadside_structures_enabled"), conf.roadsideStructuresEnabled()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.roadside_structures_enabled.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setRoadsideStructuresEnabled((boolean)v);
            }
        }).build());
        roadsideStructures.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.max_structures_per_road"), conf.maxStructuresPerRoad()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.max_structures_per_road.tooltip")}).setMin(0).setMax(20).setSaveConsumer(v -> {
            if (v != null) {
                conf.setMaxStructuresPerRoad((int)v);
            }
        }).build());
        roadsideStructures.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.min_structure_spacing"), conf.minStructureSpacing()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.min_structure_spacing.tooltip")}).setMin(1).setMax(256).setSaveConsumer(v -> {
            if (v != null) {
                conf.setMinStructureSpacing((int)v);
            }
        }).build());
        roadsideStructures.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.small_structure_offset"), conf.smallStructureOffset()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.small_structure_offset.tooltip")}).setMin(1).setMax(64).setSaveConsumer(v -> {
            if (v != null) {
                conf.setSmallStructureOffset((int)v);
            }
        }).build());
        roadsideStructures.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.medium_structure_offset"), conf.mediumStructureOffset()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.medium_structure_offset.tooltip")}).setMin(1).setMax(64).setSaveConsumer(v -> {
            if (v != null) {
                conf.setMediumStructureOffset((int)v);
            }
        }).build());
        roadsideStructures.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.large_structure_offset"), conf.largeStructureOffset()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.large_structure_offset.tooltip")}).setMin(1).setMax(64).setSaveConsumer(v -> {
            if (v != null) {
                conf.setLargeStructureOffset((int)v);
            }
        }).build());
        ConfigCategory genPerformance = builder.getOrCreateCategory((Component)Component.translatable((String)"config.roadweaver.category.gen_performance"));
        genPerformance.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"text.autoconfig.roadweaver.option.computeThreads"), conf.computeThreads()).setTooltip(new Component[]{Component.translatable((String)"text.autoconfig.roadweaver.option.computeThreads.@Tooltip")}).setMin(0).setMax(128).setSaveConsumer(v -> {
            if (v != null) {
                conf.setComputeThreads((int)v);
            }
        }).build());
        genPerformance.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"text.autoconfig.roadweaver.option.generationThreads"), conf.generationThreads()).setTooltip(new Component[]{Component.translatable((String)"text.autoconfig.roadweaver.option.generationThreads.@Tooltip")}).setMin(1).setMax(64).setSaveConsumer(v -> {
            if (v != null) {
                conf.setGenerationThreads((int)v);
            }
        }).build());
        genPerformance.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"text.autoconfig.roadweaver.option.initialGenerationThreads"), conf.initialGenerationThreads()).setTooltip(new Component[]{Component.translatable((String)"text.autoconfig.roadweaver.option.initialGenerationThreads.@Tooltip")}).setMin(1).setMax(64).setSaveConsumer(v -> {
            if (v != null) {
                conf.setInitialGenerationThreads((int)v);
            }
        }).build());
        genPerformance.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.a_star_step"), conf.aStarStep()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.a_star_step.tooltip")}).setMin(4).setMax(128).setSaveConsumer(v -> {
            if (v != null) {
                conf.setAStarStep((int)v);
            }
        }).build());
        genPerformance.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.a_star_max_steps"), conf.aStarMaxSteps()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.a_star_max_steps.tooltip")}).setMin(100).setMax(100000).setSaveConsumer(v -> {
            if (v != null) {
                conf.setAStarMaxSteps((int)v);
            }
        }).build());
        genPerformance.addEntry((AbstractConfigListEntry)eb.startEnumSelector((Component)Component.translatable((String)"config.roadweaver.pathfinding_algorithm"), ModConfig.PathfindingAlgorithm.class, (Enum)conf.pathfindingAlgorithm()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.pathfinding_algorithm.tooltip")}).setEnumNameProvider(v -> Component.translatable((String)("config.roadweaver.pathfinding_algorithm.option." + v.name().toLowerCase(Locale.ROOT)))).setSaveConsumer(v -> {
            if (v != null) {
                conf.setPathfindingAlgorithm((ModConfig.PathfindingAlgorithm)((Object)v));
            }
        }).build());
        genPerformance.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.max_concurrent_generations"), conf.maxConcurrentGenerations()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.max_concurrent_generations.tooltip")}).setMin(1).setMax(128).setSaveConsumer(v -> {
            if (v != null) {
                conf.setMaxConcurrentGenerations((int)v);
            }
        }).build());
        genPerformance.addEntry((AbstractConfigListEntry)eb.startIntSlider((Component)Component.translatable((String)"config.roadweaver.thread_duty_cycle"), conf.threadDutyCycle(), 1, 100).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.thread_duty_cycle.tooltip")}).setSaveConsumer(v -> {
            if (v != null) {
                conf.setThreadDutyCycle((int)v);
            }
        }).build());
        ConfigCategory pathfindingCosts = builder.getOrCreateCategory((Component)Component.translatable((String)"config.roadweaver.category.pathfinding_costs"));
        pathfindingCosts.addEntry((AbstractConfigListEntry)eb.startDoubleField((Component)Component.translatable((String)"config.roadweaver.ortho_step_cost"), conf.orthoStepCost()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.ortho_step_cost.tooltip")}).setMin(0.0).setSaveConsumer(v -> {
            if (v != null) {
                conf.setOrthoStepCost((double)v);
            }
        }).build());
        pathfindingCosts.addEntry((AbstractConfigListEntry)eb.startDoubleField((Component)Component.translatable((String)"config.roadweaver.diag_step_cost"), conf.diagStepCost()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.diag_step_cost.tooltip")}).setMin(0.0).setSaveConsumer(v -> {
            if (v != null) {
                conf.setDiagStepCost((double)v);
            }
        }).build());
        pathfindingCosts.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.elevation_weight"), conf.elevationWeight()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.elevation_weight.tooltip")}).setMin(0).setSaveConsumer(v -> {
            if (v != null) {
                conf.setElevationWeight((int)v);
            }
        }).build());
        pathfindingCosts.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.biome_weight"), conf.biomeWeight()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.biome_weight.tooltip")}).setMin(0).setSaveConsumer(v -> {
            if (v != null) {
                conf.setBiomeWeight((int)v);
            }
        }).build());
        pathfindingCosts.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.stability_weight"), conf.stabilityWeight()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.stability_weight.tooltip")}).setMin(0).setSaveConsumer(v -> {
            if (v != null) {
                conf.setStabilityWeight((int)v);
            }
        }).build());
        pathfindingCosts.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.water_depth_weight"), conf.waterDepthWeight()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.water_depth_weight.tooltip")}).setMin(0).setSaveConsumer(v -> {
            if (v != null) {
                conf.setWaterDepthWeight((int)v);
            }
        }).build());
        pathfindingCosts.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.near_water_cost"), conf.nearWaterCost()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.near_water_cost.tooltip")}).setMin(0).setSaveConsumer(v -> {
            if (v != null) {
                conf.setNearWaterCost((int)v);
            }
        }).build());
        pathfindingCosts.addEntry((AbstractConfigListEntry)eb.startIntField((Component)Component.translatable((String)"config.roadweaver.water_proximity_cost"), conf.waterProximityCost()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.water_proximity_cost.tooltip")}).setMin(0).setSaveConsumer(v -> {
            if (v != null) {
                conf.setWaterProximityCost((int)v);
            }
        }).build());
        pathfindingCosts.addEntry((AbstractConfigListEntry)eb.startDoubleField((Component)Component.translatable((String)"config.roadweaver.heuristic_weight"), conf.heuristicWeight()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.heuristic_weight.tooltip")}).setMin(0.0).setSaveConsumer(v -> {
            if (v != null) {
                conf.setHeuristicWeight((double)v);
            }
        }).build());
        pathfindingCosts.addEntry((AbstractConfigListEntry)eb.startDoubleField((Component)Component.translatable((String)"config.roadweaver.deviation_weight"), conf.deviationWeight()).setTooltip(new Component[]{Component.translatable((String)"config.roadweaver.deviation_weight.tooltip")}).setMin(0.0).setSaveConsumer(v -> {
            if (v != null) {
                conf.setDeviationWeight((double)v);
            }
        }).build());
        return builder.build();
    }

    private static List<String> normalize(List<String> src) {
        if (src == null) {
            return List.of();
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String s : src) {
            String v;
            if (s == null || (v = s.trim().toLowerCase(Locale.ROOT)).isEmpty()) continue;
            set.add(v);
        }
        return new ArrayList<String>(set);
    }
}

