/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.base;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.shiroha233.roadweaver.features.decoration.compat.RoadFeatureCompat;

public abstract class Decoration {
    private BlockPos placePos;
    private final WorldGenLevel world;

    public Decoration(BlockPos placePos, WorldGenLevel world) {
        this.placePos = placePos;
        this.world = world;
    }

    public abstract void place();

    public BlockPos computeSurfacePos() {
        return new BlockPos(this.placePos.getX(), this.world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, this.placePos.getX(), this.placePos.getZ()), this.placePos.getZ());
    }

    public boolean isPlaceAllowedAt(BlockPos surfacePos) {
        BlockState below = this.world.getBlockState(surfacePos.below());
        boolean belowInvalid = below.is(Blocks.WATER) || below.is(Blocks.LAVA) || below.is(BlockTags.LOGS) || RoadFeatureCompat.dontPlaceHere(below.getBlock());
        return !belowInvalid;
    }

    protected final boolean placeAllowed() {
        BlockPos surfacePos;
        this.placePos = surfacePos = this.computeSurfacePos();
        return this.isPlaceAllowedAt(surfacePos);
    }

    public BlockPos getPos() {
        return this.placePos;
    }

    public WorldGenLevel getWorld() {
        return this.world;
    }
}

