/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.material.surface;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public final class BiomeRoadMaterialSelector {
    private BiomeRoadMaterialSelector() {
    }

    public static List<BlockState> forBiome(WorldGenLevel world, BlockPos pos) {
        Holder biome = world.getBiome(pos);
        Optional keyOpt = biome.unwrapKey();
        if (keyOpt.isPresent()) {
            ResourceKey key = (ResourceKey)keyOpt.get();
            if (key == Biomes.DESERT || key == Biomes.BEACH) {
                return BiomeRoadMaterialSelector.list(Blocks.SANDSTONE, Blocks.CUT_SANDSTONE);
            }
            if (key == Biomes.BADLANDS || key == Biomes.ERODED_BADLANDS || key == Biomes.WOODED_BADLANDS) {
                return BiomeRoadMaterialSelector.list(Blocks.RED_SANDSTONE, Blocks.CUT_RED_SANDSTONE);
            }
            if (biome.is(BiomeTags.IS_SAVANNA)) {
                return BiomeRoadMaterialSelector.list(Blocks.DIRT_PATH, Blocks.COARSE_DIRT);
            }
            if (biome.is(BiomeTags.IS_JUNGLE) || key == Biomes.BAMBOO_JUNGLE) {
                return BiomeRoadMaterialSelector.list(Blocks.DIRT_PATH, Blocks.MOSSY_COBBLESTONE);
            }
            if (biome.is(BiomeTags.IS_TAIGA)) {
                return BiomeRoadMaterialSelector.list(Blocks.COARSE_DIRT, Blocks.GRAVEL);
            }
            if (key == Biomes.SNOWY_PLAINS || key == Biomes.SNOWY_TAIGA || key == Biomes.GROVE || key == Biomes.SNOWY_SLOPES || key == Biomes.JAGGED_PEAKS || key == Biomes.FROZEN_PEAKS) {
                return BiomeRoadMaterialSelector.list(Blocks.ANDESITE, Blocks.COBBLESTONE);
            }
            if (key == Biomes.SWAMP || key == Biomes.MANGROVE_SWAMP) {
                return BiomeRoadMaterialSelector.list(Blocks.PACKED_MUD, Blocks.COARSE_DIRT);
            }
            if (key == Biomes.DARK_FOREST) {
                return BiomeRoadMaterialSelector.list(Blocks.MOSSY_COBBLESTONE, Blocks.COBBLESTONE);
            }
            if (key == Biomes.BIRCH_FOREST || key == Biomes.OLD_GROWTH_BIRCH_FOREST || key == Biomes.CHERRY_GROVE) {
                return BiomeRoadMaterialSelector.list(Blocks.DIRT_PATH, Blocks.GRAVEL);
            }
            if (key == Biomes.STONY_PEAKS || key == Biomes.WINDSWEPT_FOREST || key == Biomes.WINDSWEPT_HILLS || key == Biomes.WINDSWEPT_GRAVELLY_HILLS) {
                return BiomeRoadMaterialSelector.list(Blocks.STONE, Blocks.COBBLESTONE);
            }
            if (key == Biomes.MUSHROOM_FIELDS) {
                return BiomeRoadMaterialSelector.list(Blocks.STONE, Blocks.COBBLESTONE);
            }
        }
        return BiomeRoadMaterialSelector.list(Blocks.DIRT_PATH, Blocks.GRAVEL, Blocks.COARSE_DIRT);
    }

    private static List<BlockState> list(Block ... blocks) {
        ArrayList<BlockState> out = new ArrayList<BlockState>();
        for (Block b : blocks) {
            out.add(b.defaultBlockState());
        }
        return out;
    }
}

