/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.text;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;

public final class SignTextService {
    private SignTextService() {
    }

    public static void writeDistanceSign(WorldGenLevel level, BlockPos pos, String text) {
        ServerLevel l = level.getLevel();
        if (!(l instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = l;
        sLevel.getServer().execute(() -> {
            BlockEntity be = sLevel.getBlockEntity(pos);
            if (be instanceof HangingSignBlockEntity) {
                HangingSignBlockEntity sign = (HangingSignBlockEntity)be;
                SignText front = sign.getText(true);
                front = front.setMessage(0, (Component)Component.translatable((String)"gui.roadweaver.sign.next_location"));
                front = front.setMessage(1, (Component)Component.literal((String)(text + " m")));
                front = front.setMessage(2, (Component)Component.literal((String)""));
                front = front.setMessage(3, (Component)Component.literal((String)""));
                sign.setText(front, true);
                SignText back = sign.getText(false);
                back = back.setMessage(0, (Component)Component.literal((String)"----------"));
                back = back.setMessage(1, (Component)Component.translatable((String)"gui.roadweaver.sign.welcome"));
                back = back.setMessage(2, (Component)Component.translatable((String)"gui.roadweaver.sign.traveller"));
                back = back.setMessage(3, (Component)Component.literal((String)"----------"));
                sign.setText(back, false);
                sign.setChanged();
            }
        });
    }
}

