/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.decoration.types;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.shiroha233.roadweaver.features.decoration.base.OrientedDecoration;
import net.shiroha233.roadweaver.features.decoration.material.wood.BiomeWoodAware;
import net.shiroha233.roadweaver.features.decoration.text.SignTextService;
import net.shiroha233.roadweaver.helpers.Records;

public class DistanceSignDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private final boolean isStart;
    private final String signText;
    private Records.WoodAssets wood;

    public DistanceSignDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world, boolean isStart, String distanceText) {
        super(pos, direction, world);
        this.isStart = isStart;
        this.signText = distanceText;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        int rotation = this.getCardinalRotationFromVector(this.getOrthogonalVector(), this.isStart);
        OrientedDecoration.DirectionProperties props = this.getDirectionProperties(rotation);
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        BlockPos signPos = basePos.above(2).relative(props.offsetDirection.getOpposite());
        world.setBlock(signPos, (BlockState)((BlockState)this.wood.hangingSign().defaultBlockState().setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rotation))).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true)), 3);
        this.updateSigns(world, signPos, this.signText);
        this.placeFenceStructure(basePos, props);
    }

    private void placeFenceStructure(BlockPos pos, OrientedDecoration.DirectionProperties props) {
        WorldGenLevel world = this.getWorld();
        world.setBlock(pos.above(3).relative(props.offsetDirection.getOpposite()), (BlockState)this.wood.fence().defaultBlockState().setValue((Property)props.directionProperty, (Comparable)Boolean.valueOf(true)), 3);
        world.setBlock(pos.above(0), this.wood.fence().defaultBlockState(), 3);
        world.setBlock(pos.above(1), this.wood.fence().defaultBlockState(), 3);
        world.setBlock(pos.above(2), this.wood.fence().defaultBlockState(), 3);
        world.setBlock(pos.above(3), (BlockState)this.wood.fence().defaultBlockState().setValue((Property)props.reverseDirectionProperty, (Comparable)Boolean.valueOf(true)), 3);
    }

    private void updateSigns(WorldGenLevel level, BlockPos pos, String text) {
        SignTextService.writeDistanceSign(level, pos, text);
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

