/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.core;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.search.StructurePredictor;

public final class StructureRoadOffsetService {
    private static final int MATCH_TOLERANCE_BLOCKS = 16;

    private StructureRoadOffsetService() {
    }

    @Deprecated
    public static BlockPos adjustEndpoint(ServerLevel level, BlockPos endpoint, BlockPos otherEnd) {
        return endpoint;
    }

    public static List<Records.RoadSegmentPlacement> trimPathNearStructure(ServerLevel level, List<Records.RoadSegmentPlacement> segments, BlockPos rawStart, BlockPos rawEnd) {
        long distSq;
        long dz;
        long dx;
        BlockPos pos;
        int i;
        long offsetSq;
        if (segments == null || segments.size() < 3) {
            return segments;
        }
        if (!Level.OVERWORLD.equals(level.dimension())) {
            return segments;
        }
        int startOffset = StructureRoadOffsetService.getOffsetBlocksForEndpoint(level, rawStart);
        int endOffset = StructureRoadOffsetService.getOffsetBlocksForEndpoint(level, rawEnd);
        if (startOffset <= 0 && endOffset <= 0) {
            return segments;
        }
        int n = segments.size();
        int trimStart = 0;
        int trimEnd = n;
        if (startOffset > 0) {
            offsetSq = (long)startOffset * (long)startOffset;
            for (i = 0; i < n; ++i) {
                pos = segments.get(i).middlePos();
                dx = (long)pos.getX() - (long)rawStart.getX();
                distSq = dx * dx + (dz = (long)pos.getZ() - (long)rawStart.getZ()) * dz;
                if (distSq < offsetSq) continue;
                trimStart = i;
                break;
            }
        }
        if (endOffset > 0) {
            offsetSq = (long)endOffset * (long)endOffset;
            for (i = n - 1; i >= 0; --i) {
                pos = segments.get(i).middlePos();
                dx = (long)pos.getX() - (long)rawEnd.getX();
                distSq = dx * dx + (dz = (long)pos.getZ() - (long)rawEnd.getZ()) * dz;
                if (distSq < offsetSq) continue;
                trimEnd = i + 1;
                break;
            }
        }
        if (trimStart >= trimEnd || trimEnd - trimStart < 3) {
            int mid = n / 2;
            trimStart = Math.max(0, mid - 2);
            trimEnd = Math.min(n, mid + 3);
        }
        return new ArrayList<Records.RoadSegmentPlacement>(segments.subList(trimStart, trimEnd));
    }

    public static int getOffsetBlocksForEndpoint(ServerLevel level, BlockPos endpoint) {
        StructureCategory cat = StructureRoadOffsetService.detectCategory(level, endpoint);
        int configOffset = ConfigService.get().structureRoadOffset();
        return switch (cat.ordinal()) {
            case 0 -> configOffset;
            default -> 0;
        };
    }

    private static StructureCategory detectCategory(ServerLevel level, BlockPos endpoint) {
        int cz;
        int searchRadius;
        if (!Level.OVERWORLD.equals(level.dimension())) {
            return StructureCategory.UNKNOWN;
        }
        int cx = endpoint.getX() >> 4;
        List<Records.StructureInfo> infos = StructurePredictor.predictOverworldStructuresInRect(level, cx - (searchRadius = 1), (cz = endpoint.getZ() >> 4) - searchRadius, cx + searchRadius, cz + searchRadius, true, List.of("#minecraft:village"), List.of());
        if (infos == null || infos.isEmpty()) {
            return StructureCategory.UNKNOWN;
        }
        int tolerance = Math.max(16, ConfigService.get().aStarStep() + 8);
        long tol2 = (long)tolerance * (long)tolerance;
        for (Records.StructureInfo info : infos) {
            long dz;
            BlockPos p = info.pos();
            long dx = (long)p.getX() - (long)endpoint.getX();
            long d2 = dx * dx + (dz = (long)p.getZ() - (long)endpoint.getZ()) * dz;
            if (d2 > tol2) continue;
            return StructureCategory.VILLAGE;
        }
        return StructureCategory.UNKNOWN;
    }

    private static enum StructureCategory {
        VILLAGE,
        OTHER,
        UNKNOWN;

    }
}

