/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.pathfinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.PathPostProcessor;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.RoadPathCalculator;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.runtime.ThreadPoolManager;

final class BasicAStarPathfinder {
    private static final int BIOME_BASE_COST = 12;
    private static final double HEURISTIC_EPSILON = 0.2;

    private BasicAStarPathfinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Records.RoadSegmentPlacement> calculateLandPath(BlockPos startGround, BlockPos endGround, int width, ServerLevel level, int maxSteps, TerrainSamplingCache cache) {
        PriorityQueue<Node> openSet = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.f));
        HashMap<BlockPos, Node> allNodes = new HashMap<BlockPos, Node>();
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        ModConfig cfg = ConfigService.get();
        Node startNode = new Node(startGround, null, 0.0, BasicAStarPathfinder.heuristic(startGround, endGround, cfg));
        openSet.add(startNode);
        allNodes.put(startGround, startNode);
        int d = BasicAStarPathfinder.getNeighborDistance();
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        int stepsBudget = Math.max(1, maxSteps);
        ThreadPoolManager.resetThrottle();
        try {
            List<Records.RoadSegmentPlacement> list;
            while (!openSet.isEmpty() && stepsBudget-- > 0) {
                ThreadPoolManager.throttle();
                if (Thread.currentThread().isInterrupted()) {
                    list = null;
                    return list;
                }
                Node current = openSet.poll();
                if (current == null) break;
                if (BasicAStarPathfinder.manhattan2d(current.pos, endGround) < d * 2) {
                    ArrayList<BlockPos> rawPath = new ArrayList<BlockPos>();
                    Node c = current;
                    while (c != null) {
                        rawPath.add(c.pos);
                        c = c.parent;
                    }
                    Collections.reverse(rawPath);
                    List<Records.RoadSegmentPlacement> list2 = PathPostProcessor.process(rawPath, width, level, cache);
                    return list2;
                }
                closed.add(current.pos);
                allNodes.remove(current.pos);
                for (int[] off : neighborOffsets) {
                    if (Thread.currentThread().isInterrupted()) {
                        List<Records.RoadSegmentPlacement> list3 = null;
                        return list3;
                    }
                    BlockPos nxz = current.pos.offset(off[0], 0, off[1]);
                    int y = RoadPathCalculator.heightSampler(cache, nxz.getX(), nxz.getZ(), level);
                    BlockPos np = new BlockPos(nxz.getX(), y, nxz.getZ());
                    if (closed.contains(np)) continue;
                    Holder<Biome> biome = cache.getBiome(level, np.getX(), np.getZ());
                    int biomeCost = biome.is(BiomeTags.IS_RIVER) || biome.is(BiomeTags.IS_OCEAN) || biome.is(BiomeTags.IS_DEEP_OCEAN) ? 12 : 0;
                    int elevation = Math.abs(y - current.pos.getY());
                    int offsetSum = Math.abs(Math.abs(off[0])) + Math.abs(off[1]);
                    double stepCost = offsetSum == 2 * d ? cfg.diagStepCost() : cfg.orthoStepCost();
                    int stabilityCost = RoadPathCalculator.calculateTerrainStability(cache, np, y, level, d);
                    int sea = level.getSeaLevel();
                    boolean waterColumn = RoadPathCalculator.isColumnWater(cache, nxz.getX(), nxz.getZ(), level);
                    boolean nearWater = RoadPathCalculator.isNearWaterLike(cache, nxz.getX(), nxz.getZ(), level);
                    int oceanFloor = RoadPathCalculator.oceanFloorSampler(cache, nxz.getX(), nxz.getZ(), level);
                    int waterDepth = Math.max(0, sea - oceanFloor);
                    int waterDepthCost = waterColumn ? waterDepth * cfg.waterDepthWeight() : 0;
                    int nearWaterCost = nearWater ? cfg.nearWaterCost() : 0;
                    double deviation = BasicAStarPathfinder.deviation2d(np, startGround, endGround);
                    double deviationCost = deviation * cfg.deviationWeight() / Math.max(1.0, (double)d);
                    double tentativeG = current.g + stepCost + (double)(elevation * cfg.elevationWeight()) + (double)(biomeCost * cfg.biomeWeight()) + (double)(stabilityCost * cfg.stabilityWeight()) + (double)waterDepthCost + (double)nearWaterCost + deviationCost;
                    Node n2 = (Node)allNodes.get(np);
                    if (n2 != null && !(tentativeG < n2.g)) continue;
                    double h = BasicAStarPathfinder.heuristic(np, endGround, cfg);
                    double fWeighted = tentativeG + 1.2 * h;
                    n2 = new Node(np, current, tentativeG, fWeighted);
                    allNodes.put(np, n2);
                    openSet.add(n2);
                }
            }
            list = null;
            return list;
        }
        finally {
            openSet.clear();
            allNodes.clear();
            closed.clear();
        }
    }

    private static int getNeighborDistance() {
        try {
            int v = ConfigService.get().aStarStep();
            if (v < 4) {
                return 16;
            }
            if (v > 128) {
                return 128;
            }
            return v;
        }
        catch (Throwable ignore) {
            return 16;
        }
    }

    private static int manhattan2d(BlockPos a, BlockPos b) {
        return Math.abs(a.getX() - b.getX()) + Math.abs(a.getZ() - b.getZ());
    }

    private static double heuristic(BlockPos a, BlockPos b, ModConfig cfg) {
        int dx = a.getX() - b.getX();
        int dz = a.getZ() - b.getZ();
        double dxzApprox = (double)(Math.abs(dx) + Math.abs(dz)) - 0.6 * (double)Math.min(Math.abs(dx), Math.abs(dz));
        return dxzApprox * cfg.heuristicWeight();
    }

    private static double deviation2d(BlockPos p, BlockPos a, BlockPos b) {
        double ax = a.getX();
        double az = a.getZ();
        double bx = b.getX();
        double bz = b.getZ();
        double px = p.getX();
        double pz = p.getZ();
        double num = Math.abs((bz - az) * px - (bx - ax) * pz + bx * az - bz * ax);
        double den = Math.hypot(bx - ax, bz - az);
        if (den <= 0.0) {
            return 0.0;
        }
        return num / den;
    }

    private static final class Node {
        final BlockPos pos;
        final Node parent;
        final double g;
        final double f;

        Node(BlockPos pos, Node parent, double g, double f) {
            this.pos = pos;
            this.parent = parent;
            this.g = g;
            this.f = f;
        }
    }
}

