/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.pathfinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.PathPostProcessor;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.RoadPathCalculator;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.runtime.ThreadPoolManager;

final class BidirectionalAStarPathfinder {
    private static final int BIOME_BASE_COST = 12;
    private static final double HEURISTIC_EPSILON = 0.2;

    private BidirectionalAStarPathfinder() {
    }

    static List<Records.RoadSegmentPlacement> calculateLandPath(BlockPos startGround, BlockPos endGround, int width, ServerLevel level, int maxSteps, TerrainSamplingCache cache) {
        if (startGround.equals((Object)endGround)) {
            return Collections.emptyList();
        }
        int d = RoadPathCalculator.getNeighborDistance();
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        ModConfig cfg = ConfigService.get();
        PriorityQueue<Node> openF = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.f));
        PriorityQueue<Node> openB = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.f));
        HashMap<BlockPos, Node> nodesF = new HashMap<BlockPos, Node>();
        HashMap<BlockPos, Node> nodesB = new HashMap<BlockPos, Node>();
        HashSet<BlockPos> closedF = new HashSet<BlockPos>();
        HashSet<BlockPos> closedB = new HashSet<BlockPos>();
        Node startNode = new Node(startGround, null, 0.0, BidirectionalAStarPathfinder.heuristic(startGround, endGround, cfg));
        Node endNode = new Node(endGround, null, 0.0, BidirectionalAStarPathfinder.heuristic(endGround, startGround, cfg));
        openF.add(startNode);
        nodesF.put(startGround, startNode);
        openB.add(endNode);
        nodesB.put(endGround, endNode);
        int stepsBudget = Math.max(1, maxSteps);
        ThreadPoolManager.resetThrottle();
        while (!openF.isEmpty() && !openB.isEmpty() && stepsBudget-- > 0) {
            ThreadPoolManager.throttle();
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            Node peekF = openF.peek();
            Node peekB = openB.peek();
            boolean expandForward = peekF == null ? false : (peekB == null ? true : peekF.f <= peekB.f);
            Meet meet = expandForward ? BidirectionalAStarPathfinder.expandOneSide(openF, nodesF, closedF, nodesB, closedB, nodesB, true, startGround, endGround, level, cache, neighborOffsets, d, cfg) : BidirectionalAStarPathfinder.expandOneSide(openB, nodesB, closedB, nodesF, closedF, nodesF, false, endGround, startGround, level, cache, neighborOffsets, d, cfg);
            if (meet == null) continue;
            return BidirectionalAStarPathfinder.reconstructPath(meet.forward, meet.backward, width, level, cache);
        }
        return null;
    }

    private static Meet expandOneSide(PriorityQueue<Node> open, Map<BlockPos, Node> nodesThis, Set<BlockPos> closedThis, Map<BlockPos, Node> nodesOther, Set<BlockPos> closedOther, Map<BlockPos, Node> closedOtherNodes, boolean isForward, BlockPos from, BlockPos to, ServerLevel level, TerrainSamplingCache cache, int[][] neighborOffsets, int d, ModConfig cfg) {
        if (open.isEmpty()) {
            return null;
        }
        Node current = open.poll();
        if (current == null) {
            return null;
        }
        closedThis.add(current.pos);
        for (int[] off : neighborOffsets) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            BlockPos nxz = current.pos.offset(off[0], 0, off[1]);
            int y = RoadPathCalculator.heightSampler(cache, nxz.getX(), nxz.getZ(), level);
            BlockPos np = new BlockPos(nxz.getX(), y, nxz.getZ());
            if (closedThis.contains(np)) continue;
            Holder<Biome> biome = cache.getBiome(level, np.getX(), np.getZ());
            int biomeCost = biome.is(BiomeTags.IS_RIVER) || biome.is(BiomeTags.IS_OCEAN) || biome.is(BiomeTags.IS_DEEP_OCEAN) ? 12 : 0;
            int elevation = Math.abs(y - current.pos.getY());
            int offsetSum = Math.abs(Math.abs(off[0])) + Math.abs(off[1]);
            double stepCost = offsetSum == 2 * d ? cfg.diagStepCost() : cfg.orthoStepCost();
            int stabilityCost = RoadPathCalculator.calculateTerrainStability(cache, np, y, level, d);
            int sea = level.getSeaLevel();
            boolean waterColumn = RoadPathCalculator.isColumnWater(cache, nxz.getX(), nxz.getZ(), level);
            boolean nearWater = RoadPathCalculator.isNearWaterLike(cache, nxz.getX(), nxz.getZ(), level);
            int oceanFloor = RoadPathCalculator.oceanFloorSampler(cache, nxz.getX(), nxz.getZ(), level);
            int waterDepth = Math.max(0, sea - oceanFloor);
            int waterDepthCost = waterColumn ? waterDepth * cfg.waterDepthWeight() : 0;
            int nearWaterCost = nearWater ? cfg.nearWaterCost() : 0;
            double deviation = BidirectionalAStarPathfinder.deviation2d(np, from, to);
            double deviationCost = deviation * cfg.deviationWeight() / Math.max(1.0, (double)d);
            double tentativeG = current.g + stepCost + (double)(elevation * cfg.elevationWeight()) + (double)(biomeCost * cfg.biomeWeight()) + (double)(stabilityCost * cfg.stabilityWeight()) + (double)waterDepthCost + (double)nearWaterCost + deviationCost;
            Node existing = nodesThis.get(np);
            if (existing != null && tentativeG >= existing.g) continue;
            double h = BidirectionalAStarPathfinder.heuristic(np, to, cfg);
            double fWeighted = tentativeG + 1.2 * h;
            Node next = new Node(np, current, tentativeG, fWeighted);
            nodesThis.put(np, next);
            open.add(next);
            Node other = nodesOther.get(np);
            if (other == null && closedOther.contains(np)) {
                other = closedOtherNodes.get(np);
            }
            if (other == null) continue;
            if (isForward) {
                return new Meet(next, other);
            }
            return new Meet(other, next);
        }
        return null;
    }

    private static List<Records.RoadSegmentPlacement> reconstructPath(Node meetForward, Node meetBackward, int width, ServerLevel level, TerrainSamplingCache cache) {
        Node backStart;
        ArrayList<BlockPos> rawPath = new ArrayList<BlockPos>();
        Node cur = meetForward;
        while (cur != null) {
            rawPath.add(cur.pos);
            cur = cur.parent;
        }
        Collections.reverse(rawPath);
        cur = backStart = meetBackward != null && meetBackward.pos.equals((Object)meetForward.pos) ? meetBackward.parent : meetBackward;
        while (cur != null) {
            rawPath.add(cur.pos);
            cur = cur.parent;
        }
        return PathPostProcessor.process(rawPath, width, level, cache);
    }

    private static double heuristic(BlockPos a, BlockPos b, ModConfig cfg) {
        int dx = a.getX() - b.getX();
        int dz = a.getZ() - b.getZ();
        double dxzApprox = (double)(Math.abs(dx) + Math.abs(dz)) - 0.6 * (double)Math.min(Math.abs(dx), Math.abs(dz));
        return dxzApprox * cfg.heuristicWeight();
    }

    private static double deviation2d(BlockPos p, BlockPos a, BlockPos b) {
        double ax = a.getX();
        double az = a.getZ();
        double bx = b.getX();
        double bz = b.getZ();
        double px = p.getX();
        double pz = p.getZ();
        double num = Math.abs((bz - az) * px - (bx - ax) * pz + bx * az - bz * ax);
        double den = Math.hypot(bx - ax, bz - az);
        if (den <= 0.0) {
            return 0.0;
        }
        return num / den;
    }

    private static final class Node {
        final BlockPos pos;
        final Node parent;
        final double g;
        final double f;

        Node(BlockPos pos, Node parent, double g, double f) {
            this.pos = pos;
            this.parent = parent;
            this.g = g;
            this.f = f;
        }
    }

    private static final class Meet {
        final Node forward;
        final Node backward;

        Meet(Node forward, Node backward) {
            this.forward = forward;
            this.backward = backward;
        }
    }
}

