/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.pathfinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.PathPostProcessor;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.RoadPathCalculator;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.runtime.ThreadPoolManager;

final class GradientDescentPathfinder {
    private static final int BIOME_BASE_COST = 12;
    private static final int SEARCH_BUFFER = 64;

    private GradientDescentPathfinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Records.RoadSegmentPlacement> calculatePath(BlockPos startGround, BlockPos endGround, int width, ServerLevel level, int maxSteps, TerrainSamplingCache cache) {
        ModConfig cfg = ConfigService.get();
        int minX = Math.min(startGround.getX(), endGround.getX()) - 64;
        int maxX = Math.max(startGround.getX(), endGround.getX()) + 64;
        int minZ = Math.min(startGround.getZ(), endGround.getZ()) - 64;
        int maxZ = Math.max(startGround.getZ(), endGround.getZ()) + 64;
        PriorityQueue<Node> openSet = new PriorityQueue<Node>(Comparator.comparingDouble(n -> n.fCost));
        HashMap<BlockPos, Node> allNodes = new HashMap<BlockPos, Node>();
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        Node startNode = new Node(startGround, null, 0.0, GradientDescentPathfinder.heuristic(startGround, endGround) * cfg.heuristicWeight());
        openSet.add(startNode);
        allNodes.put(startGround, startNode);
        int d = RoadPathCalculator.getNeighborDistance();
        int[][] neighborOffsets = new int[][]{{d, 0}, {-d, 0}, {0, d}, {0, -d}, {d, d}, {d, -d}, {-d, d}, {-d, -d}};
        int stepsBudget = Math.max(5000, maxSteps * 3);
        ThreadPoolManager.resetThrottle();
        try {
            while (!openSet.isEmpty() && stepsBudget-- > 0) {
                ThreadPoolManager.throttle();
                if (Thread.currentThread().isInterrupted()) {
                    List<Records.RoadSegmentPlacement> list = null;
                    return list;
                }
                Node current = openSet.poll();
                if (current == null) {
                    break;
                }
                if ((double)GradientDescentPathfinder.manhattan2d(current.pos, endGround) < (double)d * 1.5) {
                    List<Records.RoadSegmentPlacement> list = GradientDescentPathfinder.reconstructPath(current, width, level, cache);
                    return list;
                }
                closed.add(current.pos);
                for (Object object : (List<Records.RoadSegmentPlacement>)neighborOffsets) {
                    BlockPos nxz = current.pos.offset((int)object[0], 0, (int)object[1]);
                    if (nxz.getX() < minX || nxz.getX() > maxX || nxz.getZ() < minZ || nxz.getZ() > maxZ) continue;
                    int y = RoadPathCalculator.heightSampler(cache, nxz.getX(), nxz.getZ(), level);
                    BlockPos np = new BlockPos(nxz.getX(), y, nxz.getZ());
                    if (closed.contains(np)) continue;
                    Holder<Biome> biome = cache.getBiome(level, np.getX(), np.getZ());
                    int biomeCost = biome.is(BiomeTags.IS_RIVER) || biome.is(BiomeTags.IS_OCEAN) || biome.is(BiomeTags.IS_DEEP_OCEAN) ? 12 : 0;
                    int elevation = Math.abs(y - current.pos.getY());
                    int offsetSum = Math.abs(Math.abs((int)object[0])) + Math.abs((int)object[1]);
                    double stepCost = offsetSum == 2 * d ? cfg.diagStepCost() : cfg.orthoStepCost();
                    int stabilityCost = RoadPathCalculator.calculateTerrainStability(cache, np, y, level, d);
                    int sea = level.getSeaLevel();
                    boolean waterColumn = RoadPathCalculator.isColumnWater(cache, nxz.getX(), nxz.getZ(), level);
                    boolean nearWater = RoadPathCalculator.isNearWaterLike(cache, nxz.getX(), nxz.getZ(), level);
                    int oceanFloor = RoadPathCalculator.oceanFloorSampler(cache, nxz.getX(), nxz.getZ(), level);
                    int waterDepth = Math.max(0, sea - oceanFloor);
                    int waterDepthCost = waterColumn ? waterDepth * cfg.waterDepthWeight() : 0;
                    int nearWaterCost = nearWater ? cfg.nearWaterCost() : 0;
                    double elevationCost = elevation * elevation * cfg.elevationWeight();
                    double slope = (double)elevation / (double)Math.max(1, d);
                    if (slope > 0.5) {
                        elevationCost += 800.0 * slope;
                    }
                    if (slope > 0.8) {
                        elevationCost += 8000.0;
                    }
                    double gCost = current.gCost + stepCost + elevationCost + (double)(biomeCost * cfg.biomeWeight()) + (double)(stabilityCost * cfg.stabilityWeight()) + (double)waterDepthCost + (double)nearWaterCost;
                    double hCost = GradientDescentPathfinder.heuristic(np, endGround) * cfg.heuristicWeight();
                    double fCost = gCost + hCost;
                    Node n2 = (Node)allNodes.get(np);
                    if (n2 != null && !(gCost < n2.gCost)) continue;
                    n2 = new Node(np, current, gCost, fCost);
                    allNodes.put(np, n2);
                    openSet.add(n2);
                }
            }
        }
        finally {
            openSet.clear();
            allNodes.clear();
            closed.clear();
        }
        return null;
    }

    private static List<Records.RoadSegmentPlacement> reconstructPath(Node endNode, int width, ServerLevel level, TerrainSamplingCache cache) {
        ArrayList<BlockPos> rawPath = new ArrayList<BlockPos>();
        Node c = endNode;
        while (c != null) {
            rawPath.add(c.pos);
            c = c.parent;
        }
        Collections.reverse(rawPath);
        return PathPostProcessor.process(rawPath, width, level, cache);
    }

    private static int manhattan2d(BlockPos a, BlockPos b) {
        return Math.abs(a.getX() - b.getX()) + Math.abs(a.getZ() - b.getZ());
    }

    private static double heuristic(BlockPos a, BlockPos b) {
        double dx = a.getX() - b.getX();
        double dz = a.getZ() - b.getZ();
        return Math.sqrt(dx * dx + dz * dz);
    }

    private static final class Node {
        final BlockPos pos;
        final Node parent;
        final double gCost;
        final double fCost;

        Node(BlockPos pos, Node parent, double gCost, double fCost) {
            this.pos = pos;
            this.parent = parent;
            this.gCost = gCost;
            this.fCost = fCost;
        }
    }
}

