/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.pathfinding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.features.roadlogic.core.RoadDirection;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.BasicAStarPathfinder;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.BidirectionalAStarPathfinder;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.GradientDescentPathfinder;
import net.shiroha233.roadweaver.features.roadlogic.pathfinding.TerrainSamplingCache;
import net.shiroha233.roadweaver.helpers.Records;

public final class RoadPathCalculator {
    private RoadPathCalculator() {
    }

    static int getNeighborDistance() {
        try {
            int v = ConfigService.get().aStarStep();
            if (v < 4) {
                return 16;
            }
            if (v > 128) {
                return 128;
            }
            return v;
        }
        catch (Throwable ignore) {
            return 16;
        }
    }

    public static List<Records.RoadSegmentPlacement> calculateAStarRoadPath(BlockPos startIn, BlockPos endIn, int width, ServerLevel level, int maxSteps, TerrainSamplingCache cache) {
        int dGrid = RoadPathCalculator.getNeighborDistance();
        int sx = RoadPathCalculator.snapToGrid(startIn.getX(), dGrid);
        int sz = RoadPathCalculator.snapToGrid(startIn.getZ(), dGrid);
        int ex = RoadPathCalculator.snapToGrid(endIn.getX(), dGrid);
        int ez = RoadPathCalculator.snapToGrid(endIn.getZ(), dGrid);
        BlockPos start = new BlockPos(sx, startIn.getY(), sz);
        BlockPos end = new BlockPos(ex, endIn.getY(), ez);
        BlockPos startGround = new BlockPos(start.getX(), RoadPathCalculator.heightSampler(cache, start.getX(), start.getZ(), level), start.getZ());
        BlockPos endGround = new BlockPos(end.getX(), RoadPathCalculator.heightSampler(cache, end.getX(), end.getZ(), level), end.getZ());
        ModConfig.PathfindingAlgorithm algo = ConfigService.get().pathfindingAlgorithm();
        List<Records.RoadSegmentPlacement> land = algo == ModConfig.PathfindingAlgorithm.GRADIENT_DESCENT ? GradientDescentPathfinder.calculatePath(startGround, endGround, width, level, maxSteps, cache) : (algo == ModConfig.PathfindingAlgorithm.ASTAR_BIDIRECTIONAL ? BidirectionalAStarPathfinder.calculateLandPath(startGround, endGround, width, level, maxSteps, cache) : BasicAStarPathfinder.calculateLandPath(startGround, endGround, width, level, maxSteps, cache));
        return land;
    }

    static int calculateTerrainStability(TerrainSamplingCache cache, BlockPos pos, int y, ServerLevel level, int step) {
        int cost = 0;
        if (Math.abs(RoadPathCalculator.heightSampler(cache, pos.getX() + step, pos.getZ(), level) - y) > 0) {
            ++cost;
        }
        if (Math.abs(RoadPathCalculator.heightSampler(cache, pos.getX() - step, pos.getZ(), level) - y) > 0) {
            ++cost;
        }
        if (Math.abs(RoadPathCalculator.heightSampler(cache, pos.getX(), pos.getZ() + step, level) - y) > 0) {
            ++cost;
        }
        if (Math.abs(RoadPathCalculator.heightSampler(cache, pos.getX(), pos.getZ() - step, level) - y) > 0) {
            ++cost;
        }
        return cost;
    }

    static int heightSampler(TerrainSamplingCache cache, int x, int z, ServerLevel level) {
        return cache.height(level, x, z);
    }

    static boolean isWaterLike(TerrainSamplingCache cache, int x, int z, ServerLevel level) {
        return cache.isWaterLike(level, x, z);
    }

    static int oceanFloorSampler(TerrainSamplingCache cache, int x, int z, ServerLevel level) {
        return cache.oceanFloor(level, x, z);
    }

    static boolean isNearWaterLike(TerrainSamplingCache cache, int x, int z, ServerLevel level) {
        int d = RoadPathCalculator.getNeighborDistance();
        return cache.isNearWaterLike(level, x, z, d);
    }

    static boolean isColumnWater(TerrainSamplingCache cache, int x, int z, ServerLevel level) {
        return cache.isColumnWater(level, x, z);
    }

    static int snapToGrid(int v, int gridSize) {
        return Math.floorDiv(v, gridSize) * gridSize;
    }

    static Set<BlockPos> generateWidth(BlockPos center, int radius, Set<BlockPos> cache, RoadDirection dir) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        int cx = center.getX();
        int cz = center.getZ();
        int y = 0;
        if (dir == RoadDirection.X_AXIS) {
            for (int dz = -radius; dz <= radius; ++dz) {
                BlockPos p = new BlockPos(cx, y, cz + dz);
                if (!cache.add(p)) continue;
                set.add(p);
            }
        } else if (dir == RoadDirection.Z_AXIS) {
            for (int dx = -radius; dx <= radius; ++dx) {
                BlockPos p = new BlockPos(cx + dx, y, cz);
                if (!cache.add(p)) continue;
                set.add(p);
            }
        } else {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos p;
                    if (dir == RoadDirection.DIAGONAL_2 && (dx == -radius && dz == -radius || dx == radius && dz == radius) || dir == RoadDirection.DIAGONAL_1 && (dx == -radius && dz == radius || dx == radius && dz == -radius) || !cache.add(p = new BlockPos(cx + dx, y, cz + dz))) continue;
                    set.add(p);
                }
            }
        }
        return set;
    }

    public static List<Records.RoadSpan> extractSpans(List<Records.RoadSegmentPlacement> segments, ServerLevel level, TerrainSamplingCache cache) {
        int len;
        ArrayList<Records.RoadSpan> spans = new ArrayList<Records.RoadSpan>();
        if (segments == null || segments.isEmpty()) {
            return spans;
        }
        ArrayList<BlockPos> centers = new ArrayList<BlockPos>(segments.size());
        for (Records.RoadSegmentPlacement seg : segments) {
            centers.add(seg.middlePos());
        }
        int minWaterDepth = ConfigService.get().bridgeMinWaterDepth();
        int sea = level.getSeaLevel();
        boolean inWater = false;
        int waterStart = -1;
        for (int i = 0; i < centers.size(); ++i) {
            boolean water;
            BlockPos p = (BlockPos)centers.get(i);
            boolean isWater = RoadPathCalculator.isColumnWater(cache, p.getX(), p.getZ(), level);
            int waterDepth = 0;
            if (isWater) {
                int oceanFloor = RoadPathCalculator.oceanFloorSampler(cache, p.getX(), p.getZ(), level);
                waterDepth = Math.max(0, sea - oceanFloor);
            }
            boolean bl = water = isWater && waterDepth >= minWaterDepth;
            if (water && !inWater) {
                inWater = true;
                waterStart = i;
                continue;
            }
            if (water || !inWater) continue;
            int startIdx = Math.max(0, waterStart - 1);
            int endIdx = i;
            BlockPos start = (BlockPos)centers.get(startIdx);
            BlockPos end = (BlockPos)centers.get(Math.min(endIdx, centers.size() - 1));
            spans.add(new Records.RoadSpan(start, end, Records.SpanType.BRIDGE));
            inWater = false;
            waterStart = -1;
        }
        if (inWater && waterStart >= 0) {
            int startIdx = Math.max(0, waterStart - 1);
            BlockPos start = (BlockPos)centers.get(startIdx);
            BlockPos end = (BlockPos)centers.get(centers.size() - 1);
            spans.add(new Records.RoadSpan(start, end, Records.SpanType.BRIDGE));
        }
        int SLOPE_ABS_THRESHOLD = 4;
        int RUN_MIN_LENGTH = 3;
        int runStart = -1;
        for (int i = 1; i < centers.size(); ++i) {
            boolean steep;
            BlockPos a = (BlockPos)centers.get(i - 1);
            BlockPos b = (BlockPos)centers.get(i);
            int ya = RoadPathCalculator.heightSampler(cache, a.getX(), a.getZ(), level);
            int yb = RoadPathCalculator.heightSampler(cache, b.getX(), b.getZ(), level);
            int dy = Math.abs(yb - ya);
            boolean bl = steep = dy >= 4;
            if (steep) {
                if (runStart >= 0) continue;
                runStart = i - 1;
                continue;
            }
            if (runStart < 0) continue;
            int len2 = i - runStart;
            if (len2 >= 3) {
                BlockPos s = (BlockPos)centers.get(runStart);
                BlockPos e = (BlockPos)centers.get(i);
                spans.add(new Records.RoadSpan(s, e, Records.SpanType.TUNNEL));
            }
            runStart = -1;
        }
        if (runStart >= 0 && (len = centers.size() - runStart) >= 3) {
            BlockPos s = (BlockPos)centers.get(runStart);
            BlockPos e = (BlockPos)centers.get(centers.size() - 1);
            spans.add(new Records.RoadSpan(s, e, Records.SpanType.TUNNEL));
        }
        return spans;
    }
}

