/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.features.roadlogic.surface;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.shiroha233.roadweaver.config.ModConfig;

public final class RoadTerrainAdapter {
    private RoadTerrainAdapter() {
    }

    public static void adapt(WorldGenLevel level, BlockPos middle, int width, int targetY, RandomSource random, ModConfig cfg) {
        int halfWidth = (width + 1) / 2;
        int bankWidth = 3;
        int scanRadius = halfWidth + bankWidth;
        int cx = middle.getX();
        int cz = middle.getZ();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int dx = -scanRadius; dx <= scanRadius; ++dx) {
            for (int dz = -scanRadius; dz <= scanRadius; ++dz) {
                int fillTopY;
                double desiredY;
                int surfaceY;
                double distSq = (double)dx * (double)dx + (double)dz * (double)dz;
                double dist = Math.sqrt(distSq);
                if (dist > (double)scanRadius) continue;
                int x = cx + dx;
                int z = cz + dz;
                boolean isRoadSurface = dist <= (double)halfWidth;
                double edgeDist = dist - (double)halfWidth;
                if (edgeDist < 0.0) {
                    edgeDist = 0.0;
                }
                if (edgeDist > (double)bankWidth && !isRoadSurface || targetY - 1 <= (surfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z))) continue;
                double targetBelowRoad = targetY - 1;
                if (isRoadSurface) {
                    desiredY = targetBelowRoad;
                } else {
                    double t;
                    double d = t = bankWidth <= 0 ? 1.0 : edgeDist / (double)bankWidth;
                    if (t < 0.0) {
                        t = 0.0;
                    }
                    if (t > 1.0) {
                        t = 1.0;
                    }
                    double s = t * t * (3.0 - 2.0 * t);
                    desiredY = targetBelowRoad * (1.0 - s) + (double)surfaceY * s;
                }
                if (desiredY >= (double)targetY) {
                    desiredY = targetY - 1;
                }
                if ((fillTopY = (int)Math.floor(desiredY)) <= surfaceY) continue;
                cursor.set(x, surfaceY - 1, z);
                BlockState topState = level.getBlockState((BlockPos)cursor);
                if (topState.isAir() || topState.getFluidState().isSource()) {
                    topState = Blocks.DIRT.defaultBlockState();
                }
                BlockState innerFill = topState;
                BlockState surfaceFill = topState;
                if (topState.is(Blocks.GRASS_BLOCK) || topState.is(Blocks.DIRT)) {
                    innerFill = Blocks.DIRT.defaultBlockState();
                    surfaceFill = Blocks.GRASS_BLOCK.defaultBlockState();
                }
                for (int y = surfaceY; y <= fillTopY; ++y) {
                    cursor.setY(y);
                    BlockState cur = level.getBlockState((BlockPos)cursor);
                    if (!cur.canBeReplaced()) continue;
                    if (y == fillTopY && !isRoadSurface) {
                        level.setBlock((BlockPos)cursor, surfaceFill, 2);
                        continue;
                    }
                    level.setBlock((BlockPos)cursor, innerFill, 2);
                }
            }
        }
    }
}

