/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.shiroha233.roadweaver.client.map.data.MapSnapshot;
import net.shiroha233.roadweaver.helpers.Records;

public final class MapSnapshotCodec {
    private MapSnapshotCodec() {
    }

    public static void write(FriendlyByteBuf buf, MapSnapshot s) {
        List<BlockPos> structures = s.structures();
        List<Records.StructureConnection> conns = s.connections();
        buf.writeVarInt(structures.size());
        for (BlockPos p : structures) {
            buf.writeBlockPos(p);
        }
        for (BlockPos p : structures) {
            String name = s.structureName(p);
            boolean has = name != null;
            buf.writeBoolean(has);
            if (!has) continue;
            buf.writeUtf(name);
        }
        buf.writeVarInt(conns.size());
        for (Records.StructureConnection c : conns) {
            buf.writeBlockPos(c.from());
            buf.writeBlockPos(c.to());
            buf.writeVarInt(c.status().ordinal());
        }
        List<List<BlockPos>> roads = s.roadPolylines();
        buf.writeVarInt(roads.size());
        for (List<BlockPos> pl : roads) {
            buf.writeVarInt(pl.size());
            for (BlockPos p : pl) {
                buf.writeBlockPos(p);
            }
        }
    }

    public static MapSnapshot read(FriendlyByteBuf buf) {
        int sc = buf.readVarInt();
        ArrayList<BlockPos> structures = new ArrayList<BlockPos>(sc);
        for (int i = 0; i < sc; ++i) {
            structures.add(buf.readBlockPos());
        }
        ArrayList<Records.StructureInfo> infos = new ArrayList<Records.StructureInfo>(sc);
        for (int i = 0; i < sc; ++i) {
            boolean has = buf.readBoolean();
            if (!has) continue;
            String id = buf.readUtf();
            infos.add(new Records.StructureInfo((BlockPos)structures.get(i), id));
        }
        int cc = buf.readVarInt();
        ArrayList<Records.StructureConnection> conns = new ArrayList<Records.StructureConnection>(cc);
        for (int i = 0; i < cc; ++i) {
            BlockPos a = buf.readBlockPos();
            BlockPos b = buf.readBlockPos();
            int ord = buf.readVarInt();
            Records.ConnectionStatus st = Records.ConnectionStatus.values()[ord];
            conns.add(new Records.StructureConnection(a, b, st));
        }
        int rp = buf.readVarInt();
        ArrayList<List<BlockPos>> roads = new ArrayList<List<BlockPos>>(rp);
        for (int i = 0; i < rp; ++i) {
            int pc = buf.readVarInt();
            ArrayList<BlockPos> poly = new ArrayList<BlockPos>(pc);
            for (int j = 0; j < pc; ++j) {
                poly.add(buf.readBlockPos());
            }
            roads.add(poly);
        }
        return new MapSnapshot(structures, conns, infos, roads);
    }
}

