/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.network.neoforge;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.shiroha233.roadweaver.client.map.RoadMapScreen;
import net.shiroha233.roadweaver.client.map.data.MapDataCollector;
import net.shiroha233.roadweaver.client.map.data.MapSnapshot;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.config.ModConfig;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.network.MapSnapshotCodec;
import net.shiroha233.roadweaver.persistence.WorldDataProvider;
import net.shiroha233.roadweaver.util.ComputeService;

public class MapNetworkForge {
    public static final ResourceLocation REQ_RECT_ID = ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)"map_request_rect");
    public static final ResourceLocation SNAP_ID = ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)"map_snapshot");
    public static final ResourceLocation TP_REQ_ID = ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)"map_teleport");
    public static final ResourceLocation TP_ACK_ID = ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)"map_teleport_ack");
    public static final ResourceLocation MAN_REQ_ID = ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)"map_manual_connect");

    public static void register(IEventBus modBus) {
        modBus.addListener(MapNetworkForge::registerPayloads);
    }

    private static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(MapSnapshotS2C.TYPE, MapSnapshotS2C.CODEC, MapSnapshotS2C::handle);
        registrar.playToClient(TeleportAckS2C.TYPE, TeleportAckS2C.CODEC, TeleportAckS2C::handle);
        registrar.playToServer(RequestMapSnapshotC2S.TYPE, RequestMapSnapshotC2S.CODEC, RequestMapSnapshotC2S::handle);
        registrar.playToServer(TeleportC2S.TYPE, TeleportC2S.CODEC, TeleportC2S::handle);
        registrar.playToServer(ManualConnectC2S.TYPE, ManualConnectC2S.CODEC, ManualConnectC2S::handle);
    }

    public static void requestSnapshot(int minX, int minZ, int maxX, int maxZ) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestMapSnapshotC2S(minX, minZ, maxX, maxZ), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void requestTeleport(int x, int y, int z) {
        PacketDistributor.sendToServer((CustomPacketPayload)new TeleportC2S(x, y, z), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void requestManualConnect(int ax, int az, int bx, int bz) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ManualConnectC2S(ax, az, bx, bz), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public record MapSnapshotS2C(MapSnapshot snapshot) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<MapSnapshotS2C> TYPE = new CustomPacketPayload.Type(SNAP_ID);
        public static final StreamCodec<FriendlyByteBuf, MapSnapshotS2C> CODEC = StreamCodec.of((buf, v) -> MapSnapshotCodec.write(buf, v.snapshot), buf -> new MapSnapshotS2C(MapSnapshotCodec.read(buf)));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(MapSnapshotS2C payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.getInstance();
                Screen patt0$temp = mc.screen;
                if (patt0$temp instanceof RoadMapScreen) {
                    RoadMapScreen screen = (RoadMapScreen)patt0$temp;
                    screen.setSnapshot(payload.snapshot);
                }
            });
        }
    }

    public record TeleportAckS2C(boolean ok, int x, int y, int z) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<TeleportAckS2C> TYPE = new CustomPacketPayload.Type(TP_ACK_ID);
        public static final StreamCodec<FriendlyByteBuf, TeleportAckS2C> CODEC = StreamCodec.of((buf, v) -> {
            buf.writeBoolean(v.ok);
            buf.writeVarInt(v.x);
            buf.writeVarInt(v.y);
            buf.writeVarInt(v.z);
        }, buf -> new TeleportAckS2C(buf.readBoolean(), buf.readVarInt(), buf.readVarInt(), buf.readVarInt()));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(TeleportAckS2C payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.getInstance();
                if (mc.player == null) {
                    return;
                }
                if (payload.ok) {
                    mc.player.displayClientMessage((Component)Component.translatable((String)"gui.roadweaver.map.teleport.success_pos", (Object[])new Object[]{payload.x, payload.y, payload.z}), true);
                } else {
                    mc.player.displayClientMessage((Component)Component.translatable((String)"gui.roadweaver.map.teleport.denied"), true);
                }
            });
        }
    }

    public record RequestMapSnapshotC2S(int minX, int minZ, int maxX, int maxZ) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<RequestMapSnapshotC2S> TYPE = new CustomPacketPayload.Type(REQ_RECT_ID);
        public static final StreamCodec<FriendlyByteBuf, RequestMapSnapshotC2S> CODEC = StreamCodec.of((buf, v) -> {
            buf.writeVarInt(v.minX);
            buf.writeVarInt(v.minZ);
            buf.writeVarInt(v.maxX);
            buf.writeVarInt(v.maxZ);
        }, buf -> new RequestMapSnapshotC2S(buf.readVarInt(), buf.readVarInt(), buf.readVarInt(), buf.readVarInt()));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(RequestMapSnapshotC2S payload, IPayloadContext context) {
            int radiusChunks;
            ServerPlayer sp = (ServerPlayer)context.player();
            int cx = (int)Math.round(sp.getX());
            int cz = (int)Math.round(sp.getZ());
            try {
                ModConfig cfg = ConfigService.get();
                radiusChunks = cfg.dynamicPlanEnabled() ? cfg.dynamicPlanRadiusChunks() : cfg.initialPlanRadiusChunks();
            }
            catch (Throwable t) {
                radiusChunks = 256;
            }
            int radiusBlocks = Math.max(1, radiusChunks) * 16;
            CompletableFuture.supplyAsync(() -> MapDataCollector.build(sp.serverLevel(), payload.minX, payload.minZ, payload.maxX, payload.maxZ, cx, cz, radiusBlocks), ComputeService.executor()).thenAccept(snapshot -> context.enqueueWork(() -> PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new MapSnapshotS2C((MapSnapshot)snapshot), (CustomPacketPayload[])new CustomPacketPayload[0])));
        }
    }

    public record TeleportC2S(int x, int y, int z) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<TeleportC2S> TYPE = new CustomPacketPayload.Type(TP_REQ_ID);
        public static final StreamCodec<FriendlyByteBuf, TeleportC2S> CODEC = StreamCodec.of((buf, v) -> {
            buf.writeVarInt(v.x);
            buf.writeVarInt(v.y);
            buf.writeVarInt(v.z);
        }, buf -> new TeleportC2S(buf.readVarInt(), buf.readVarInt(), buf.readVarInt()));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(TeleportC2S payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                boolean allowed;
                ServerPlayer sp = (ServerPlayer)context.player();
                boolean bl = allowed = sp.isCreative() || sp.hasPermissions(2);
                if (!allowed) {
                    PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new TeleportAckS2C(false, 0, 0, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return;
                }
                ServerLevel level = sp.serverLevel();
                level.getChunk(payload.x >> 4, payload.z >> 4);
                int ty = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, payload.x, payload.z);
                ty = ty <= level.getMinBuildHeight() ? level.getSeaLevel() + 1 : ++ty;
                sp.teleportTo(level, (double)payload.x + 0.5, (double)ty, (double)payload.z + 0.5, sp.getYRot(), sp.getXRot());
                PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new TeleportAckS2C(true, payload.x, ty, payload.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            });
        }
    }

    public record ManualConnectC2S(int ax, int az, int bx, int bz) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ManualConnectC2S> TYPE = new CustomPacketPayload.Type(MAN_REQ_ID);
        public static final StreamCodec<FriendlyByteBuf, ManualConnectC2S> CODEC = StreamCodec.of((buf, v) -> {
            buf.writeVarInt(v.ax);
            buf.writeVarInt(v.az);
            buf.writeVarInt(v.bx);
            buf.writeVarInt(v.bz);
        }, buf -> new ManualConnectC2S(buf.readVarInt(), buf.readVarInt(), buf.readVarInt(), buf.readVarInt()));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(ManualConnectC2S payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                ServerPlayer sp = (ServerPlayer)context.player();
                ServerLevel level = sp.serverLevel();
                WorldDataProvider provider = WorldDataProvider.getInstance();
                List<Records.StructureConnection> origin = provider.getStructureConnections(level);
                ArrayList<Records.StructureConnection> list = origin != null ? new ArrayList<Records.StructureConnection>(origin) : new ArrayList();
                BlockPos a = new BlockPos(payload.ax, 0, payload.az);
                BlockPos b = new BlockPos(payload.bx, 0, payload.bz);
                boolean exists = false;
                for (Records.StructureConnection c : list) {
                    BlockPos f = c.from();
                    BlockPos t = c.to();
                    if ((!f.equals((Object)a) || !t.equals((Object)b)) && (!f.equals((Object)b) || !t.equals((Object)a))) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    list.add(new Records.StructureConnection(a, b, Records.ConnectionStatus.PLANNED));
                    provider.setStructureConnections(level, list);
                }
            });
        }
    }
}

