/*
 * Decompiled with CFR 0.152.
 */
package net.shiroha233.roadweaver.persistence;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.WorldGenLevel;
import net.shiroha233.roadweaver.config.ConfigService;
import net.shiroha233.roadweaver.helpers.Records;
import net.shiroha233.roadweaver.persistence.sharded.RoadShardStorage;

public final class RoadPositionQuery {
    private static final Map<String, Map<Long, Set<Long>>> CHUNK_CACHE = new ConcurrentHashMap<String, Map<Long, Set<Long>>>();
    private static final int EXTRA_MARGIN = 1;
    private static final int Y_CHECK_ABOVE = 12;
    private static final int Y_CHECK_BELOW = 2;

    private RoadPositionQuery() {
    }

    public static boolean isOnRoad(ServerLevel level, BlockPos pos) {
        if (level == null || pos == null) {
            return false;
        }
        if (!ConfigService.get().preventTreesOnRoad()) {
            return false;
        }
        int cx = pos.getX() >> 4;
        int cz = pos.getZ() >> 4;
        long chunkKey = RoadPositionQuery.chunkKey(cx, cz);
        String dimKey = RoadPositionQuery.dimKey(level);
        Map dimCache = CHUNK_CACHE.computeIfAbsent(dimKey, k -> new ConcurrentHashMap());
        Set roadPoints = dimCache.computeIfAbsent(chunkKey, k -> RoadPositionQuery.buildChunkRoadPoints(level, cx, cz));
        if (roadPoints.isEmpty()) {
            return false;
        }
        int tx = pos.getX();
        int ty = pos.getY();
        int tz = pos.getZ();
        int margin = ConfigService.get().roadWidth() / 2 + 1;
        Iterator iterator = roadPoints.iterator();
        while (iterator.hasNext()) {
            int yDiff;
            long packed = (Long)iterator.next();
            BlockPos road = BlockPos.of((long)packed);
            if (Math.abs(tx - road.getX()) > margin || Math.abs(tz - road.getZ()) > margin || (yDiff = ty - road.getY()) < -2 || yDiff > 12) continue;
            return true;
        }
        return false;
    }

    private static Set<Long> buildChunkRoadPoints(ServerLevel level, int cx, int cz) {
        int minX = cx << 4;
        int minZ = cz << 4;
        int maxX = minX + 15;
        int maxZ = minZ + 15;
        List<Records.RoadData> roads = RoadShardStorage.queryRect(level, minX - 8, minZ - 8, maxX + 8, maxZ + 8);
        if (roads.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> points = new HashSet<Long>();
        for (Records.RoadData rd : roads) {
            if (rd.roadSegmentList() == null) continue;
            for (Records.RoadSegmentPlacement seg : rd.roadSegmentList()) {
                RoadPositionQuery.addIfInChunk(points, seg.middlePos(), minX, minZ, maxX, maxZ);
                if (seg.positions() == null) continue;
                for (BlockPos p : seg.positions()) {
                    RoadPositionQuery.addIfInChunk(points, p, minX, minZ, maxX, maxZ);
                }
            }
        }
        return points.isEmpty() ? Collections.emptySet() : points;
    }

    private static void addIfInChunk(Set<Long> set, BlockPos p, int minX, int minZ, int maxX, int maxZ) {
        int x = p.getX();
        int z = p.getZ();
        if (x >= minX - 8 && x <= maxX + 8 && z >= minZ - 8 && z <= maxZ + 8) {
            set.add(p.asLong());
        }
    }

    public static boolean isOnRoad(WorldGenLevel level, BlockPos pos) {
        ServerLevel sl = RoadPositionQuery.extractServerLevel(level);
        return sl != null && RoadPositionQuery.isOnRoad(sl, pos);
    }

    private static ServerLevel extractServerLevel(WorldGenLevel level) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            return sl;
        }
        if (level instanceof WorldGenRegion) {
            WorldGenRegion region = (WorldGenRegion)level;
            return region.getLevel();
        }
        return null;
    }

    private static long chunkKey(int cx, int cz) {
        return (long)cx << 32 | (long)cz & 0xFFFFFFFFL;
    }

    private static String dimKey(ServerLevel level) {
        return level.dimension().location().toString();
    }

    public static void clearCache(ServerLevel level) {
        if (level != null) {
            CHUNK_CACHE.remove(RoadPositionQuery.dimKey(level));
        }
    }

    public static void clearAllCache() {
        CHUNK_CACHE.clear();
    }
}

